.TH ftpReplyGet 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpReplyGet - get FTP command reply
.SH SYNOPSIS
.CS
.nf
int ftpReplyGet (ctrlSock, expecteof)
    int ctrlSock;   /* control socket fd of FTP connection */
    BOOL expecteof; /* TRUE = EOF expected, FALSE = EOF is error */
.fi
.CE
.SH DESCRIPTION
This routine gets a command reply on the specified control socket.
All the lines of a single reply are read (multi-line replies are
indicated by a continuation character '-' as the fourth character
of all but the last line).

The three digit reply code from the first line is saved and interpreted.
The most significant digit of the reply code classifies the type of the code
(see below).  This digit is returned as the result of this function.
If the reply code indicates an error, the entire text of the reply
is printed on standard error.

The caller's task status is set to the complete three digit reply code
(see errnoGet (2)).

If an EOF is encountered on the specified control socket, but no EOF was
expected (expecteof == FALSE) then ERROR is returned.

.SH RETURNS
  ERROR if read error or unexpected EOF;
    or
  FTP reply code most significant digit (reply class):
     FTP_PRELIM       1 - positive preliminary 
     FTP_COMPLETE     2 - positive completion
     FTP_CONTINUE     3 - positive intermediate
     FTP_TRANSIENT    4 - transient negative completion
     FTP_ERROR        5 - permanent negative completion
.SH SEE ALSO
ftpLib(1)
