.TH ftpDataConnGet 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpDataConnGet - get a completed FTP data connection
.SH SYNOPSIS
.CS
.nf
int ftpDataConnGet (dataSock)
    int dataSock; /* fd of data socket on which to await connection */
.fi
.CE
.SH DESCRIPTION
This routine completes a data connection initiated by a call to
ftpDataConnInit (2).  It waits for a connection on the specified socket
from the remote FTP server.  The specified socket should be the one
returned by ftpDataConnInit (2).
The connection is established on a new socket, whose fd is returned
as the result of this function.  The original socket, specified in the
argument to this routine, is closed.

Typically this routine is called after calling ftpDataConnInit (2) and
ftpCommand (2) to initiate a data transfer from/to the remote FTP server.

.SH RETURNS
 fd of new data socket, or
 ERROR if accept failed

.SH SEE ALSO
ftpLib(1),
ftpDataConnInit (2), ftpCommand (2)
