.TH ftpCommand 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpCommand - send FTP command and get reply
.SH SYNOPSIS
.CS
.nf
int ftpCommand (ctrlSock, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
    int ctrlSock;     /* fd of control connection socket */
    char *fmt;        /* format string of command to send */
    int arg1;         /* arguments to format string */
    int arg2;
    int arg3;
    int arg4;
    int arg5;
    int arg6;
.fi
.CE
.SH DESCRIPTION
This routine sends the specified command on the specified socket, which
should be a control connection to a remote FTP server.
The command is specified as a "printf" style format string with up
to 6 arguments.

This routine sends the command and then waits for the reply from the
remote server.  The FTP reply code is returned just as in the call to
routine ftpReplyGet (2).

.SH EXAMPLE
.CS
   ftpCommand (ctrlSock, "TYPE I");            /* image-type xfer *
   ftpCommand (ctrlSock, "STOR %s", filename); /* init file write *
.CE

.SH RETURNS
  ERROR if read/write error or unexpected EOF;
    or
  FTP reply code most significant digit (reply class)
  (see ftpReplyGet (2) for details).

.SH SEE ALSO
ftpLib(1),
ftpReplyGet(2)

