.TH fopen 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fopen - open a stream on a file
.SH SYNOPSIS
.CS
.nf
FILE *fopen (filename, type)
    char *filename;     /* name of file */
    char *type;         /* mode to open file */
.fi
.CE
.SH DESCRIPTION
The routine fopen opens the file named `filename' and associates
it with a stream.  The returned FILE pointer is used to identify
the stream with subsequent operations.

The type is a character string consisting of:
  "r" - read
  "w" - write
  "a" - update, open for write at end, or create if doesn't exist

In addition, a following "+" indicates that the file is opened
for both reading and writing.
  "r+" - position at the beginning
  "w+" - create or truncate
  "a+" - position at the end

Both reads and writes may be intermixed as long as an intervening
fseek (2) or rewind (2) occurrs.

.SH RETURNS
   file pointer, or
   NULL if unable to open file

.SH SEE ALSO
stdioLib(1),
freopen(2), fdopen(2)
