.TH fcvtb 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fcvtb - convert floating point to ASCII representation (Fortran-style)
.SH SYNOPSIS
.CS
.nf
char *fcvtb (value, ndigit, decpt, sign, buffer)
    double value; /* value to be converted                        */
    int ndigit;   /* number of digits before or after decimal point */
    int *decpt;   /* position of decimal point in buffer          */
    int *sign;    /* 0 == positive, 1 == negative                 */
    char *buffer; /* where to put ASCII conversion of arg + EOS   */
.fi
.CE
.SH DESCRIPTION
fcvtb is identical to ecvtb (2), except that the correct digit has
been rounded for Fortran F-format style output with `ndigit' digits
to the right of the decimal point.  `ndigit' can be negative to
indicate rounding to the left of the decimal point.

.SH RETURNS
Pointer to buffer, for UNIX similarity.  `buffer' should
contain at least 350 (for IEEE support) + max (0, `ndigit') characters
to accomodate any double-precision value.
.SH SEE ALSO
floatLib(1)
