.TH excHookAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
excHookAdd - specify routine to be called on exceptions
.SH SYNOPSIS
.CS
.nf
VOID excHookAdd (excepHook)
    FUNCPTR excepHook; /* routine to be called when exceptions occur */
.fi
.CE
.SH DESCRIPTION
This routine allows a routine to be specified that will be called
whenever a hardware exception occurs.  This routine will be called
at the end of the normal exception handling, which includes suspending
the task that incurred the exception and printing out all pertinent
information about the exception.

The additional exception handling routine should be declared as follows:
.CS

  VOID myHandler (task, vecNum, pEsf)
     int task;            /* id of offending task *
     int vecNum;          /* exception vector number *
     ESF0 *pEsf;          /* pointer to exception stack frame *

.CE

The "task" is the id of the task that was running when the exception
occurred.

This facility is normally used by dbgLib (1) to activate its exception
mechanism.  If an application provides its own handler, it will deactivate
dbgLib's mechanism.
.SH SEE ALSO
excLib(1)
