.TH etherOutputHookAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
etherOutputHookAdd - add routine to receive all ethernet output packets
.SH SYNOPSIS
.CS
.nf
STATUS etherOutputHookAdd (outputHook)
    FUNCPTR outputHook; /* routine to receive ethernet output */
.fi
.CE
.SH DESCRIPTION
This routine adds a hook routine that will be called for every ethernet
packet that is to be transmitted.

Calling sequence of output hook routine:
.CS
 BOOL outputHook (pIf, buffer, length)
     struct ifnet *pIf; /* ptr to interface packet will be sent on *
     char *buffer;      /* ptr to packet to be transmitted         *
     int length;        /* length of packet to be transmitted      *
.CE
The hook will be called immediately before transmission.
The hook routine should return TRUE if it has handled the output packet and
no further action should be taken with it.  It should return FALSE
if it has not handled the output packet and normal transmission
should take place.

The ethernet packet data is in a temporary buffer when the hook routine
is called.  This buffer will be reused upon return from the hook.
The hook routine should copy the packet elsewhere if it needs
to retain the output packet.

.SH IMPLEMENTATION
To effect the hook, a call out to etherOutputHook should be included
in the transmit routine of every ethernet driver that is to be included
in this mechanism.

.SH RETURNS
OK (always)
.SH SEE ALSO
etherLib(1)
