.TH ecvtb 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ecvtb - convert floating point to ASCII representation
.SH SYNOPSIS
.CS
.nf
char *ecvtb (value, ndigit, decpt, sign, buffer)
    double value; /* value to be converted                        */
    int ndigit;   /* number of digits to place into buffer        */
    int *decpt;   /* position of decimal point in buffer          */
    int *sign;    /* 0 == positive, 1 == negative                 */
    char *buffer; /* where to put ASCII conversion of arg + EOS   */
.fi
.CE
.SH DESCRIPTION
ecvtb converts a floating point number to an ASCII decimal representation.
The number of digits is specified by ndigit.
The position of the decimal point relative to the beginning of the
string is stored indirectly through `decpt'.
If `decpt' is negative then the decimal point is to the left of
the returned digits.
If the sign of `value' is negative, the word pointed to by sign
is non-zero.  The low-order digit is rounded.

This routine is identical to the UNIX ecvt routine, except that the
buffer must be passed.  Therefore, this routine is re-entrant, while
UNIX ecvt is not.

.SH RETURNS
Pointer to buffer, for UNIX similarity.
.SH SEE ALSO
floatLib(1)
