.TH dbgInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
dbgInit - initialize debug package
.SH SYNOPSIS
.CS
.nf
STATUS dbgInit (breakpointTrapNum)
    int breakpointTrapNum; /* trap number for breakpoints */
.fi
.CE
.SH DESCRIPTION
This routine installs the debug package.  This involves:

      - setting the interrupt vectors of the breakpoint
        and trace hardware interrupts to the appropriate
        debug interrupt handlers,

      - adding the debug task switch routine to the kernel 
        context switch call out,

      - setting the terminal "abort" function to restart
        the shell,

      - setting the exception handling extension to
        trace and restart the shell if the exception
        occurred in the shell task.

.SH WHEN TO CALL
It is usually desirable to install the debugging facilities
as early as possible in system initialization, if the debugging facilities
are to be included at all.  It should not, however, be called until 
the pipe driver, the ty driver used for logging, the exception handler
library (excLib (1)), and message logging library (logLib (1)) have
been initialized.

.SH RETURNS
OK, or ERROR if unable to install task switch routine
.SH SEE ALSO
dbgLib(1)
