.TH copy 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
copy - copy `in' (or standard input) to `out' (or standard output)
.SH SYNOPSIS
.CS
.nf
STATUS copy (in, out)
    char *in;  /* name of file to read  (if NULL assume stdin)  */
    char *out; /* name of file to write (if NULL assume stdout) */
.fi
.CE
.SH DESCRIPTION
This routine copies from the input file to the output file, until an
end-of-file is reached.

.SH EXAMPLES
.CS
      copy <dog               - prints the file dog, on default
                                file device, on the console.
      copy >/ct0/dog          - copies from the console to file
                                dog, on device /ct0/, until an
                                <EOF> (default ^D) is typed.
      copy <dog >/ct0/dog     - copies the file dog, on default
                                file device, to device /ct0/.
      copy "file1", "file2"   - conventional copy from file named
                                'file1' to file named 'file2'.
.CE

Remember that standard input and output are global, so that spawning
the first three constructs will not work as expected.

.SH RETURNS
 OK, or
 ERROR if unable to open/create in or out, or
 error in copying from `in' to `out'

.SH SEE ALSO
usrLib(1),
copyStreams (2), tyEOFSet (2)
