.TH cd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
cd - change default directory
.SH SYNOPSIS
.CS
.nf
STATUS cd (name)
    char *name;         /* new directory name */
.fi
.CE
.SH DESCRIPTION
This routine sets the default directory to `name'.
The default directory is a device name optionally followed
by a directory local to that device.

To change to a different directory specify:

 - an entire path name with a device name, possibly followed by a
     directory name; the entire path name changes.
 - a directory name starting with a '~' or '/' or '$'. The directory part
     of the path (immediately after the device name) is replaced
     with the new directory name.
 - a directory name to be appended to the current default directory.
     The directory name is appended to the current default directory.

An instance of ".." indicates to go up one level in the directory tree.

.SH EXAMPLES
.CS
 cd "/fd0/"              - change to device "/fd0/"
 cd "wrs:~leslie/vw"     - change to device "wrs:" with local
                           directory "~leslie/vw".
 cd "config"             - after the previous command, the new
                           directory is "wrs:~leslie/vw/config".
 cd "../demo"            - after the previous command, the new
                           directory is "wrs:~leslie/vw/demo".
 cd "/etc"               - after the previous step, the new
                           directory is "wrs:/etc".
.CE
Note that `~' is only used on network devices.

.SH SEE ALSO
usrLib(1),
pwd (2)
