.TH bootNetmaskExtract 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
bootNetmaskExtract - extract netmask field from adrs:mask field
.SH SYNOPSIS
.CS
.nf
STATUS bootNetmaskExtract (string, pNetmask)
    char *string;      /* string containing adrs field */
    int *pNetmask;     /* pointer where to return netmask */
.fi
.CE
.SH DESCRIPTION
This routine extracts the optional subnet mask field from an internet address
field.  Subnet masks can be specified for an internet interface by appending
to the internet address a colon and the net mask in hex.  For example, the
"inet on ethernet" field of the boot parameters could be specified as:

   inet on ethernet: 90.1.0.1:ffff0000

In this case, the network portion of the address (normally just 90)
is extended by the subnet mask (to 90.1).  This routine picks off the
optional trailing subnet mask by replacing the colon in the specified
string with an EOS and then scanning the remainder as a hex number.
This number, the net mask, is returned via the ``pNetmask'' pointer.

.SH RETURNS
   1 if netmask specified correctly
   0 if netmask not specified
  -1 if invalid netmask specified
.SH SEE ALSO
bootLib(1)
