.TH bootBpAnchorExtract 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
bootBpAnchorExtract - extract backplane anchor field from bp=addr field
.SH SYNOPSIS
.CS
.nf
STATUS bootBpAnchorExtract (string, pAnchorAdrs)
    char *string;       /* string containing adrs field */
    char **pAnchorAdrs; /* pointer where to return anchor address */
.fi
.CE
.SH DESCRIPTION
This routine extracts the optional backplane anchor address field from a
boot device field.  The anchor can be specified for the backplane
driver by appending to the device name (i.e. "bp") a "=" and the
address in hex.  For example, the "boot device" field of the boot
parameters could be specified as:

   boot device: bp=800000

In this case, the backplane anchor address would be at address 0x800000,
instead of the default specified in config.h.

This routine picks off the optional trailing anchor address by replacing
the "=" in the specified string with an EOS and then scanning the
remainder as a hex number.
This number, the anchor address, is returned via the ``pAnchorAdrs'' pointer.

.SH RETURNS
   1 if anchor address specified correctly
   0 if anchor address not specified
  -1 if invalid anchor address specified
.SH SEE ALSO
bootLib(1)
