.TH bcopyLongs 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
bcopyLongs - copy one buffer to another a long at a time
.SH SYNOPSIS
.CS
.nf
VOID bcopyLongs (source, destination, nlongs)
    char *source;         /* pointer to source buffer      *
    char *destination;    /* pointer to destination buffer *
    int nlongs;           /* number of longs to copy       *
.fi
.CE
.SH DESCRIPTION
This routine copies the first `nlongs' characters from
`source' to `destination'.
It is similar to bcopy except that the copy is always performed
a long at a time.  This may be desirable if one of the buffers
can only be accessed with long instructions, as in certain long-wide
memory-mapped peripherals.  The source and destination must be long-aligned.

.SH SEE ALSO
bALib(1),
bcopy (2)
