.TH chapter 2 "" "VxWorks Reference Manual"
.ad b
.in 0
.ce 1
\s+2\fBSECTION 2: SUBROUTINES\fR\s-2
.sp 1
.ce 1
\fBTABLE OF CONTENTS\fR
.nf
.sp 2
.ta 1.3i
a0	- return the contents of register a0 (also "a1-7", "d0-7")
abs	- absolute value of integer
accept	- accept a connection on a socket
acos	- floating point arc-cosine
asin	- floating point arcsine
atan	- floating point arctangent
b	- set breakpoint
bcmp	- compare one buffer to another
bcopy	- copy one buffer to another
bcopyBytes	- copy one buffer to another a byte at a time
bcopyLongs	- copy one buffer to another a long at a time
bcopyWords	- copy one buffer to another a word at a time
bd	- delete breakpoint
bdall	- delete all breakpoints
bfill	- fill buffer with character
bfillBytes	- fill buffer with character a byte at a time
bind	- bind a name to a socket
binvert	- invert the order of bytes in a buffer
bootBpAnchorExtract	- extract backplane anchor field from bp=addr field
bootChange	- change the boot line
bootNetmaskExtract	- extract netmask field from adrs:mask field
bootParamsPrompt	- prompt for boot line parameters
bootParamsShow	- print boot line parameters
bootParamsToString	- construct a boot line
bootStringToParams	- interpret the boot parameters from the boot line
bswap	- swap buffers
bzero	- zero out a buffer
c	- continue from breakpoint
calloc	- allocate space for an array
cd	- change default directory
ceil	- floating point ceiling
cfree	- free a block of memory
checkStack	- print a summary of each task's stack usage
clearerr	- reset the error and end-of-file indicators
close	- close a file
connect	- initiate a connection on a socket
copy	- copy `in' (or standard input) to `out' (or standard output)
copyStreams	- copy from/to specified streams
cos	- floating point cosine
cosh	- floating point hyperbolic cosine
creat	- create a file
cret	- continue until return from current subroutine
d	- display memory
dbgHelp	- print dbgLib help menu
dbgInit	- initialize debug package
dbxInit	- initialize VxWorks support for dbxtool
dbxInterrupt	- suspend a task running under dbx
dbxTask	- dbx Server task
delete	- delete a file
devs	- list all system-known devices
diskinit	- format and initialize a disk
dsmData	- disassemble and print a word as data
dsmInst	- disassemble and print a single instruction
dsmNbytes	- find out how big an instruction is
ecvtb	- convert floating point to ASCII representation
entier	- floating point
errnoGet	- get error status value of calling task
errnoOfTaskGet	- get error status value of specified task
errnoOfTaskSet	- set error status value of specified task
errnoSet	- set error status value of calling task
etherInputHookAdd	- add routine to receive all ethernet input packets
etherOutput	- send packet on ethernet interface
etherOutputHookAdd	- add routine to receive all ethernet output packets
excHookAdd	- specify routine to be called on exceptions
excInit	- initialize exception handling package
excTask	- exception handling task-level support task
excVecInit	- initialize exception/interrupt vectors
exit	- exit a task
exp	- floating point inverse natural logarithm (e ** (x))
fabs	- floating point absolute value
fclose	- empty stream buffers and close file
fcvtb	- convert floating point to ASCII representation (Fortran-style)
fdopen	- associate stream with file descriptor
fdprintf	- print formatted string to specified fd
feof	- determine if end-of-file has been read
ferror	- determine if an error has occurred while reading or writing
fflush	- cause any buffers on output stream to be written.
fgetc	- return next character in input stream
fgets	- read a string from input stream
fileno	- get file descriptor associated with stream
fioFormat	- format processor
fioRdString	- read a string from a file
fioRead	- read a full buffer or to end-of-file
fioStdErr	- get current assignment of standard error fd (obsolete)
fioStdIn	- get current assignment of standard input fd (obsolete)
fioStdOut	- get current assignment of standard output fd (obsolete)
floatInit	- initialize floating-point I/O support
floor	- floating point floor
fopen	- open a stream on a file
fppInit	- initialize floating-point coprocessor support
fppProbe	- probe for presence of floating-point coprocessor
fppRestore	- restore coprocessor context
fppSave	- save coprocessor context
fppTaskRegsGet	- get a task's floating-point registers from TCB
fppTaskRegsSet	- set a task's floating-point registers 
fppTaskRegsShow	- print contents of a task's floating-point registers
fprintf	- print formatted string to stream
fputc	- append character to output stream
fputs	- copy NULL terminated string to output stream
fread	- buffered binary input
free	- free a block of memory
freopen	- substitute named file in place of the open stream
frexp	- split into mantissa and exponent
fscanf	- read and convert from input stream
fseek	- reposition a stream
ftell	- return the current offset in the stream
ftpCommand	- send FTP command and get reply
ftpDataConnGet	- get a completed FTP data connection
ftpDataConnInit	- initialize FTP data connection
ftpHookup	- get control connection to FTP server on specified host
ftpLogin	- login to remote FTP server
ftpReplyGet	- get FTP command reply
ftpXfer	- initiate transfer via FTP
fwrite	- buffered binary output
gcvt	- convert floating point to ASCII representation (e- or f-style)
getc	- return next character in input stream
getchar	- return next character in standard input stream
getpeername	- get name of connected peer
gets	- read a string from standard input stream
getsockname	- get socket name
getw	- read next word (32-bit integer) from stream
h	- display (or set) shell history
help	- print a synopsis of selected routines
hostAdd	- add a host to the host table
hostDelete	- delete a host from host table.
hostGetByAddr	- look up a host in the host table by its internet address
hostGetByName	- look up a host in the host table by its name.
hostShow	- show the host table
hostTblInit	- initialize network host table
i	- print a summary of each task's TCB
iam	- set remote user name and password
ifAddrSet	- configure a network interface
ifBroadcastSet	- set broadcast address for an interface
ifMaskSet	- define a subnet for an interface
index	- find a character in a string
inet_addr	- convert a dot notation Internet address to a long integer
inet_lnaof	- get local net address (host number) from Internet address
inet_makeaddr	- construct an Internet address from network + host numbers
inet_makeaddr_b	- construct an Internet address from network + host numbers
inet_netof	- return the network number from an Internet address
inet_netof_string	- local network extractor in dot notation
inet_network	- convert Internet network number from string to address
inet_ntoa	- convert network dot notation address to ASCII
inet_ntoa_b	- convert network dot notation address to ASCII
intConnect	- connect C routine to hardware interrupt
intContext	- determine if we are in interrupt context or task context
intCount	- get current interrupt nesting depth
intHandlerCreate	- construct interrupt handler for C routine
intLevelSet	- set interrupt level
intLock	- lock out interrupts
intUnlock	- cancel effect of intLock
intVecBaseGet	- get the vector base address
intVecBaseSet	- set the vector base address
intVecGet	- get vector
intVecSet	- set CPU vector
ioDefDevGet	- get current default device
ioDefDirGet	- get current default directory
ioDefPathGet	- get current default directory
ioDefPathSet	- set current default path
ioFullFileNameGet	- get the full file name using the current directory
ioGlobalStdGet	- get underlying global fd for standard input/output/error
ioGlobalStdSet	- set underlying global fd for standard input/output/error
ioTaskStdGet	- get underlying task fd for standard input/output/error
ioTaskStdSet	- set underlying task fd for standard input/output/error
ioctl	- do file specific control function
iosDevAdd	- add device to I/O system
iosDevDelete	- delete device from I/O system
iosDevFind	- find an I/O device in the device list
iosDevShow	- print a list of devices in the system
iosDrvInstall	- install I/O driver
iosDrvRemove	- remove I/O driver
iosDrvShow	- print a list of drivers in the system
iosFdFree	- free an fd entry in the fd table
iosFdNew	- allocate and initialize a new fd
iosFdSet	- fill in file descriptor specifics
iosFdShow	- print a list of file descriptor names in the system
iosFdValue	- verify valid open fd and return driver specific value
iosInit	- initialize I/O system
iosNextDevGet	- given a pointer to a device, get the next device in the list
irint	- convert double to integer
iround	- INTEGER floating point rounding
isatty	- return whether underlying driver is a tty device
isiBootInit	- set up ISI-compatible boot daemon
isiBootPacketInput	- receive a packet on a net
isiBootShow	- show infor about isiBootd
isiBootTrace	- turn ISI boot daemon debug trace on/off
isiBootd	- ISI-compatible boot daemon task
kernelInit	- initialize kernel
kernelTimeSlice	- enable round-robin select
kernelVersion	- get kernel version
kill	- send a signal to a task
l	- print a number of disassembled instructions
ld	- load object module into memory
ldexp	- split into mantissa and exponent
ledClose	- discard line editor id
ledControl	- change line editor ID parameters
ledOpen	- create new line editor ID
ledRead	- read a line with line editing
listen	- define socket queue length
lkAddr	- list symbols with value near given value
lkup	- list global symbols
loadModule	- load object module into memory
loadModuleAt	- load object module into memory
log	- floating point natural logarithm 
log10	- floating point logarithm base 10 
log2	- floating point logarithm base 2 
logFdAdd	- add another logging file descriptor
logFdDelete	- delete logging file descriptor
logFdSet	- set the primary logging file descriptor
logInit	- initialize message logging library
logMsg	- log formatted error message
logTask	- message logging support task
logout	- logout of VxWorks system
longjmp	- do non-local goto
ls	- list contents of current directory
lseek	- set file read/write pointer
lstAdd	- add node to end of list
lstConcat	- concatenate two lists
lstCount	- report number of nodes in list
lstDelete	- delete specified node from list
lstExtract	- extract a sublist from a list
lstFind	- find a node in a list
lstFirst	- find first node in list
lstFree	- free up the list
lstGet	- get (delete and return) first node from list
lstInit	- initialize list descriptor
lstInsert	- insert node in list after specified node
lstLast	- find last node in list
lstNStep	- find a node in the list 'nStep' nodes away from the given node 
lstNext	- find next node in list
lstNth	- find n-th node in list
lstPrevious	- find previous node in list
m	- modify memory
mRegs	- modify registers
malloc	- allocate a block of memory from the system memory pool
mathInit	- initialize floating point math package
memAddToPool	- add memory to system memory pool
memFindMax	- find size of largest available free block in system pool
memInit	- initialize the system memory pool
memOptionsSet	- turn debugging on and off
memPartAddToPool	- add memory to a memory partition
memPartAlloc	- allocate a block of memory from a partition 
memPartCreate	- create a memory partition
memPartFindMax	- find size of largest available free block
memPartFree	- free a block of memory in a partition
memPartOptionsSet	- select memory management options
memPartRealloc	- reallocate a block of memory in a given partition
memPartShow	- show partition blocks and statistics
memShow	- show system partition blocks and statistics
mkdir	- make a directory
modf	- split into mantissa and exponent
netDevCreate	- create a remote file device
netDrv	- network remote file driver installation
netHelp	- help command for the network
netLibInit	- initialize the network package
netTask	- the network task
nfsAllUnmount	- unmounts all directories on a particular host
nfsAuthUnixGet	- get the NFS UNIX authentication parameters
nfsAuthUnixPrompt	- modify NFS UNIX authentication parameters
nfsAuthUnixSet	- set the NFS UNIX authentication parameters
nfsAuthUnixShow	- print the NFS UNIX authentication parameters
nfsDevShow	- display all mounted NFS devices
nfsDrv	- NFS driver installation
nfsExportShow	- prints a list of a remote host's exported file systems
nfsHelp	- help command for NFS
nfsIdSet	- set the id number of the NFS UNIX authentication parameters
nfsMntDump	- prints a list of all NFS file systems mounted on the remote host
nfsMount	- mount an NFS directory
nfsUnmount	- unmount an NFS device
open	- open a file
pathAppend	- generate path name by concatenating an array of directory names
pathBuild	- generate path name by concatenating a list of directory names
pathCat	- concatenate directory path to file name
pathCondense	- condense a file or directory path
pathLastName	- point to the last name in a path name
pathRemoveTail	- remove the last directory name from a path name
pathSplit	- split a path name into its directory and file parts
pause	- sleep until signal 
pc	- return the contents of the program counter 
period	- spawn a task to call a function periodically
periodRun	- call a function periodically
pipeDevCreate	- create a pipe device
pipeDrv	- pipe driver main routine
printErr	- print formatted string to standard error fd
printErrno	- print the definition of specified error status value
printLogo	- print VxWorks logo
printf	- print formatted string to standard output
ptyDevCreate	- create a master/slave pair
ptyDrv	- pseudo-terminal driver
putc	- append character to output stream
putchar	- put character on standard output stream
puts	- copy NULL terminated string to output stream
putw	- append word (32-bit integer) to output stream
pwd	- print current default directory
ramDevCreate	- create a ram disk device
ramDrv	- install ram disk driver
ramMkfs	- create a ram disk device with an RT-11 file system
rcmd	- execute a shell command on a remote machine
read	- read bytes from a file or device
realloc	- reallocate a block of memory
reboot	- reset network devices and call sysToMonitor
rebootHookAdd	- add routine to be called at reboot 
recv	- receive on a socket
recvfrom	- receive a datagram
recvmsg	- receive a message
remCurIdGet	- get current user name and password
remCurIdSet	- set remote user name and password
rename	- change name of file
repeat	- spawn a task to call a function repeatedly
repeatRun	- call a function repeatedly
rewind	- position stream at the beginning
rfConfig	-
rfConfigGet	-
rfConfigParamsPrint	-
rfCtlrInit	-
rfDevCreate	- 
rfDevMount	-
rfDevShow	-
rfDrv	- install rimfire driver
rfFormat	-
rfFree	-
rfIoctlInfoPtrGet	-
rfLabelCreate	-
rfLabelPrint	- 
rfLabelRead	-
rfLabelWrite	-
rfMalloc	-
rfSMDChrsPrint	-
rfSync	-
rfVerify	-
rfXPBClear	-
rindex	- find the last occurrence of a character in a string
rlogInit	- initialize the rlogin facility
rlogin	- login to a remote host
rlogind	- the VxWorks rlogin daemon
rm	- remove a file
rmdir	- remove a directory
rmod	- floating point modulo remainder
rngBufGet	- get characters from ring buffer
rngBufPut	- put bytes to ring buffer
rngCreate	- create an empty ring buffer
rngDelete	- delete a ring buffer
rngFlush	- make a ring buffer empty
rngFreeBytes	- determine number of free bytes in ring buffer
rngIsEmpty	- test for ring buffer empty
rngIsFull	- test for ring buffer full (no more room)
rngMoveAhead	- advance ring "to" pointer `n' bytes
rngNBytes	- determine number of bytes in ring buffer
rngPutAhead	- put a byte ahead in ring buffer without moving ring pointers
round	- floating point rounding
routeAdd	- add a route
routeDelete	- delete a route
routeShow	- print routing tables (host and net)
rpcInit	- initialize RPC package
rpcTaskInit	- initialize task's access to RPC package
rresvport	- open a socket with a privileged port bound to it
rt11Close	- close an RT-11 file
rt11Create	- create an RT-11 file
rt11DateSet	- set current date
rt11Delete	- delete RT-11 file
rt11DevInit	- initialize RT-11 device descriptor
rt11Init	- prepare to use RT-11 library
rt11Ioctl	- do device specific control function
rt11ModeChange	- modify mode of RT-11 volume
rt11Open	- open a file on an RT-11 volume
rt11Read	- read from an RT-11 file
rt11ReadyChange	- notify rt11Lib of a change in ready status
rt11Write	- write to an RT-11 file
s	- single step
scanf	- read and convert from standard input stream
select	- pend on a set of file descriptors
selectDelaySet	- set select delay
semClear	- take semaphore if semaphore is available
semCreate	- create and initialize a semaphore
semDelete	- delete semaphore
semGive	- give semaphore
semInit	- initialize a declared semaphore
semTake	- take semaphore
send	- send data on a socket
sendmsg	- send a message on a socket
sendto	- send a message to a socket
setbuf	- specify buffer to be used on stream
setbuffer	- set buffer to be used on stream
setjmp	- set non-local goto
setlinebuf	- set line buffering for either stdout or stderr
setsockopt	- set socket options
shell	- the VxWorks shell
shellHistory	- display (or set) shell history
shellInit	- start shell
shellLock	- lock access to shell
shellLogout	- logout of VxWorks shell
shellOrigStdSet	- set the shell's default input/output/error fds
shellPromptSet	- change the shell's prompt
shellScriptAbort	- signal shell to stop processing script
shutdown	- shutdown a network connection
sigInit	- initialize the signal facility library
sigRaise	- send a signal to a task
sigblock	- add to set of blocked signals 
sigsetmask	- set the signal mask 
sigstack	- install a separate signal stack
sigvec	- install a signal handler 
sin	- floating point sine
sincos	- simultaneous floating point sine and cosine
sinh	- floating point hyperbolic sine
so	- single step, but step over subroutine
socket	- open a socket
sp	- spawn a task with default parameters
sprintf	- convert arguments to text under format control
spy	- begin periodic task activity reports
spyClkStart	- start collecting task activity data
spyClkStop	- stop collecting task activity data
spyHelp	- print a helpful list of the task activity commands
spyReport	- display task activity data
spyStop	- stop spying and reporting
spyTask	- run periodic task activity reports
sqrt	- floating point square root
squeeze	- reclaim fragmented free space on RT-11 volume
sr	- return the contents of the status register 
sscanf	- obtain values for arguments from ASCII string
stdioInit	- initialize stdioLib support
strcat	- concatenate one string to another
strcmp	- compare strings
strcpy	- string copy
strlen	- determine string length
strncat	- concatenate `n' characters from one string to another
strncmp	- compares up to `n' characters from one string to another
strncpy	- copy `n' characters from one string to another
swab	- swap bytes
symAdd	- add a symbol to a symbol table
symEach	- call a routine for each entry in a symbol table
symFindByName	- find a symbol in a symbol table
symFindByNameAndType	- find a symbol with specified type in a symbol table
symFindByValue	- find a symbol in a symbol table, given the value
symTblCreate	- create a symbol table
symTblInit	- initialize a symbol table
sysMemProbe	- probe address for bus error (obsolete)
tan	- floating point tangent
tanh	- floating point hyperbolic tangent
taskActivate	- activate an already created task
taskCreate	- create a task with stack at specified address
taskCreateHookAdd	- add routine to be called at every task create
taskCreateHookDelete	- delete previously added task create routine
taskDelay	- delay a task from executing
taskDelete	- delete a task
taskDeleteHookAdd	- add routine to be called at every task delete
taskDeleteHookDelete	- delete previously added task delete routine
taskIdDefault	- default task id
taskIdFigure	- translate a task name, or task id, to a task id
taskIdListGet	- get list of active task IDs
taskIdSelf	- get task id of running task
taskIdVerify	- verify the existence of a task
taskInfoGet	- get pointer to task's task descriptor
taskIsReady	- check if a task is ready to run
taskIsSuspended	- check if a task is suspended
taskLock	- disable task rescheduling
taskName	- get name associated with a task id
taskNameToId	- lookup task id associated with a name
taskOptionsGet	- examine task options
taskOptionsSet	- change task options
taskPriorityGet	- examine priority of a task
taskPrioritySet	- change priority of a task
taskRegsGet	- get a task's registers from TCB
taskRegsSet	- set a task's registers 
taskRegsShow	- print contents of a task's registers
taskRestart	- restart a task
taskResume	- resume a task
taskSRSet	- set task status register
taskSpawn	- spawn a task
taskStatusString	- return the task's status as a string
taskSuspend	- suspend a task
taskSwitchHookAdd	- add routine to be called at every task switch
taskSwitchHookDelete	- delete previously added task switch routine
taskTcb	- get the task control block for a task id
taskTcbX	- get the task control block extension associated with a task ID
taskUnlock	- enable task rescheduling
taskVarAdd	- add a task variable to a task
taskVarDelete	- remove a task variable from a task
taskVarGet	- get value of a task variable
taskVarInit	- initialize task variables facility
taskVarSet	- set value of a task variable
td	- delete a task, using taskDelete
telnetInit	- initialize the telnet daemon
telnetd	- the VxWorks telnet daemon
ti	- print complete info from a task's TCB
tickAnnounce	- announce a clock tick to the kernel
tickGet	- get value of kernel's tick counter
tickSet	- set value of kernel's tick counter
timex	- time single execution
timexClear	- clear timex function calls
timexFunc	- specify a function to be timed
timexHelp	- print help screen for timex
timexInit	- include timex library
timexN	- time repeated execution
timexPost	- specify a function to be called immediately after timing
timexPre	- specify a function to be called immediately prior to timing
timexShow	- display all established function calls
tr	- resume a task
trcStack	- print trace of function calls from stack
trunc	- floating point truncation
ts	- suspend a task
tt	- print a stack trace of a task
tyAbortFuncSet	- set abort function
tyAbortSet	- change abort character
tyBackspaceSet	- change backspace character
tyDeleteLineSet	- change line-delete character
tyDevInit	- initialize ty device descriptor
tyEOFSet	- change end-of-file character
tyIRd	- interrupt level input
tyITx	- interrupt level output
tyIoctl	- special device control
tyMonitorTrapSet	- change monitor trap character
tyRead	- task level read routine for ttys
tyWrite	- task-level write routine for ttys
ungetc	- push character back into input stream
usrClock	- user defined system clock interrupt routine
usrInit	- user defined system initialization routine
usrNetInit	- system dependent network initialization
usrRoot	- root task
version	- print VxWorks version info
vxMemProbe	- probe address for bus error
vxTas	- C callable test-and-set primitive
wdCancel	- cancel a currently counting watchdog
wdCreate	- create a watchdog timer
wdLibInit	- initialize watchdog timer module
wdStart	- start up a watchdog timer
wdTick	- announce tick to watchdogs
whoami	- print current remote identity
write	- write bytes to a file
