.TH wdLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
wdLib.c - watchdog timer subroutine library 
.SH SYNOPSIS
.nf
wdLibInit - initialize watchdog timer module
wdCreate - create a watchdog timer
wdStart - start up a watchdog timer
wdCancel - cancel a currently counting watchdog
wdTick - announce tick to watchdogs

VOID wdLibInit ()
WDOG_ID wdCreate ()
VOID wdStart (wd_id, delay, pRoutine, parameter)
VOID wdCancel (wd_id)
VOID wdTick ()
.fi
.SH DESCRIPTION
This module provides a general watchdog timer facility.  Any task may
create a watchdog timer, then use it to provide events that can happen
after a specified delay, outside the context of the task itself.

Once a timer has been created with wdCreate, that timer can be started
with wdStart.  On the wdStart call, a timeout routine, an arbitrary
parameter, and a delay count are specified.  After the specified delay
time has elapsed, and if the timer has not been canceled with wdCancel,
the timeout routine will be invoked with the parameter which was on the
wdStart.  The timeout routine will be invoked
even if the task which started the watchdog is running, suspended or deleted.

Note that the timeout routine is invoked at interrupt level, rather than
in the context of the task.  Therefore, it must be careful about what it
can and can't do.

The routine wdLibInit must be called before any watchdogs are created
and the routine wdTick must be called on every clock tick.

.SH EXAMPLE
.CS
    WDOG_ID wid = wdCreate ();
    wdStart (wid, 60, logMsg, "Help, I've timed out!");
    maybeSlowRoutine ();
    wdCancel (wid);
.CE
In the above fragment, if maybeSlowRoutine takes more than 60 ticks,
logMsg (2) will be called with the string as a parameter, which
will cause the message to be printed on the console.
Normally, of course, more significant corrective action would be taken.

.SH INCLUDE FILE
wdLib.h

.SH SEE ALSO
"Architecture", "Cross-Development", logLib (1), usrConfig (1)
