.TH usrLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
usrLib.c - some useful user interface subroutines 
.SH SYNOPSIS
.nf
help - print a synopsis of selected routines
netHelp - help command for the network
bootChange - change the boot line
periodRun - call a function periodically
period - spawn a task to call a function periodically
repeatRun - call a function repeatedly
repeat - spawn a task to call a function repeatedly
sp - spawn a task with default parameters
squeeze - reclaim fragmented free space on RT-11 volume
taskIdFigure - translate a task name, or task id, to a task id
checkStack - print a summary of each task's stack usage
i - print a summary of each task's TCB
ts - suspend a task
tr - resume a task
td - delete a task, using taskDelete
ti - print complete info from a task's TCB
version - print VxWorks version info
m - modify memory
d - display memory
cd - change default directory
pwd - print current default directory
copy - copy `in' (or standard input) to `out' (or standard output)
copyStreams - copy from/to specified streams
diskinit - format and initialize a disk
ld - load object module into memory
ls - list contents of current directory
rename - change name of file
mkdir - make a directory
rmdir - remove a directory
rm - remove a file
devs - list all system-known devices
lkup - list global symbols
lkAddr - list symbols with value near given value
a0 - return the contents of register a0 (also "a1-7", "d0-7")
sr - return the contents of the status register 
pc - return the contents of the program counter 
mRegs - modify registers
printErrno - print the definition of specified error status value
printLogo - print VxWorks logo
logout - logout of VxWorks system
h - display (or set) shell history

VOID help ()
VOID netHelp ()
VOID bootChange ()
VOID periodRun (secs, func, arg1, arg2, arg3, arg4, arg5, ...
STATUS period (secs, func, arg1, arg2, arg3, arg4, arg5, ...
VOID repeatRun (n, func, arg1, arg2, arg3, arg4, arg5, ...
STATUS repeat (n, func, arg1, arg2, arg3, arg4, arg5, ...
int sp (func, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)
STATUS squeeze (devName)
int taskIdFigure (taskNameOrId)
VOID checkStack (taskNameOrId)
VOID i (taskNameOrId)
VOID ts (taskNameOrId)
VOID tr (taskNameOrId)
VOID td (taskNameOrId)
VOID ti (taskNameOrId)
VOID version ()
VOID m (adrs)
VOID d (adrs, nwords)
STATUS cd (name)
VOID pwd ()
STATUS copy (in, out)
STATUS copyStreams (inFd, outFd)
STATUS diskinit (devName)
STATUS ld (syms, noAbort)
STATUS ls (dirName)
STATUS rename (oldname, newname)
STATUS mkdir (dirName)
STATUS rmdir (dirName)
STATUS rm (fileName)
VOID devs ()
VOID lkup (substr)
VOID lkAddr (addr)
int a0 (taskId)
int sr (taskId)
int pc (taskId)
STATUS mRegs (taskNameOrId)
VOID printErrno (errno)
VOID printLogo ()
VOID logout ()
VOID h (size)
.fi
.SH DESCRIPTION
This library consists of routines meant to be executed from the VxWorks
shell.  It provides useful utilities for task monitoring and execution,
system information, symbol table management, etc.  

Many routines here are little more than human interfaces to more general
routines contained elsewhere in VxWorks.  Users should feel free to
modify or extend this library.  It might be preferable, however, to
create a private library, using this one as a model, and link that into
a system, to customize capabilities.

Many routines here have optional parameters.  If those parameters are 0,
which is what the shell provides if no argument is typed, default
actions occur.  

.SH SEE ALSO
"Shell", "Debugging"
