.TH tyLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
tyLib.c - tty handler support library 
.SH SYNOPSIS
.nf
tyDevInit - initialize ty device descriptor
tyAbortFuncSet - set abort function
tyAbortSet - change abort character
tyBackspaceSet - change backspace character
tyDeleteLineSet - change line-delete character
tyEOFSet - change end-of-file character
tyMonitorTrapSet - change monitor trap character
tyIoctl - special device control
tyWrite - task-level write routine for ttys
tyRead - task level read routine for ttys
tyITx - interrupt level output
tyIRd - interrupt level input

STATUS tyDevInit (pTyDev, rdBufSize, wrtBufSize, txStartup)
VOID tyAbortFuncSet (func)
VOID tyAbortSet (ch)
VOID tyBackspaceSet (ch)
VOID tyDeleteLineSet (ch)
VOID tyEOFSet (ch)
VOID tyMonitorTrapSet (ch)
STATUS tyIoctl (pTyDev, request, arg)
int tyWrite (pTyDev, buffer, nbytes)
int tyRead (pTyDev, buffer, maxbytes)
STATUS tyITx (pTyDev, pChar)
STATUS tyIRd (pTyDev, inchar)
.fi
.SH DESCRIPTION
This library is meant to be used by ty drivers.  It handles all the
device independent functions of a normal serial device, such as XON-XOFF
processing, CR-LF conversion, and line editing functions.  Routines
contained in this library are only for use by drivers - there are no 
functions here that would normally be needed by a user.

For each device that uses this library, there must be a device, in the I/O
system's device list.  That device must contain, as part of it, a TY_DEV,
a pointer to which is a parameter to almost all the routines in this
library.  TyDevInit should be called exactly once to
initialize this TY_DEV.

Thereafter, various routines in this library may be called to service requests.

.SH INCLUDE FILE
tyLib.h

.SH SEE ALSO
"I/O System", ioLib (1), iosLib (1), tyCoDrv (3)
