.TH timexLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
timexLib.c - function execution timer utility 
.SH SYNOPSIS
.nf
timexInit - include timex library
timexClear - clear timex function calls
timexFunc - specify a function to be timed
timexHelp - print help screen for timex
timex - time single execution
timexN - time repeated execution
timexPost - specify a function to be called immediately after timing
timexPre - specify a function to be called immediately prior to timing
timexShow - display all established function calls

VOID timexInit ()
VOID timexClear ()
VOID timexFunc (i, func, arg1)
VOID timexHelp ()
VOID timex (func, arg1)
VOID timexN (func, arg1)
VOID timexPost (i, func, arg1)
VOID timexPre (i, func, arg1)
VOID timexShow ()
.fi
.SH DESCRIPTION
TimexLib provides a set of routines which may be used to 
time the execution of programs, individual routines and arbitrary groups 
of routines.  The VxWorks system clock is used as a time base to measure 
execution times.  Routines which have a short execution time relative to 
this time base may be called repetitively to establish an average execution 
time with an acceptable error percentage. 

Up to 4 routines may be specified as the group of functions to be
timed.  Additionally, sets of up to 4 routines may be specified as pre 
or post functions which are executed before and after the timed routines 
respectively.
timexPre and timexPost are used to specify pre and post functions,
while timexFunc is used to specify the routines to be timed.  

The routine timex (2) is used to time one iteration of a function.
If no argument list is given, timex uses the functions specified in the
timexPre, timexPost and timexFunc calls.
If arguments are supplied, they are used in lieu of the
functions previously specified.  The routine timexN (2) may be used to iterate
function calls; like timex, arguments supplied in the timexN call are used
instead of previously defined functions.

.SH EXAMPLES

timex may be used to obtain the execution time of a routine:
.CS
    timex (myFunc, myArg1, myArg2);
.CE
timexN calls a function repeatedly until a set error tolerence is obtained:
.CS
    timexN (myFunc, myArg1, myArg2);
.CE
timexPre, timexPost, and timexFunc may be used to specify groups of functions:
.CS
    timexPre (0, myFirstPreFunc, preArg1, preArg2);
    timexPre (1, mySecondPreFunc, preArg3);

    timexFunc (0, myFunc1, myArg1, myArg2);
    timexFunc (1, myFunc2, myArg3);
    timexFunc (2, myFunc3, myarg4, myArg5, myArg6);

    timexPost (0, myOnlyPostFunc, postArg);

    timex ();
         or
    timexN ();
.CE
When timex or timexN are called, myFirstPreFunc and mySecondPreFunc are 
called with their respective arguments.  MyFunc1, myFunc2, and myFunc3 
are then called in sequence, and timed.  If timexN was used, the sequence 
is called repeatedly until a 2% or better error tolerence is achieved.
Finally, myOnlyPostFunc is called with its argument.  The timing
results are reported after the post-functions are called.

.SH NOTE
The timings measure the time of execution of the routine body, without
the usual subroutine entry and exit code (usually just LINK, UNLINK, and
RTS instructions).  Also the time required to set up the arguments 
and call the routines is not included in the reported times.  
This is because these timing routines automatically calibrate themselves 
by timing the invocation of a null routine, 
and thereafter subtracting that constant overhead.

.SH SEE ALSO
spyLib (1)
