.TH taskVarLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskVarLib.c - task variable support library 
.SH SYNOPSIS
.nf
taskVarInit - initialize task variables facility
taskVarAdd - add a task variable to a task
taskVarDelete - remove a task variable from a task
taskVarGet - get value of a task variable
taskVarSet - set value of a task variable

STATUS taskVarInit ()
STATUS taskVarAdd (tid, pVar)
STATUS taskVarDelete (tid, pVar)
int taskVarGet (tid, pVar)
STATUS taskVarSet (tid, pVar, value)
.fi
.SH DESCRIPTION
VxWorks provides a facility called "task variables" which allows 4 byte 
variables to be added to a task's context, such that the value of 
such a variable is switched every time a task switch occurs to, or from, 
its owner task.  Typically, several tasks declare the same variable 
(4 byte memory location) as a task variable.  Each of those tasks can 
then treat that single memory location as its own private variable.
This can be used, for example, when the same routine must be spawned
more than once as several simultaneous tasks.

The routine taskVarAdd adds a task variable to the task context.
The routine taskVarDelete deletes a previously added task variable.
The routines taskVarGet and taskVarSet allow getting and setting
task variables of tasks other than the calling task.

.SH NOTE
If you are using task variables in a "task delete hook" (see taskHookLib (1)),
then please see the manual entry for taskVarInit (2) for warnings
on proper usage.
