.TH taskHookLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskHookLib.c - task hook library 
.SH SYNOPSIS
.nf
taskCreateHookAdd - add routine to be called at every task create
taskCreateHookDelete - delete previously added task create routine
taskSwitchHookAdd - add routine to be called at every task switch
taskSwitchHookDelete - delete previously added task switch routine
taskDeleteHookAdd - add routine to be called at every task delete
taskDeleteHookDelete - delete previously added task delete routine

STATUS taskCreateHookAdd (createHook)
STATUS taskCreateHookDelete (createHook)
STATUS taskSwitchHookAdd (switchHook)
STATUS taskSwitchHookDelete (switchHook)
STATUS taskDeleteHookAdd (deleteHook)
STATUS taskDeleteHookDelete (deleteHook)
.fi
.SH DESCRIPTION
The taskHookLib library allows for easy extensions to the VxWorks
tasking facility.
Extensions may be placed in three distinct stages of a task's existence:
during task creation, at a task switch, and when a task is deleted.
The routines taskCreateHookAdd and taskCreateHookDelete allow routines
to be dynamically added and deleted from a list of routines which are
called whenever a task is created.
Likewise, taskSwitchHookAdd and taskSwitchHookDelete manipulate
the list of routines to be called at each task switch.
Finally, taskDeleteHookAdd and taskDeleteHookDelete manipulate
the list of routines to be called whenever a task is deleted.

This facility is used by the debugger to provide task specific
breakpoints and single stepping.
It is used by taskVarLib (1) for the "task variable" mechanism.
It is also used by fppLib (1) for floating point coprocessor support.

.SH NOTE
It is possible to have dependencies among task hooks.  For example, a
task delete hook may use facilities that are cleaned up and deleted by
another delete hook.  In these cases, the order that the hooks run is
important.  VxWorks runs the create and switch hooks in the order that
they were added, and runs the delete hooks in the REVERSE of the order
in which they were added.  Thus if the hooks are added in "hierarchical"
order, such that hooks only rely on facilities whose hooks have already
been added, then the required facilities will be initialized before any
other facilities require them, and will be delete after all facilities
are finished with them.

In VxWorks' facilities, this is guaranteed by having each facility have
an initialization routine that first calls any pre-requisite facility's
initialization routine, and then adds its own hooks.  Thus the task hooks
will get added in the correct order.  Each initialization routine
protects itself from multiple invocations, allowing only the first
invocation to have any affect.

.SH SEE ALSO
"Architecture", taskLib (1)
