.TH symLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
symLib.c - symbol table subroutine library 
.SH SYNOPSIS
.nf
symAdd - add a symbol to a symbol table
symTblCreate - create a symbol table
symEach - call a routine for each entry in a symbol table
symFindByName - find a symbol in a symbol table
symFindByNameAndType - find a symbol with specified type in a symbol table
symTblInit - initialize a symbol table
symFindByValue - find a symbol in a symbol table, given the value

STATUS symAdd (pTbl, name, adrs, type)
SYMTAB_ID symTblCreate (maxSymbols, maxSymLen)
VOID symEach (pTbl, routine, routineArg)
STATUS symFindByName (pTbl, name, pAdrs, pType)
STATUS symFindByNameAndType (pTbl, name, pAdrs, pType, sType, mask)
STATUS symTblInit (pTbl, maxSymbols, maxSymLen)
STATUS symFindByValue (pTbl, val, name, pVal, pType)
.fi
.SH DESCRIPTION
This is a facility for accessing symbol tables.
Each table entry consists of a symbol name, a value (normally used for 
an address) and a type (normally a UNIX type specification, as define 
in a.out.h).  Symbol names are variable length, up to a maximum specified 
in the table in which they are stored.  Tables are created with symTblCreate, 
symbols are added with symAdd, symbols may be looked up with symFindByName and
symFindByValue.  The value and type fields can be used for anything you
like, since they are treated here simply as data.

.SH DEFICIENCIES
Since it is just an unordered table, it is slow.  There is currently no
way to delete symbols from the table, or to deallocate tables.

.SH INCLUDE FILE
symLib.h

.SH SEE ALSO
loadLib (1)
