.TH stdioLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
stdioLib.c - standard I/O library 
.SH SYNOPSIS
.nf
stdioInit - initialize stdioLib support
isatty - return whether underlying driver is a tty device
fclose - empty stream buffers and close file
fdopen - associate stream with file descriptor
fgetc - return next character in input stream
fgets - read a string from input stream
fflush - cause any buffers on output stream to be written.
fopen - open a stream on a file
fprintf - print formatted string to stream
fputc - append character to output stream
fputs - copy NULL terminated string to output stream
fread - buffered binary input
freopen - substitute named file in place of the open stream
fseek - reposition a stream
ftell - return the current offset in the stream
fwrite - buffered binary output
getchar - return next character in standard input stream
gets - read a string from standard input stream
getw - read next word (32-bit integer) from stream
putchar - put character on standard output stream
puts - copy NULL terminated string to output stream
putw - append word (32-bit integer) to output stream
rewind - position stream at the beginning
scanf - read and convert from standard input stream
fscanf - read and convert from input stream
setbuf - specify buffer to be used on stream
setbuffer - set buffer to be used on stream
setlinebuf - set line buffering for either stdout or stderr
ungetc - push character back into input stream
clearerr - reset the error and end-of-file indicators
feof - determine if end-of-file has been read
ferror - determine if an error has occurred while reading or writing
fileno - get file descriptor associated with stream
getc - return next character in input stream
putc - append character to output stream

STATUS stdioInit ()
BOOL isatty (fd)
STATUS fclose (fp)
FILE *fdopen (fd, type)
int fgetc (fp)
char *fgets (s, n, fp)
int fflush (fp)
FILE *fopen (filename, type)
int fprintf (fp, fmt, args)
int fputc (c, fp)
int fputs (s, fp)
int fread (ptr, size, count, fp)
FILE *freopen (filename, type, fp)
STATUS fseek (fp, offset, ptrname)
long ftell (fp)
int fwrite (ptr, size, count, fp)
int getchar ()
char *gets (s)
int getw (fp)
int putchar (c)
int puts (s)
int putw (w, fp)
VOID rewind (fp)
int scanf (fmt, args)
int fscanf (fp, fmt, args)
VOID setbuf (fp, buf)
VOID setbuffer (fp, buf, size)
VOID setlinebuf (fp)
int ungetc (c, fp)
VOID clearerr (fp)
int feof (fp)
BOOL ferror (fp)
int fileno (fp)
int getc (fp)
int putc (c, fp)
.fi
.SH DESCRIPTION
The library stdioLib provides a complete UNIX compatible "standard I/O"
buffering scheme.  It is beyond the scope of this manual entry to
describe all the functions and vagaries of the buffering --
see the I/O chapter of the VxWorks Programmers Guide and
the Kernighan & Ritchie C manual.
This manual entry primarily highlights the differences
between the UNIX and VxWorks stdio.

.SH VX_STDIO TASK OPTION
Traditionally stdin, stdout, and stderr are macros but,
in VxWorks, they are in fact variables.
They will only be defined for the task context of tasks spawned with
the task option bit VX_STDIO.
They are unique to each such task and correspond to the file descriptors
0, 1, and 2 in the basic I/O system.
Their values are undefined when used at any other time,
eg. interrupt level code or another task without the VX_STDIO option.

  IF A TASK WILL USE stdin, stdout, OR stderr,
  THE TASK MUST BE SPAWNED WITH THE ``VX_STDIO'' TASK OPTION BIT.

The only exception is the use of the routine printf(1), which, as
explained below, does not actually use stdio buffering.

.SH HEADER FILE
To use VxWorks standard I/O one must include the header file stdioLib.h.
This file defines all the usual macros.

All the macros defined in stdioLib.h are also implemented as real functions
so that they are available from the VxWorks shell.

.SH FILE POINTERS
The routine fopen (2) creates a ``FILE'' .  Use of the FILE pointer
is just as in any conventional UNIX usage.  Remember though, that
in a shared address space, and perhaps more critically with the system
symbol table of VxWorks, tasks may not use each others' file pointers,
at least not without some interlocking mechanism.  If it is necessary
to use the same name for a file pointer but have incarnations for
each task then use task variables; see taskVarLib (1).

.SH FIOLIB
There are a few routines not implemented in stdioLib (1).
The routines printf, sscanf, and sprintf are implemented in fioLib (1).
They do not use the stdio buffering scheme, but instead are self-contained,
formatted but unbuffered I/O functions.
This allows minimal formatted I/O to be achieved without the overhead
of the entire stdioLib package.

.SH TASK TERMINATION
When a task exits, unlike UNIX, it is the responsibility of the
task to fclose (2) its file pointers, except stdin, stdout, and stderr.
If a task is to be terminated asynchronously, use kill (2)
and arrange for a signal handler to cleanup.

.SH DEFICIENCIES
Beware of the routine fseek (2) and the fopen (2) modes of "r+",
"w+", "a" and "a+".  These do not work in many cases due to
the present limitations of lseek (2) in ioLib (1).

.SH SEE ALSO
fioLib (1), ioLib (1), taskVarLib (1), sigLib (1),
VxWorks Programmers Guide: I/O Chapter, and Kernighan & Ritchie C manual

.SH INCLUDE FILES
stdioLib.h, taskLib.h
