.TH sockLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
sockLib.c - UNIX BSD 4.3 compatible socket library 
.SH SYNOPSIS
.nf
socket - open a socket
bind - bind a name to a socket
listen - define socket queue length
accept - accept a connection on a socket
connect - initiate a connection on a socket
sendto - send a message to a socket
send - send data on a socket
sendmsg - send a message on a socket
recvfrom - receive a datagram
recv - receive on a socket
recvmsg - receive a message
setsockopt - set socket options
getsockname - get socket name
getpeername - get name of connected peer
selectDelaySet - set select delay
select - pend on a set of file descriptors
shutdown - shutdown a network connection

int socket (domain, type, protocol)
STATUS bind (s, name, namelen)
STATUS listen (s, backlog)
int accept (s, addr, addrlen)
STATUS connect (s, name, namelen)
int sendto (s, buf, len, flags, to, tolen)
int send (s, buf, len, flags)
int sendmsg (s, msg, flags)
int recvfrom (s, buf, len, flags, from, fromlen)
int recv (s, buf, len, flags)
int recvmsg (s, msg, flags)
STATUS setsockopt (s, level, optname, optval, optlen)
STATUS getsockname (s, name, namelen)
STATUS getpeername (s, name, namelen)
VOID selectDelaySet (nTicks)
int select (width, pReadFds, pWriteFds, pExceptFds, pTimeOut)
STATUS shutdown (s, how)
.fi
.SH DESCRIPTION
The library sockLib provides UNIX BSD 4.3 compatible socket calls.
These calls may be used to read, write, open,
and close sockets, either on the same CPU or across a network.
The calling sequences of these routines are identical to UNIX BSD 4.3.  

.SH INCLUDE FILES
types.h, mbuf.h, socket.h, socketvar.h

.SH SEE ALSO
UNIX BSD 4.3 documentation, "Network", netLib (1)
