.TH sigLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
sigLib.c - software signal facility library 
.SH SYNOPSIS
.nf
sigInit - initialize the signal facility library
sigvec - install a signal handler 
sigstack - install a separate signal stack
sigsetmask - set the signal mask 
sigblock - add to set of blocked signals 
pause - sleep until signal 
kill - send a signal to a task
sigRaise - send a signal to a task

STATUS sigInit ()
STATUS sigvec (sig, pVec, pOvec)
STATUS sigstack (pSs, pOss)
int sigsetmask (mask)
int sigblock (mask)
STATUS pause ()
STATUS kill (tid, signal)
STATUS sigRaise (tid, signal, code)
.fi
.SH DESCRIPTION
This library provides a UNIX BSD 4.3 compatible software signal facility.
Signals are used to communicate asynchronous events
within and between task contexts.
In many ways, signals are analogous to hardware interrupts.
The signal facility provides a set if 31 distinct signals.
A "signal handler" is bound to a particular signal with sigvec (2)
in much the same way that an interrupt service routine is
connected to an interrupt vector with intConnect (2).
A signal may be asserted by calling kill - this is analogous
to the occurrence of an interrupt or hardware exception.
Signals are blocked for the duration of the signal handler,
as interrupts are locked out for the duration of the interrupt service routine.
Tasks may block the occurrence of certain signals with sigblock (2)
and sigsetmask (2), as the interrupt level may be raised or lowered to
block out levels of interrupts.  If a signal is blocked when it is raised,
it's handler routine will be called when the signal becomes unblocked.

Signal handlers are passed several parameters and should be defined as:

.CS
VOID sigHandler (sig, code, sigContext)
    int sig;                    /* signal number *
    int code;                   /* additional code *
    SIGCONTEXT *sigContext;     /* context of task before signal *
    {
    .
    .
    .
    }
.CE

The code parameter is used to distinguish variants of a signal.
For instance, numeric overflow and zero divide both raise SIGFPE
(floating point exception) but have different a code parameter.


.SH EXCEPTION PROCESSING
Certain signals (defined below) are asserted automatically when
exceptions are raised.
This mechanism allows the user to install her own exception handlers.
This is useful for recovering from catastrophic events
such as bus errors, or arithmetic errors.
Typically, setjmp (2) is called to 
define the point in the program where control shall be restored,
and longjmp (2) is called in the signal handler to restore that context.  
Note that longjmp (2) restores the state of the task's signal mask and its 
onstack flag.  If no user defined handler is installed for the given signal, 
the default action is to log a message to the console and suspend the task.

UNIX BSD 4.3 defines a set of 31 signals.
Of these, only a handful are meaningful in the VxWorks environment.
The following may be asserted by VxWorks:

.CS
    signal:     code:                   exception:
    -------     -----                   ----------
    SIGSEGV     NULL                    bus error
    SIGBUS      BUS_ADDERR              address error
    SIGILL      ILL_ILLINSTR_FAULT      illegal instruction
    SIGFPE      FPE_INTDIV_TRAP         zero divide
    SIGFPE      FPE_CHKINST_TRAP        chk trap
    SIGFPE      FPE_TRAPV_TRAP          trapv trap
    SIGILL      ILL_PRIVVIO_FAULT       privilege violation
    SIGTRAP     NULL                    trace exception
    SIGEMT      EMT_EMU1010             line 1010 emulator
    SIGEMT      EMT_EMU1111             line 1111 emulator
    SIGILL      ILL_ILLINSTR_FAULT      coprocessor protocol violation
    SIGFMT      NULL                    format error

    floating point coprocessor stuff 

    SIGFPE      FPE_FLTBSUN_TRAP        compare unordered
    SIGFPE      FPE_FLTINEX_TRAP        inexact result
    SIGFPE      FPE_FLTDIV_TRAP         divide by zero
    SIGFPE      FPE_FLTUND_TRAP         underflow
    SIGFPE      FPE_FLTOPERR_TRAP       operand error
    SIGFPE      FPE_FLTOVF_TRAP         overflow
    SIGFPE      FPE_FLTNAN_TRAP         signaling "Not A Number"
.CE

Signals other than these may be used by an application,
with the warning that additional signals may be used by VxWorks in the future
(SIGUSR1 and SIGUSR2 will never be used by VxWorks).

.SH IMPLEMENTATION NOTES AND CAVEATS

If a signal is directed at a task that is pended, the signal handler will 
not be invoked until the task becomes runnable.
A future release of the VxWorks kernel will be able to start pended tasks,
and this problem will go away.  

.SH SEE ALSO
UNIX BSD 4.3 documentation

.SH INCLUDE FILE
sigLib.h
