.TH rpcLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rpcLib.c - rpc support library 
.SH SYNOPSIS
.nf
rpcInit - initialize RPC package
rpcTaskInit - initialize task's access to RPC package

STATUS rpcInit ()
STATUS rpcTaskInit ()
.fi
.SH DESCRIPTION
VxWorks supports the SUN Microsystems' Remote Procedure Call library.  
RPC provides facilities for implementing client/server based architectures.
The underlying interprocess communication mechanism can be completely hidden,
permitting applications to be written without any reference to network sockets.
The package is structured such that a sophisticated user may access
lower level routines allowing greater control of the communication protocols.
The user is directed to SUN's "Remote Procedure Call Programming Guide" for
a complete discussion and tutorial.  An example of the use of RPC is provided
in the VxWorks demonstration directory; it is called "sprites".

The RPC facility is enabled by defining the constant "INCLUDE_RPC" in
the target CPU config.h file, e.g.:
.CS
    #define INCLUDE_RPC
.CE
VxWorks supports NFS (Network File System) and SUN's dbxtool,
both of which are built on top of RPC.
If either NFS or DBX are configured into the system, then RPC is as well.

.SH IMPLEMENTATION
Every task which is going to make calls to the RPC library must first call
rpcTaskInit (2).  This routine installs a VxWorks task variable which contains
pointers to static data structures in the RPC package that must be switched
on each task context switch.

RPC related objects (such as SVCXPRT's and CLIENT's) may not be 
shared among tasks;  objects created by one task may not be passed to 
another for use.  This is because the RPC package
contains static data structures that refer to these objects, and the
VxWorks implementation of RPC uses VxWorks task variables to switch
in a different copy of the static data structures for each task.

.SH INCLUDE FILE
rpc.h

.SH SEE ALSO
SUN RPC programmers guide, nfsLib (1), nfsDrv (3), dbxLib (1)
