.TH rngLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rngLib.c - ring buffer subroutine library 
.SH SYNOPSIS
.nf
rngCreate - create an empty ring buffer
rngDelete - delete a ring buffer
rngFlush - make a ring buffer empty
rngBufGet - get characters from ring buffer
rngBufPut - put bytes to ring buffer
rngIsEmpty - test for ring buffer empty
rngIsFull - test for ring buffer full (no more room)
rngFreeBytes - determine number of free bytes in ring buffer
rngNBytes - determine number of bytes in ring buffer
rngPutAhead - put a byte ahead in ring buffer without moving ring pointers
rngMoveAhead - advance ring "to" pointer `n' bytes

RING_ID rngCreate (nbytes)
VOID rngDelete (ringId)
VOID rngFlush (ringId)
int rngBufGet (rngId, buffer, maxbytes)
int rngBufPut (rngId, buffer, nbytes)
BOOL rngIsEmpty (ringId)
BOOL rngIsFull (ringId)
int rngFreeBytes (ringId)
int rngNBytes (ringId)
VOID rngPutAhead (ringId, byte, offset)
VOID rngMoveAhead (ringId, n)
.fi
.SH DESCRIPTION
This library provides facilities for creating and using ring buffers,
which are first-in-first-out circular buffers.

The routines here have several important virtues.  They are fast, which
is often important in the sort of circumstances where they will be used.
They are also race-free.  Data may be added to and removed from the
same ring asynchronously without locking out or using a semaphore.
This makes it easy when, for example, bytes are added at interrupt level
and removed by a task, or added by one task and removed by another.
There can be problems, though, if two or more asynchronous processes are
adding to (or removing from) the same ring.  In that case, a semaphore is
necessary.

This library also supplies two macros, RNG_ELEM_PUT and RNG_ELEM_GET,
for putting and getting single bytes from a ring buffer.  These are somewhat
faster than the rngBufPut and rngBufGet subroutines, which can put and get 
multi-byte buffers.  These macros are defined in rngLib.h.
.CS
    int RNG_ELEM_GET (ringId, pch, fromP)
    int RNG_ELEM_PUT (ringId, ch, toP)
.CE
Both macros require a temporary variable (fromP or toP), which should
be declared as "register int" for maximum efficiency.
RNG_ELEM_GET returns 1 if there was a character in the buffer to be gotten,
0 otherwise.  RNG_ELEM_PUT returns 1 if there was room in the buffer, 0
otherwise.

.SH INCLUDE FILE
rngLib.h
