.TH rebootLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rebootLib.c - reboot support library 
.SH SYNOPSIS
.nf
reboot - reset network devices and call sysToMonitor
rebootHookAdd - add routine to be called at reboot 

VOID reboot (startType)
STATUS rebootHookAdd (rebootHook)
.fi
.SH DESCRIPTION
The rebootLib module allows for an "orderly" reboot.
The routine reboot may be called at any time to restart VxWorks.
It is called when the abort character (control-X) is typed from the shell.
Shutdown routines may be added with rebootHookAdd (2).
These are typically used to reset, or synchronize, hardware.
For example, netLib (1) adds a reboot hook to cause all network
interfaces to be reset.
Once the reboot hooks have been run, sysToMonitor (2) is
called to transfer control to the bootroms.

In the standard configuration there are three kinds of reboots.
A "warm boot" causes the system to go through the countdown sequence,
and automatically try to reboot VxWorks.
A "warm boot without autoboot" causes the system simply wait in the
bootrom monitor.
Lastly, a "cold boot" acts as if the chassis had been reset, and
autoboot will take place.

.SH INCLUDE FILE
sysLib.h

.SH SEE ALSO
sysLib (1), bootConfig (1)
