.TH nfsLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
nfsLib.c - Network File System library 
.SH SYNOPSIS
.nf
nfsAllUnmount - unmounts all directories on a particular host
nfsMntDump - prints a list of all NFS file systems mounted on the remote host
nfsExportShow - prints a list of a remote host's exported file systems
nfsHelp - help command for NFS
nfsAuthUnixPrompt - modify NFS UNIX authentication parameters
nfsAuthUnixShow - print the NFS UNIX authentication parameters
nfsAuthUnixSet - set the NFS UNIX authentication parameters
nfsAuthUnixGet - get the NFS UNIX authentication parameters
nfsIdSet - set the id number of the NFS UNIX authentication parameters

STATUS nfsAllUnmount (hostName)
STATUS nfsMntDump (hostName)
STATUS nfsExportShow (hostName)
VOID nfsHelp ()
VOID nfsAuthUnixPrompt ()
VOID nfsAuthUnixShow ()
VOID nfsAuthUnixSet (machname, uid, gid, ngids, aup_gids)
VOID nfsAuthUnixGet (machname, pUid, pGid, pNgids, gids)
VOID nfsIdSet (uid)
.fi
.SH DESCRIPTION
This library provides the client side of services for NFS (Network
File System) file oriented devices.  Most routines in this library
are NOT to be called directly by users, but rather by device drivers.
The driver is responsible for keeping track of file pointers,
mounted disks, cached buffers, and so on.  This library makes the
actual NFS calls using RPC (Remote Procedure Call).

.SH NFS USER IDENTIFICATION
When making an NFS request to a host system, the NFS server expects
more in-depth information about the user than just the user's name.
NFS is built on top of Remote Procedure Call (RPC) and uses a type of RPC
authentication known as AUTH_UNIX.
VxWorks has an AUTH_UNIX structure which it passes on to the NFS server
with every NFS request.  This structure contains necessary information
for NFS, including the user's identification number, which is
uniquely mapped to the user's name, as well as a list of groups that the
user belongs to.  On UNIX systems, a user's identification number can be
found in the "/etc/passwd" file.
A list of groups that a user belongs to can be found in the "/etc/group" file.
The routine nfsAuthUnixPrompt allows the user to change the default parameters.
The routine nfsIdSet allows the user to just change the AUTH_UNIX id.
Usually, only the user id needs to be changed to indicate a new nfs user.

.SH WARNING
Because of the recursive nature of the XDR (eXternal Data Representation)
routines in RPC, NFS tends to use a large stack.  Make sure that the tasks
running NFS have enough stack space (> 7000 bytes).

.SH INCLUDE FILE
nfsLib.h

.SH SEE ALSO
"Network", rpcLib (1), ioLib (1), nfsDrv (3)

