.TH memLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
memLib.c - the VxWorks memory manager 
.SH SYNOPSIS
.nf
memPartCreate - create a memory partition
memPartAddToPool - add memory to a memory partition
memPartOptionsSet - select memory management options
memPartAlloc - allocate a block of memory from a partition 
memPartRealloc - reallocate a block of memory in a given partition
memPartFree - free a block of memory in a partition
memPartFindMax - find size of largest available free block
memPartShow - show partition blocks and statistics
memInit - initialize the system memory pool
memAddToPool - add memory to system memory pool
memOptionsSet - turn debugging on and off
malloc - allocate a block of memory from the system memory pool
calloc - allocate space for an array
realloc - reallocate a block of memory
free - free a block of memory
cfree - free a block of memory
memFindMax - find size of largest available free block in system pool
memShow - show system partition blocks and statistics

PART_ID memPartCreate (pPool, poolSize)
VOID memPartAddToPool (partId, pPool, poolSize)
VOID memPartOptionsSet (partId, options)
char *memPartAlloc (partId, nBytes)
char *memPartRealloc (partId, pBlock, nBytes)
STATUS memPartFree (partId, pBlock)
int memPartFindMax (partId)
VOID memPartShow (partId, type)
VOID memInit (pPool, poolSize)
VOID memAddToPool (pPool, poolSize)
VOID memOptionsSet (options)
char *malloc (nBytes)
char *calloc (elemNum, elemSize)
char *realloc (pBlock, newSize)
STATUS free (pBlock)
STATUS cfree (pBlock)
int memFindMax ()
VOID memShow (type)
.fi
.SH DESCRIPTION
The library memLib provides a first-fit memory management facility.
Memory is allocated (malloc) from a pool of free memory blocks;
adjacent blocks are coalesced when they are freed (free).
No attempt is made to reduce fragmentation - there is no garbage collection. 
The package is initialized by calling memInit with a pointer to a block
of memory from which memory will be allocated.
The routine memShow displays statistics about the free pool.

The system memory manager is built on top of a generic
"partition" manager which may be used to create private pools of memory.
This is useful for drivers that control devices that have on board memory
which must be configured and managed by the host processor.  

Various error checking and error action options can be selected with a call
to memOptionsSet (and memPartOptionsSet).
The default is to check blocks being freed and to log an error message
and suspend the caller if a bad block is discovered.  Also default is
the logging of attempts to allocate more memory than is available.

.SH CAVEATS
malloc always rounds up to a 4 byte boundary and there
is a 12 byte overhead for each block allocated.

.SH INCLUDE FILE
memLib.h

