.TH logLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
logLib.c - message logging library 
.SH SYNOPSIS
.nf
logInit - initialize message logging library
logMsg - log formatted error message
logFdSet - set the primary logging file descriptor
logFdAdd - add another logging file descriptor
logFdDelete - delete logging file descriptor
logTask - message logging support task

STATUS logInit (fd, maxMsgs)
VOID logMsg (fmt, arg1, arg2, arg3, arg4, arg5, arg6)
VOID logFdSet (fd)
STATUS logFdAdd (fd)
STATUS logFdDelete (fd)
VOID logTask ()
.fi
.SH DESCRIPTION
This module handles message logging.  Its normal use is to log error
messages on the system console, though the messages could just as well
go to a disk file, a printer, or whatever.

There are two basic components to the logging system.  The first is the
logging task (logTask).  This task reads a pipe for messages containing
a printf-style format string and arguments.  When it gets a message,
it formats it, adds some information to it, and writes it on the file
descriptor that was
specified on the logInit (or subsequently set by logFdSet or logFdAdd).
The second main component is logMsg.  This routine has exactly the same calling
sequence as printf, but sends the format string and arguments in a message
to logTask.

There are two important things to note about logging.
One is that logMsg can be called from interrupt level,
as well as from task level, whereas normal I/O to a non-pipe device
(printf to a serial port, for example)
can't be done from interrupt level.  
The other is that the print formatting is done in logTask's context, 
rather than the context of the task calling logMsg.  
Since formatting can require considerable stack space, 
this can reduce stack sizes for tasks that only need to do I/O for error output.

.SH SEE ALSO
"I/O System", fioLib (1), pipeDrv (3)
