.TH ledLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ledLib.c - line editing library 
.SH SYNOPSIS
.nf
ledOpen - create new line editor ID
ledClose - discard line editor id
ledRead - read a line with line editing
ledControl - change line editor ID parameters

int ledOpen (inFd, outFd, histSize)
VOID ledClose (led_id)
int ledRead (led_id, string, maxBytes)
VOID ledControl (led_id, inFd, outFd, histSize)
.fi
.SH DESCRIPTION
This is the line editing library.
It provides a nifty line editing layer on top of a tty device.
The VxWorks shell uses this interface for its vi-like editing features.

The shell provides a history mechanism similar to the UNIX Korn Shell
history facility with a built-in line editor that allows the user to edit
previously typed commands.  The command h (2)
displays the previous commands that were typed into the shell
(up to 20; old commands fall off the top as new ones are entered).
To edit a command that was typed in earlier, type \s-2ESC\s+2
followed by one of the search commands mentioned below.
The ESC key toggles the shell into command
mode, the mode which enables editing of the shell history.
The following vi-like commands are available for line editing:
.CS
 <n>G   goto to command number <n>
 /<s>   search for string <s> back in history
 ?<s>   search for string <s> forward in history
 n      repeat last search
 N      repeat last search but in the opposite direction
 <n>k   get previous shell command, <n> relative
 <n>-   same as ``k''
 <n>j   get next history, <n> relative
 <n>+   same as ``j''
 <n>h   move left n characters
 ^H     same as ``h''
 <n>l   move right n characters
 <sp>   same as ``l''
 <n>w   move n words forward
 <n>W   move n blank-separated words forward
 <n>e   move to the next end of word
 <n>E   move to the end of blank-separated word
 <n>b   move back n words
 <n>B   move back n blank-separated words
 f<c>   find character <c>, searching forwards
 F<c>   find character <c>, searching backwards
 <n>r<c>        replace the following <n> chars with <c>
 a      append
 A      append at end of line
 <n>x   delete character under cursor
 <n>X   delete character to left of cursor
 c<sp>  change character
 cl     change character
 cw     change word
 cc     change entire line
 c$     change everything from cursor to end of line
 C      same as ``c$''
 S      same as ``cc''
 d<sp>  delete character
 dl     delete character
 dw     delete word
 dd     delete entire line
 d$     delete everything from cursor to end of line
 D      same as ``d$''
 i      insert
 I      insert at beginning of line
 p      put whatever was last deleted after cursor
 P      put whatever was last deleted before cursor
 u      undo last command
 $      go to end of line
 0      go to beginning of line
 ~      toggle case, upper to lower or lower to upper
 ^      move cursor to first non-blank character in line
 R      over-strike mode
 ^U     delete line (leaves command mode)
 ^L     redraw line
 ^D     complete symbol name
 RET    give line to shell
.CE
The default value for <n> is 1 if <n> is omitted.

.SH DEFICIENCIES
Since the shell toggles between raw and line mode, type-ahead can be lost.
ESC, Redraw, and Non-Printable characters are built-in.
EOF, Backspace, and Line Delete are IMPORTed from tyLib in an ugly manner.
Instead, tyLib (1) should supply and/or support these
characters via an ioctl (2).

Some commands don't take "counts", eg. <n>i will not insert whatever was
entered <n> times.  Word movement is less than accurate.

