.TH isiBootLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
isiBootLib.c - ISI-specific boot daemon 
.SH SYNOPSIS
.nf
isiBootInit - set up ISI-compatible boot daemon
isiBootPacketInput - receive a packet on a net
isiBootd - ISI-compatible boot daemon task
isiBootShow - show infor about isiBootd
isiBootTrace - turn ISI boot daemon debug trace on/off

STATUS isiBootInit ()
BOOL isiBootPacketInput (pIf, buf, len)
VOID isiBootd ()
VOID isiBootShow ()
VOID isiBootTrace (doTrace)
.fi
.SH DESCRIPTION
This boot daemon runs on a VxWorks system which is CPU 0.  It allows autobooting
of other VxWorks CPUs in the same backplane which are running ISI boot PROMs.
The boot daemon is started by calling isiBootInit (2).  At that time, the
configuration file will be read, and the daemon spawned.

Packets are received by inserting a hook into the vb backplane network driver,
using etherInputHookAdd (2).  This causes the routine isiBootPacketInput (2)
to be called every time a packet is received.  If that packet was received from
the vb bus, and if its packet type is ISIBOOT, it is handled here.  Otherwise,
isiBootPacketInput (2) returns FALSE, and the packet will be processed
normally.

If the packet is ours, it is written to a pipe, which will later be read by
isiBootd (2) and acted upon.

.SH PROTOCOL
The protocol used to request services of isiBootd is specific 
to the vb bus.  All operations are initiated by the remote machine by 
transmiting packets. All packets are the same length.  The host machine 
will transmit packets back (possibly with added information) to the remote
machine as an acknowledgement of its request.

The remote machine initiates a boot connection by broadcasting a
CONNECT packet, with the hostname of the boot server in the data portion of the
packet.  The daemon keeps track of this host name, because that name will
later be prepended to the requested file name.

Once the remote CPU has connected, it will send requests to get the boot
file.  The first request will be an OPEN, followed by some number of
READ's, and finally a CLOSE.

A state diagram of the protocol is shown below:

.CS
  +-------+             +----------+           +-------+--read|write-|
  | CLOSED|             | CONNECTED|           | OPENED|             |
  +-------+---connect-->+----------+---open--->+-------+<------------|
      ^                                          |
      |--------------close-----------------------|
.CE

.SH AUTOBOOT
In addition to the requests described above, isiBootd also handles
AUTOBOOT requests.  When this request is received, isiBootd simply 
sends back a packet whose data is the boot line for that remote.  It
knows this from the configuration file (described below).

.SH FAKING IT OUT
To some extent, this daemon is fooling the remote boot.  The remote boot
thinks it is making requests from a Unix host somewhere.  In fact, it
is is actually making the requests of a VxWorks system in the same chassis.
When the remote first does its CONNECT, the bootd keeps track of the
host name of the Unix host to which the CONNECT is really being done.  Later,
when an OPEN is performed, the bootd will open the requested file on that
Unix host.

.SH MULTIPLE REQUESTS
In order for the bootd to support requests from more than one 
machine at once a "connection block" list is used.  When a packet comes
in we check through all active connections blocks to see if there is one with
a network address field the same as the packets source address.  If so, we 
use that connection state to service the packet.  If no connection was found
we get a new connection block from the idle pool.  When the connection is 
closed the connection block is returned to the idle pool.

.SH BOOT CONFIGURATION FILE
At initialization, an initialization file is read, which contains the
boot line necessary to autoboot the remotes.
This file has information relating ethernet address to a machine's
host name its boot strings. Lines in the file consist of the following ASCII
representation: ethernet-address hostname bootstring. Such as:

3c:7b:00:00:00:01  dino         wrs:/usr/vw/config/is20/vxWorks b=91.0.0.5 h=90.0.0.2 g=91.0.0.8 u=jerry

where the first part is a 48 bit ethernet address, the second is the 
corresponding remote's name (which is currently ignored under VxWorks),
and remainder of the line is the boot string.
The ethernet address is represented as "x:x:x:x:x:x" where x is a hex 
number between 00 and ff;  the bytes are always in network order.
For remotes being booted over the backplane, the ethernet address is
always 3c:7b:00:00:00:<nn>, where <nn> is the CPU number of that remote.
Lines may be commented with a "#" as their first character.

The configuration file
is in /etc/bootd.conf.<in>, where <in> is the internet address of the
CPU on which the boot daemon is running (CPU 0) on the backplane net.
For instance, if the VxWorks CPU acting as CPU 0 was booted with the
following line:

 ex(0,0)wrs:/usr/vw/config/is20/vxWorks e=90.0.0.3 h=90.0.0.2 b=91.0.0.8 u=jerry

then the configuration file would be read from ``/etc/bootd.conf.91.0.0.8''.
