.TH intLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
intLib.c - interrupt subroutine library 
.SH SYNOPSIS
.nf
intConnect - connect C routine to hardware interrupt
intHandlerCreate - construct interrupt handler for C routine
intContext - determine if we are in interrupt context or task context
intCount - get current interrupt nesting depth
intLock - lock out interrupts
intUnlock - cancel effect of intLock
intVecBaseSet - set the vector base address
intVecBaseGet - get the vector base address
intVecSet - set CPU vector
intVecGet - get vector

STATUS intConnect (vector, routine, parameter)
FUNCPTR intHandlerCreate (routine, parameter)
BOOL intContext ()
int intCount ()
int intLock ()
VOID intUnlock (level)
VOID intVecBaseSet (baseAddr)
FUNCPTR *intVecBaseGet ()
VOID intVecSet (vector, function)
FUNCPTR intVecGet (vector)
.fi
.SH DESCRIPTION
This library provides routines to manipulate and connect to hardware
interrupts and exceptions.
Most importantly, any C language routine can be connected to any exception,
interrupt, or trap by calling the routine intConnect.
Interrupt vectors can be accessed directly by the routines
intVecSet and intVecGet.
On the 68010 and 68020, the vector base register can be accessed by the routines
intVecBaseSet and intVecBaseGet.
Tasks can lock and unlock interrupts by calling the routines
intLock and intUnlock.
The routines intCount and intContext can be used to determine whether
the CPU is running in an interrupt context or in a normal task context.

.SH INTERRUPT VECTORS AND NUMBERS
Most of the routines in this library take an interrupt vector as a
parameter, which is the byte offset into the vector table.
Macros are provided to convert these interrupt vectors to interrupt
numbers and vice versa: IVEC_TO_INUM(intVector) changes a vector
to a number.  INUM_TO_IVEC(intNumber) turns a number into a vector.
TRAPNUM_TO_IVEC(trapNumber) converts a trap number to a vector.

.SH EXAMPLE
There are instances where it is desired to switch between one of
several routines for a particular interrupt.  The following
code fragment is one alternative.
.CS
    vector  = INUM_TO_IVEC(some_int_vec_num);
    oldfunc = intVecGet (vector);
    newfunc = intHandlerCreate (routine, parameter);
    intVecSet (vector, newfunc);
    ...
    intVecSet (vector, oldfunc);    /* use original routine *
    ...
    intVecSet (vector, newfunc);    /* reconnect new routine *
.CE

.SH INCLUDE FILE
iv68k.h
