.TH inetLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
inetLib.c - Internet address manipulation routines 
.SH SYNOPSIS
.nf
inet_addr - convert a dot notation Internet address to a long integer
inet_lnaof - get local net address (host number) from Internet address
inet_makeaddr_b - construct an Internet address from network + host numbers
inet_makeaddr - construct an Internet address from network + host numbers
inet_netof - return the network number from an Internet address
inet_netof_string - local network extractor in dot notation
inet_network - convert Internet network number from string to address
inet_ntoa_b - convert network dot notation address to ASCII
inet_ntoa - convert network dot notation address to ASCII

u_long inet_addr (inetString)
int inet_lnaof (inetAddress)
VOID inet_makeaddr_b (netAddr, hostAddr, pInetAddr)
struct in_addr inet_makeaddr (netAddr, hostAddr)
int inet_netof (inetAddress)
VOID inet_netof_string (inetString, netString)
u_long inet_network (inetString)
VOID inet_ntoa_b (inetAddress, pString)
char *inet_ntoa (inetAddress)
.fi
.SH DESCRIPTION
InetLib provides routines for manipulating Internet addresses,
including the UNIX BSD 4.3 "inet_" routines.
There are routines for converting
between character addresses in Internet standard "." (dot)
notation and integer addresses, routines for extracting the
network and host portions out of an Internet address, and routines
for constructing Internet addresses given the network and host
address parts.

All Internet addresses are returned in network order (bytes
ordered from left to right).  All network numbers and local
address parts are returned as machine format integer values.

.SH INTERNET ADDRESSES

Internet addresses are typically specified in dot notation or
as a 4 byte number.  Values specified using the dot notation
take one of the following forms:

                a.b.c.d
                a.b.c
                a.b
                a

When four parts are specified, each is interpreted as a byte
of data and assigned, from left to right, to the four bytes
of an Internet address.  Note that when an Internet address
is viewed as a 32-bit integer quantity on any MC68000 family
machine, the bytes referred to above appear as ``a.b.c.d''.
That is, MC68000-based bytes are ordered from left to right.

When a three-part address is specified, the last part is
interpreted as a 16-bit quantity and placed in the right-most
two bytes of the network address.  This makes the three-part
address format convenient for specifying Class B network
addresses as ``128.net.host''.

When a two-part address is supplied, the last part is interpreted
as a 24-bit quantity and placed in the right-most
three bytes of the network address.  This makes the two-part
address format convenient for specifying Class A network
addresses as ``net.host''.

When only one part is given, the value is stored directly in
the network address without any byte rearrangement.

All numbers supplied as parts in a dot notation may be
decimal, octal, or hexadecimal, as specified in the C
language.  That is, a leading 0x or 0X implies hexadecimal;
otherwise, a leading 0 implies octal.  With no leading 0,
the number is interpreted as decimal.

.SH INCLUDE FILES
inetLib.h, in.h

.SH SEE ALSO
"Network", UNIX BSD 4.3 documentation for inet (3N)
