.TH ftpLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpLib.c - ARPA File Transfer Protocol library 
.SH SYNOPSIS
.nf
ftpCommand - send FTP command and get reply
ftpXfer - initiate transfer via FTP
ftpReplyGet - get FTP command reply
ftpHookup - get control connection to FTP server on specified host
ftpLogin - login to remote FTP server
ftpDataConnInit - initialize FTP data connection
ftpDataConnGet - get a completed FTP data connection

int ftpCommand (ctrlSock, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
STATUS ftpXfer (host, user, passwd, acct, cmd, dirname, filename, ...
int ftpReplyGet (ctrlSock, expecteof)
int ftpHookup (host)
STATUS ftpLogin (ctrlSock, user, passwd, account)
int ftpDataConnInit (ctrlSock)
int ftpDataConnGet (dataSock)
.fi
.SH DESCRIPTION

This library provides facilities for transferring files to and from a
host via FTP (File Transfer Protocol).
This library provides only the "client" side of the FTP facilities.

.SH FTP IN VXWORKS
VxWorks supplies an I/O driver, netDrv (3), that allows transparent access of
remote files via standard I/O system calls.  In its FTP mode, netDrv
uses the FTP facilities provided by this library to access the remote files.
This is the primary use of FTP in VxWorks.  Thus for most purposes,
no familiarity with ftpLib itself is necessary.

.SH HIGH LEVEL INTERFACE
The highest level of direct interface to FTP is provided by the routines
ftpXfer and ftpReplyGet.
The routine ftpXfer connects to a specified remote FTP server,
logs in under a specified user name, and initiates a specified data transfer
command (see ftpXfer (2) for details).
The routine ftpReplyGet is used to get control reply reply messages sent
by the remote FTP server in response to the commands sent.

.SH LOW LEVEL INTERFACE
A lower level of interface is provided by the routines ftpHookup, 
ftpLogin, ftpDataConnInit, ftpDataConnGet, and ftpCommand.
These routines provide the primatives necessary to create and use both
control and data connections to remote FTP servers.
As an example of how to use these lower level routines, the following
code fragment implements roughly the same function as the ftpXfer routine
(see ftpXfer (2) for details):
.CS
    char *host, *user, *passwd, *acct, *dirname, *filename;
    int ctrlSock = ERROR;
    int dataSock = ERROR;

    if (((ctrlSock = ftpHookup (host)) == ERROR)                   ||
        (ftpLogin (ctrlSock, user, passwd, acct) == ERROR)         ||
        (ftpCommand (ctrlSock, "TYPE I") != FTP_COMPLETE)          ||
        (ftpCommand (ctrlSock, "CWD %s", dirname) != FTP_COMPLETE) ||
        ((dataSock = ftpDataConnInit (ctrlSock)) == ERROR)         ||
        (ftpCommand (ctrlSock, "RETR %s", filename) != FTP_PRELIM) ||
        ((dataSock = ftpDataConnGet (dataSock)) == ERROR))
        {
        /* some error occured; close any open sockets and return *

        if (ctrlSock != ERROR)
            close (ctrlSock);
        if (dataSock != ERROR)
            close (dataSock);
        return (ERROR);
        }
.CE

.SH INCLUDE FILE
ftpLib.h

.SH SEE ALSO
netDrv (3)
