.TH floatLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
floatLib.c - floating point formatting & conversion subroutine library 
.SH SYNOPSIS
.nf
floatInit - initialize floating-point I/O support
frexp - split into mantissa and exponent
ldexp - split into mantissa and exponent
modf - split into mantissa and exponent
ecvtb - convert floating point to ASCII representation
fcvtb - convert floating point to ASCII representation (Fortran-style)
gcvt - convert floating point to ASCII representation (e- or f-style)

VOID floatInit ()
double frexp (value, eptr)
double ldexp (value, exp)
double modf (value, iptr)
char *ecvtb (value, ndigit, decpt, sign, buffer)
char *fcvtb (value, ndigit, decpt, sign, buffer)
char *gcvt (value, ndigit, buffer)
.fi
.SH DESCRIPTION
This library provides all the floating-point formatting and conversion
routines to be used in fioLib(1), and some related floating-point routines.
To allow re-entrancy ecvtb and fcvtb are provided in place of
UNIX ecvt and fcvt.

This library is optional and may be omitted by removing the call to
floatInit in usrRoot(2), in usrConfig(1).  If omitted, format
specifications in printf(2) and scanf(2) will not be supported.
