.TH fioLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fioLib.c - formatted I/O library 
.SH SYNOPSIS
.nf
printf - print formatted string to standard output
fdprintf - print formatted string to specified fd
sprintf - convert arguments to text under format control
fioFormat - format processor
sscanf - obtain values for arguments from ASCII string
fioStdIn - get current assignment of standard input fd (obsolete)
fioStdOut - get current assignment of standard output fd (obsolete)
fioStdErr - get current assignment of standard error fd (obsolete)
printErr - print formatted string to standard error fd
fioRead - read a full buffer or to end-of-file
fioRdString - read a string from a file

VOID printf (fmt, args)
VOID fdprintf (fd, fmt, args)
int sprintf (buffer, fmt, args)
VOID fioFormat (fmt, arg_list, routine, outarg)
int sscanf (str, fmt, args)
int fioStdIn ()
int fioStdOut ()
int fioStdErr ()
VOID printErr (fmt, args)
int fioRead (fd, buffer, maxbytes)
int fioRdString (fd, string, maxbytes)
.fi
.SH DESCRIPTION
This library provides a higher level interface to the I/O system,
including formatted I/O.  This library implements some of the
facilities of stdioLib (1) the UNIX compatible "standard I/O" library.

Additional, and optional, floating-point formatting and conversion
routines are found in floatLib (1).  The routine floatInit (2) must
be called before format specifications '%e', '%f', or '%g' are
understood.

.SH SEE ALSO
stdioLib (1), floatLib (1)
