.TH errnoLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
errnoLib.c - error status library 
.SH SYNOPSIS
.nf
errnoGet - get error status value of calling task
errnoOfTaskGet - get error status value of specified task
errnoSet - set error status value of calling task
errnoOfTaskSet - set error status value of specified task

int errnoGet ()
int errnoOfTaskGet (taskId)
STATUS errnoSet (errno)
STATUS errnoOfTaskSet (taskId, errno)
.fi
.SH DESCRIPTION
This library contains routines for setting and examining the error status
values of tasks and interrupts.
Most VxWorks functions return a result of ERROR, or NULL in the case of
functions returning pointers, when they detect an error.
In addition they set an error status, or "errno", for the current
task or interrupt that elaborates the nature of the error.

This facility is analagous to the Unix error status mechanism in which error
status values are set in the global variable "errno".  However, in VxWorks
there are many contexts, both task and interrupt, that share the common
memory space and hence would conflict in their use of a global variable.
Instead, VxWorks supplies routines to set and get error status values,
and these routines maintain the value for each context separately.

This facility is used throughout VxWorks for error reporting,
but application modules are encouraged to use the same mechanism,
where appropriate.

.SH ERROR STATUS VALUES
An error status is a 4 byte integer.
By convention, the most significant two bytes are the module number,
which indicates the module in which the error occurred,
and the lower two bytes indicate the specific error within that module.
Module number 0 is specifically reserved for Unix error numbers, so that
values from the Unix errno.h header can be set and tested without modification.
Module numbers 1-500 decimal are reserved for VxWorks modules.
These are defined in vwModNum.h.
All other module numbers are available to applications.

.SH TASK ERROR STATUS
The error status of each task is kept in its TCB extension.
It is zeroed when the task is first spawned.
Thereafter, the error status is set whenever a VxWorks routine detects an error.
It is never cleared by VxWorks.

.SH INTERRUPT LEVEL ERROR STATUS
It is possible to set and get error status from code executing
at interrupt level.
At interrupt level, error status is stored in an
array at an index corresponding to the level of interrupt nesting.
The routines to set and get error status explicitly check if they
are being executed at interrupt level, and if so, 
set the status at the appropriate interrupt nesting level.
Note that this is the interrupt nesting level, NOT the interrupt
mask level itself, since it is possible to have several nested interrupt
handlers active at the same mask level, if the interrupt mask level is
explicitly lowered by an interrupt handler.

The maximum interrupt nesting level that errnoLib is capable of handling
is MAX_INT_NEST (50).  Beyond that, errnoGet and errnoSet will return an error.

.SH PRINTING ERROR STATUS VALUES
VxWorks can include a special symbol table called statSymTbl.
This is used by printErrno (2) to print human-readable error messages,
given the binary status value.

The table is created using the tool makeStatTbl (4) in vw/bin.  This tool
reads all the .h files in a directory and generates a C language file
which, when compiled, generates a symbol table.  Each symbol consists
of a value, which is an error status value, and a string, which is
the definition string of the value from the header file.

For example, suppose the header file vw/h/myFile.h contains the line:

    #define S_myFile_ERROR_TOO_MANY_COOKS       0x230003

StatSymTbl is created by running:

    makeStatTbl vw/h >statTbl.c

This creates a file, statTbl.c, that can be compiled into a special
symbol table called statSymTbl.  That file is then linked in with
VxWorks.  This is normally done automatically by the vw/config makefile.

If the user now types, to the VxWorks shell:

    -> printErrno 0x230003

printErrno would respond:

    
    S_myFile_ERROR_TOO_MANY_COOKS

There are several important things to note about this facility.
First, makeStatTbl (4) looks for error status lines of the form:

    #define S_xxx  <n>

where xxx is any string, and <n> is any number.
All VxWorks status's are of the form:

    #define S_thisFile_MEANINGFUL_ERROR_MESSAGE   0xnnnn

where thisFile is the name of the module.

This facility is available to the user.  Simply add header files with
status lines of the appropriate forms, and re-make VxWorks.

.SH INCLUDE FILES
The file vwModNum.h contains the module numbers for every VxWorks module.
Each module's include file contains the error numbers that that module
can generate.

.SH SEE ALSO
"Architecture" (Subroutine Error Status), printErrno (2)
