.TH ctypeLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ctypeLib.c - character classification and conversion macros 
.SH SYNOPSIS
.nf

NO CALLABLE ROUTINES
.fi
.SH DESCRIPTION
This UNIX compatible library consists of macros which classify or
convert ASCII-coded characters by table lookup.
The macros are defined in ctype.h.

Each macro takes a character parameter, and return non-zero for TRUE, 
or zero for FALSE.

.CS
    isalpha  (c) - c is a letter
    isupper  (c) - c is an upper case letter
    islower  (c) - c is a lower case letter
    isdigit  (c) - c is a digit
    isxdigit (c) - c is a hexadecimal digit
    isspace  (c) - c is an space, tab, carriage return, newline,
                     or formfeed
    ispunct  (c) - c is a punctuation character (neither control
                     nor alphanumeric)
    isalnum  (c) - c is an alphanumeric character
    isprint  (c) - c is a printable character, code 040 (space)
                     through 0176 (tilde)
    isgraph  (c) - c is a visible graphics character, code 041
                     (exclamation mark) through 0176 (tilde)
    iscntrl  (c) - c is a delete character (0177) or ordinary
                     control character (less than 040)
    isascii  (c) - c is an ASCII character, code less than 0200
.CE

The following macros perform simple conversions on single characters.

.CS
    toupper  (c) - converts c to its upper case equivalent
    tolower  (c) - converts c to its lower case equivalent
    toascii  (c) - forces c to be ASCII (strips highest eighth
                   bit of character)
.CE

.SH INCLUDE FILE
ctype.h
