.TH bootLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
bootLib.c - boot rom subroutine library 
.SH SYNOPSIS
.nf
bootStringToParams - interpret the boot parameters from the boot line
bootParamsToString - construct a boot line
bootParamsShow - print boot line parameters
bootParamsPrompt - prompt for boot line parameters
bootNetmaskExtract - extract netmask field from adrs:mask field
bootBpAnchorExtract - extract backplane anchor field from bp=addr field

char *bootStringToParams (bootParams, bootDev, hostName, bootFile,  ...
STATUS bootParamsToString (paramString, bootDev, hostName, bootFile, ...
VOID bootParamsShow (paramString)
VOID bootParamsPrompt (string)
STATUS bootNetmaskExtract (string, pNetmask)
STATUS bootBpAnchorExtract (string, pAnchorAdrs)
.fi
.SH DESCRIPTION
This library contains routines for manipulating a boot line.
Routines are provided to interpret, construct, print, and prompt for
a boot line.

When VxWorks is first booted, certain parameters are specified pertaining
to network addresses, boot device, host, file, etc.
This information is encoded into a single ASCII string known as the boot line.
The boot line is placed at a known address (specified in config.h)
by the boot roms so that the system being booted can discover the parameters
that were used to boot the system.
The boot line is the ONLY means of communication from the boot roms to
the booted system.

The boot line is of the form:

bootdev(0,procnum)hostname:filename e=# b=# h=# g=# u=userid pw=passwd f=#

.SH EXAMPLE
.CS
 enp(0,0)host:/usr/vw/mz7122/config/vxWorks e=90.0.0.2 b=91.0.0.2
              h=100.0.0.4 g=90.0.0.3 u=vxWorks pw=realtime f=2


 where:
   bootdev  = "ex" for excelan ethernet, "bp" for backplane, etc.
                 - for "bp" this field can have an optional anchor
                   address specification of the form "bp=<adrs>"
                   (see bootBpAnchorExtract(1))
   procnum  = the processor number on the backplane (0..n).
   hostname = the name of the host to boot from.
   filename = the file to be booted.
   e        = the internet address of the ethernet interface.
                 - this field can have an optional subnet mask
                   of the form <inet_adrs>:<subnet_mask>
                   (see bootNetmaskExtract(1))
   b        = the internet address of the backplane interface.
                 - this field can have an optional subnet mask
                   as above
   h        = the internet address of the host to boot from.
   g        = the internet address of the gateway to the host.
                 - leave blank if host is on same network
   u        = a valid user name on the host.
   pw       = password for user on the host.
                 - usually left blank;
                 - if specified, then "ftp" is used for file
                   transfers
   f        = system dependent configuration flags.
                 - contains an `or' of option bits defined in
                   sysLib.h
.CE
 Internet addresses are specified in standard "dot" notation, e.g. 90.0.0.2.
 The order of assigned values is arbitrary.

.SH SEE ALSO
bootConfig (1)
