.de Ch
.B "\\$1" "\\$2"
..
.de Co
.I "\\$1" "\\$2"
..
.de Ci
.ie \\n(.$ \fR\\$1 \fR\\$2
.el .R
..
.po 1.25i
.WP "Getting Started" VxWorks 4.00
.TL
GETTING STARTED
.SP
.N 1 "INTRODUCTION"
.LP
One of VxWorks' biggest strengths is the ease with which you can get
your development environment up and running.
If you have the necessary hardware and software pieces, you should be able
to install, configure, and boot VxWorks, and be downloading and debugging
application code, in less than half an hour.
.LP
This chapter gives step-by-step procedures for getting started with VxWorks.
It covers:
.LP
.RS
.IP \\(bu .15i
installing the VxWorks files from the distribution tape;
.IP \\(bu
configuring the software on the UNIX host system;
.IP \\(bu
configuring the target hardware, typically a single board computer plus
Ethernet hardware;
.IP \\(bu
booting VxWorks via ethernet using the boot ROMs;
.IP \\(bu
downloading and running a demo program on VxWorks, and exercising VxWorks'
testing and debugging facilities;
.IP \\(bu
troubleshooting, if anything goes wrong in bringing up VxWorks.
.RE
.sp .5
.LP
This chapter discusses bringing up VxWorks in a relatively simple
configuration.
Other chapters elaborate more advanced options.
In particular, the
.Ch NETWORK
chapter discusses the more complicated issues of gateways, NFS, multi-processor
target systems, and so on.
Also, the
.Ch CROSS-DEVELOPMENT
chapter discusses the procedures for reconfiguring and rebuilding VxWorks.

.N 1 "A TYPICAL CONFIGURATION"
.LP
VxWorks is a very flexible system that has been ported to many different
hardware configurations.
This chapter assumes the typical minimum target system configuration
listed below.
You should also consult the target-specific information that is supplied
for each port of VxWorks.
.sp .5
.na
.TS
center,box;
cp12f3 s
c|c
l|lw(2.5i) .
.sp .5
Typical Minimum Configuration
.sp .5
=
\fBComponent	Description\fR
_
.sp .5
Chassis/Power Supply 	T{
A card cage with backplane, typically a VMEbus, and a power supply.
T}

CPU board	T{
A single-board computer to which VxWorks has been ported.
T}

Ethernet board	T{
An Ethernet controller board (some CPU boards include the ethernet controller
on-board).
T}

Console	T{
An ASCII terminal or a serial port on a workstation,
required for initial set-up.
T}
.sp .5
.TE
.ad

.N 1 "INSTALLING VxWORKS ON YOUR HOST SYSTEM"
.LP
You will receive VxWorks on a magnetic tape in
.Sy tar
format.
In order to install it, make a directory on your system called
.Mo vw .
Change to that directory and read the media in with
.Sy tar .
The host commands to do all this are:
.DS
.Ci
% mkdir vw
% chmod 755 vw
% cd vw
% tar xv
.R
.DE
.LP
Your
.Mo vw
directory will now have a number of subdirectories and files in it.
The directory
.Mo vw/config
contains a directory for each of the target types you have ordered.
In each of those directories, there is the system boot image,
.Mo vxWorks ,
and its symbol table,
.Mo vxWorks.sym .
These files
.Mo \f1(\fPvw/config/<target>/vxWorks
and
.Mo vw/config/<target>/vxWorks.sym )
are the only files you need to get started with VxWorks.
.LP
In general, this manual refers to VxWorks directories and files
with relative pathnames starting at the
.Mo vw
directory you just created.
For clarity, in examples where a full pathname must be specified
the files are sometimes refered to as
.Mo /usr/vw/... .
However, there is nothing in VxWorks that assumes or requires this pathname.
.LP
The VxWorks directory structure and file contents
are described in detail at the end of this chapter.

.N 1 "CONFIGURING THE HOST SYSTEM"
.LP
Before VxWorks can be booted from the host, the network software on
the UNIX host must be correctly configured.
There are three main tasks in configuring the host network software
to get started with VxWorks:
.LP
.RS
.IP \\(bu .15i
initializing the host network software,
.IP \\(bu
establishing the VxWorks system name and network address on the host,
.IP \\(bu
giving the VxWorks system appropriate access permissions on the host.
.RE
.sp .5
.LP
The following sections describe the procedures in detail.
Note that some of these procedures may require root permissions,
and your system administrator should be consulted.
Also note that some UNIX systems may have slightly different procedures.

.N 2 "Initializing the Host Network Software"
.LP
Most UNIX systems automatically initialize the network subsystem and
activate network processes in the start-up file
.Mo /etc/rc.local .
This typically includes configuring the network interface with the
.Sy ifconfig
command and starting various network daemons.
Consult your UNIX system administration manuals if network initialization
needs to be added to your UNIX start-up procedure.

.N 2 "Establishing the VxWorks System Name and Address: /etc/hosts"
.LP
The UNIX host system maintains a ``database'' of the names and
network addresses of systems that are reachable by the local system.
This database is kept in the ASCII file
.Mo /etc/hosts
which contains a line for each system.
Each line consists of an Internet address and the name(s)
of the system at that address.
This file must have entries for your host UNIX
system and the VxWorks target system.
.LP
For example, suppose your UNIX host system was named ``mars'' and had been
assigned Internet address 90.0.0.1, and you wanted to name your VxWorks
target ``phobos'' and assign it address 90.0.0.50.
Then the file
.Mo /etc/hosts
should contain the following lines:
.DS
90.0.0.1	mars
90.0.0.50	phobos
.DE
.LP
NOTE: if your system is running the Yellow Pages service, then the ``hosts''
database is maintained by
.Sy YP
facilities that are beyond the scope of this introduction.
Consult your UNIX system administration manuals if you are running
.Sy YP .

.N 2 "Giving VxWorks Access to the Host:\ \ .rhosts and /etc/hosts.equiv"
.LP
The UNIX system restricts network access to remote login, remote
command execution, and remote file access.
This is done with the
.Mo .rhosts
file in a user's home directory, and more globally with the
.Mo /etc/hosts.equiv
file.
The
.Mo .rhosts
file contains a list of system names
that have access to your login.
Thus, for our example, you would create a
.Mo .rhosts
file in your home directory containing the single line:
.DS
phobos
.DE
.LP
This will allow the VxWorks system to login with your user name and
access files with your permissions.
.LP
The
.Mo /etc/hosts.equiv
file provides a less selective mechanism.
Systems listed in
.Mo /etc/hosts.equiv
are allowed login access to
.I any
user defined on the local system (except the super-user
.I root ).
Thus, adding the VxWorks system name to
.Mo /etc/hosts.equiv
will allow the VxWorks system to login with any user name on the system.

.N 1 "TARGET HARDWARE CONFIGURATION"
.LP
Configuring the target hardware involves the following tasks:
.LP
.RS
.IP \\(bu .15i
installing the VxWorks boot ROMs,
.IP \\(bu
jumpering the CPU and ethernet boards,
.IP \\(bu
installing the boards in the backplane,
.IP \\(bu
connecting the serial and ethernet cables.
.RE
.sp .5
.LP
Use the following general procedures, as appropriate to your
particular target system hardware.
Refer to the target-specific information under
.Ch "HOST/TARGET (5)"
for each of your target CPU boards.

.N 2 "Installing the Boot ROMs"
.LP
Wind River supplies boot ROMs for your selected targets
as part of the VxWorks delivery.
These are used for booting VxWorks over the network.
Install the appropriate set of boot ROMs on your target CPU board(s).
.LP
When installing these devices, observe the following precautions:
.LP
.RS
.IP \\(bu .15i
Install each device only in the socket indicated on the label.
.IP \\(bu
Note the correct orientation of pin 1 for each device.
.IP \\(bu
Use anti-static precautions whenever working with integrated
circuit devices.
.RE
.sp .5
.LP
The file
.Mo bootrom.hex
exists or can be made in each target CPU directory.
This file contains the boot ROMs in S-record format,
and is suitable
for downloading to a PROM programmer for making your own VxWorks boot ROMs.
To make
.Mo bootrom.hex ,
change to the directory
.Mo vw/config/<target>
for your target, and type:
.DS
% make bootrom.hex
.DE

.N 2 "Setting the Board Jumpers"
.LP
Many CPU and Ethernet controller boards have configuration options that
are selected by hardware jumpers.
These jumpers \f2must\fP be installed correctly
to bring up VxWorks successfully.
You can determine the correct jumper configuration for your
target CPU from the target-specific information provided under
.Ch "HOST/TARGET (5)"
or use the
.Sy jump
program supplied with the VxWorks system.
The
.Sy jump
program runs on UNIX
and displays jumpering diagrams for the CPU and Ethernet controller boards
using simple ASCII graphics.
.LP
To run
.Sy jump ,
type:
.DS
.Mo vw/bin/jump\ \ vw/config/<target>
.DE
where \fI<target>\fP is the VxWorks directory name which corresponds
to your target system.
.Sy Jump
will prompt you with a selection of CPU boards
for which jumpering diagrams
can be displayed.

.N 2 "Installing the Boards in the Backplane"
.LP
To assemble the target hardware, first install the CPU board in slot 1 of the
backplane.
If you are using a separate Ethernet controller board, install it in slot 2
of the backplane.
.LP
If you are using a VMEbus backplane there are several issues you should
consider:
.LP
.IP "\\(bu  \f3P1 and P2 Connectors\fP"
.br
The P1 connecter must be completely bussed across all the boards in the system.
Many systems also require the P2 bus.
Some boards require power on the P2 connector.
Also some configurations require the extended address and data lines
of the B row of the P2 bus.
.IP "\\(bu  \f3System Controller\fP"
.br
The VMEbus requires that a ``system controller'' be present in slot 1.
Many CPU boards have a system controller on board that can be enabled
or disabled by hardware jumpers.
On such boards, the system controller should be enabled in slot
1 and disabled in all others.
The diagrams shown by the
.Sy jump
program (described above) indicate the location of the system controller
enable jumper, where available.
Alternatively, a separate system controller board can be installed in slot 1
and the CPU and Ethernet boards plugged into the next two slots.
.IP "\\(bu  \f3Empty Slots\fP"
.br
The VMEbus has several daisy chained signals that must be propagated
to all the boards on the backplane.
If you leave any slot empty between boards on the backplane you must
jumper the backplane to propagate the Bus Grant and Int Ack daisy chains.

.N 2 "Connecting the Cables"
.LP
All VxWorks supported CPU boards include at least one on-board serial port.
This serial port must be connected to an ASCII terminal, at least for the
initial configuration of the boot ROMs and getting started with VxWorks.
Subsequently, VxWorks can be configured to boot automatically without
a terminal.
Refer to the CPU board hardware documentation for proper connection
of the RS-232 signals.
.LP
For the Ethernet connection, a transceiver cable must be connected from
the Ethernet controller to an Ethernet transceiver.

.N 1 "BOOTING VxWORKS"
.LP
If you have correctly configured your host software and target hardware,
you are ready to turn on the target system power and try to boot VxWorks.
When you power-on and reset the target hardware, the target system
terminal will be talking to the VxWorks boot ROMs.
The boot ROMs will first display a banner page,
and then start a 7-second count-down, visible on the screen.
Unless you press any key on the keyboard within that 7 seconds,
VxWorks will automatically boot with a default configuration.
.LP
Now, power-on and reset the target and stop the automatic boot by pressing
a key on the keyboard, such as the space bar.
The VxWorks boot prompt will then be displayed:
.DS
.Co "[VxWorks Boot]:"
.DE

.N 2 "Boot ROM Commands"
.LP
The VxWorks boot ROMs provide a limited set of commands.
To see a list of available commands, type the help command:
.DS
.Ci ? <\s-2RETURN\s+2>
.DE
.LP
The following table lists the VxWorks boot commands, with a brief
description of each parameter.
.LP
.de iP
.sp .5
.ti -1i
\\$1
.sp -1
..
.TS
box,expand;
cp12f3 s    
lf3  lf3     
af3  lw(4.2i)  .
.sp .5
VxWorks Boot Commands
.sp .5
=
\fBCommand	Description\fR
_
.sp .5
h	``Help'' command \(em print list of available boot commands.

?	Same as \fBh\fP.

p	Print current boot parameters.

c	Change boot parameters.

@	Boot (load file and execute) using current boot parameters.

l	Load file using current boot parameters, without executing it.

g \f2adrs\fP	Go (execute) at hex address \fIadrs\fP.

d \f2adrs\fP[,\f2n\fP]	T{
Display \fIn\f words of memory starting at hex address
\fIadrs\fP.
If \fIn\fP is omitted, the default value is 64.
T}

m \f2adrs\fP	T{
Modify memory at location \fIadrs\fP (hex). 
Prompts the user for modifications to memory, starting at the
specified address.
It prints each address, and the current 16-bit
value at that address, in turn.
The user can respond in one
of several ways:
.in +1i
.iP "<\s-2RETURN\s+2>"
.fi
No change to that address, but continue prompting at next address.
.iP "\f2<number>\fP"
Set the 16-bit contents to \f2<number>\fP.
.iP "\&. (dot)"
No change to that address, and quit.
.in
T}

f \f2adrs\fP, \f2nbytes\fP, \f2value\fP	T{
Fill \fInbytes\fP of memory starting at \fIadrs\fP with \fIvalue\fP.
T}

s [0|1]	T{
Turn the system controller of the CPU on (1) or off (0) (only on boards
that have software enable of system controller).
T}

e	Print a synopsis of the last VxWorks exception that occurred.
.sp .5
.TE

.N 2 "Entering Boot Parameters"
.LP
Before booting VxWorks, you must set the configuration parameters for
the boot, including the host and target network addresses, file to be
booted, user name, etc.
To display the current boot parameters, type the command:
.DS
.Ci p <\s-2RETURN\s+2>
.DE
You will see a display which looks something like this:
.DS

.TS
l l .
boot device:	enp
host name:	host
file name:	/usr/vw/config/<target>/vxWorks
inet on ethernet (e):	90.0.0.50
inet on backplane (b):
host inet (h):	90.0.0.1
gateway inet (g):
user (u):	fred
ftp password (pw) (blank = use rsh):
processor number:	0
flags (f):	0
.TE

.DE
The meaning of each of these parameters is described in the next section.
Network information must be entered to match your particular system
configuration.
The Internet addresses should correspond to those in
.Mo /etc/hosts
on your UNIX host, as described previously.
.LP
You can change the boot parameters by typing the command:
.DS
.Ci c <\s-2RETURN\s+2>
.DE
The boot ROM will prompt you for each parameter.
If the contents of a
particular field does not need to be changed, just hit \s-2RETURN\s+2.
If a field is to be cleared, type a period (\fB.\fP), followed by
\s-2RETURN\s+2.
.LP
If the CPU board has non-volatile RAM, the boot parameters will be stored there
and retained even while the system power is turned off.
The boot ROMs will use the stored parameters for the default configuration
of the automatic boot after 7 seconds on subsequent power-on or system resets.

.N 2 "Description of Boot Information"
.LP
The boot parameters should be specified as follows:
.de iP
.sp
.IP "\fB\\$1\fP\h'|1.4i'-" 1.5i
..
.iP "boot\ device"
Specifies type of network device from which to boot.
Must be one of the network drivers included in
the boot ROMs (i.e. ``enp'' for a CMC controller).
Due to limited space in the boot ROMs, only a few drivers
can be included.
A list of included drivers is displayed at the bottom of the help screen
(type ``?'').
.iP "host\ name"
The name of the host machine from which to boot; ``mars'' in our example.
.iP "boot\ file"
The full path name of the VxWorks object module to be booted, e.g.
.Mo /<path>/vw/config/<target>/vxWorks .
.iP "inet\ on\ Ethernet\ (e)"
The Internet address of a target system with an Ethernet interface;
90.0.0.50 in our example.
.iP "inet\ on\ backplane\ (b)"
The Internet address for a CPU with a backplane interface;
this should be blank in our example.
.iP "host\ inet\ (h)"
The Internet address of the UNIX host from which to boot;
90.0.0.1 in our example.
.iP "gateway\ inet\ (g)"
The Internet address of a gateway node if the host is not on
the same network as the target; this should be blank in our example.
.iP "user\ (u)"
The user name with which VxWorks will access the UNIX host;
the named user should have read access to VxWorks file being booted.
VxWorks must have access to this user's account, either by the
.Mo .rhosts
or
.Mo /etc/hosts.equiv
files discussed above, or by the
.Mo ftp
password provided below.
.iP "ftp\ password\ (pw)"
The ``user'' password.
This field is optional.
If a password is given,
\fIftp\fP will be used instead of \fIrsh\fP.
If you do not want to use \fIftp\fP, then leave this field blank.
.iP "processor\ number"
A unique identifier for the CPU in systems with multiple CPU's on a backplane;
this should be zero in our example.
.iP "flags (f)"
Configuration options specified as a numeric value that is the sum of the
values of selected option bits defined below.
In general, \fIflags\fP should be zero.
.TA
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
c aw(3i).
.sp .25
Boot Flags
.sp .25
_
Value	Meaning
_
.sp .25
1	Don't enable system controller even if processor number = 0.
2	Load all VxWorks symbols, instead of just globals.
4	Don't auto-boot.
8	Auto-boot fast (short countdown).
.sp .25
.TE

.N 2 "Booting"
.LP
Once you have entered the boot parameters, you initiate the boot by typing:
.DS
.Ci @ <\s-2RETURN\s+2>
.DE
The VxWorks boot ROMs will print the boot parameters and the download will
begin.
While VxWorks is booting, you will see the size of each VxWorks code segment
as it loads.
Once the system is completely loaded, the boot ROMs display the entry
address and transfer control to the loaded VxWorks system.
When VxWorks has completed its initialization it displays a banner page
followed by the prompt ``->''.
Congratulations, VxWorks is up.

.N 2 "Alternative Booting Procedures"
.LP
There are several alternatives in the VxWorks boot procedure described above.
.IP (1)
Instead of being prompted for each of the boot parameters,
you can supply
the boot ROMs with all the parameters on a single command line
of the following form:
.DS
.Ci "$ex(0,0)host:/usr/vw/config/<target>/vxWorks e=90.0.0.50 h=90.0.0.1 u=fred"
.DE
See the description of the routine
.Mo bootStringToParams
for a complete description of the format.
This method can be useful if you have programmable function keys.
Program a function key with a command line appropriate to your configuration.
The order of the assigned fields (the fields containing ``='' signs) is not
important.
Assigned fields which are irrelevant should be omitted.
.IP (2)
As noted previously, if your CPU has non-volatile RAM,
all the values you enter in the booting parameters will be retained in
the non-volatile RAM.
In this case, you can let the boot ROMs auto-boot
without even having a terminal connected to the target system.
.IP (3)
You can burn your boot ROMs with the correct boot
parameter values.
With this method, you will no longer need to alter the
boot parameters when VxWorks attempts to boot.
The default boot parameters are specified in the file
.Mo config.h
in the configuration directory for your target CPU
.Mo \f1(\fPvw/config/<target>/config.h ).
This file contains a \fI#define\fP of DEFAULT_BOOT_LINE.
The value of
DEFAULT_BOOT_LINE can be changed to the appropriate boot parameters for
your system.
After editing
.Mo config.h ,
type the following in the configuration directory for your target:
.DS
.Ci "% make bootrom.hex"
.DE
The file
.Mo bootrom.hex
contains the boot ROMs in standard Motorola S-Record
format and is ready to download to an EPROM programmer.
For the sake of thoroughness, you should also type ``make'' so that
any other files affected by your changes will be remade.

.N 2 "Rebooting"
.LP
When VxWorks is running, there are several way you can reboot VxWorks.
.IP \\(bu
Hit the reset button on the target system.
.IP \\(bu
Type a CONTROL-X at the target console terminal.
.IP \\(bu
Invoke \fIreboot\fP from the VxWorks shell.  This can be done even
when remotely logged in to VxWorks.

.LP
When VxWorks is rebooted in any of these ways, the auto-boot sequence
begins again from the countdown.

.N 2 "Reconfiguring and Rebuilding VxWorks"
.LP
The VxWorks image that is supplied on the distribution tape should work
with all standard configurations of supported targets.
You may find that you want to reconfigure the distributed VxWorks
to change a parameter or to include or exclude optional modules.
In particular, you may want to configure and enable NFS, which is
disabled in the supplied configuration.
.LP
Many VxWorks parameters are specified in the configuration
headers
.Mo vw/config/all/configAll.h
and
.Mo vw/config/<target>/config.h .
You can modify these headers to suit your configuration.
Then change to the
.Mo vw/config/<target>
directory and type:
.DS
.Ci "% make"
.DE
This will rebuild the system image
.Mo VxWorks
and the system symbol table
.Mo VxWorks.sym .
.LP
Reconfiguration of VxWorks is discussed in detail in the
.Ch CROSS-DEVELOPMENT
chapter.

.N 1 "PLAYING WITH VxWORKS AND A DEMO PROGRAM"
.LP
This section will give you an introduction to program development and
debugging using VxWorks.
The instructions in this section describe how to use the shell to
load and run a very simple program on the VxWorks system you just booted.

.N 2 "The VxWorks Shell"
.LP
When VxWorks comes up, you will be talking to the VxWorks shell.
The VxWorks shell is an interactive C-expression interpreter.
The shell reads lines of input from the terminal, parses and
evaluates each line, and writes the result of the evaluation to an output
stream.
The shell accepts the same expression syntax as the C compiler with a
few variations.
This simple mechanism can be used in many different ways.
.LP
The sections below provide a brief introduction to using the VxWorks shell.
A more complete description of the shell can be found in the
.Ch SHELL
chapter.

.N 3 "Special Characters"
.LP
As you type in commands to the shell, you can use the following special
characters (\fB^\fP means \s-1CTRL\s0):
.LP
.DS
.IP \fB^H\fP
(backspace) Delete a character.
.IP \fB^U\fP
Delete an entire line.
.IP \fB^S\fP
Temporarily suspend output.
.IP \fB^Q\fP
Resume output.
.IP \fB^C\fP
Abort the shell.
.IP \fB^X\fP
Trap to the boot ROMs.
.DE
.LP
VxWorks routines in
.Mo tyLib
allow these special characters to be changed.
See the
.Ch SHELL
chapter for more information.

.N 3 "Examples of Shell Usage"
.LP
The following examples illustrate some typical uses of the shell.
(Note: the shell prompts for interactive input begin with the symbol
``->'' and this prompt is shown before each command typed by the user in the
examples below.
The shell's responses are set in italics for clarity.)
.DS
.Ci "-> 68"
.Co "value = 68 = 0x44 = 'D'"

.Ci "-> x = 13"
.Co
new symbol "x" added to symbol table
x address = ...:  value = 13
.R

.Ci
-> printf ("hello world, x = %d\en", x)
.Co
hello world, x = 13
value = ...
.R
.DE

.N 3 "Shell History and Line Editing"
.LP
The VxWorks shell keeps a list of the commands that were typed in previously.
To see this list, type the ``history'' command:
.DS
.Ci "-> h"
.DE
A list of the last 20 shell commands is typed on the screen.
.LP
The VxWorks shell has line editing capabilities that allow you to recall
lines from the shell history, edit them, and re-execute them.
Typing the \s-2ESC\s+2 key changes the shell from input mode to editing mode.
In editing mode, many
.Sy vi
compatible commands are available, including
.Sy h ,
.Sy j ,
.Sy k ,
.Sy l ,
.Sy cw ,
.Sy x ,
and so on.
For example, the
.Sy k
command recalls successive previous commands from the history list,
and the
.Sy j
command moves you forward in the history list.
The
.Sy h
and
.Sy l
commands moves the cursor left and right on the command line.
A \s-2RETURN\s+2 sends the entire command to the shell regardless of
cursor position or input mode.
.LP
The shell history and
.Sy vi
editing facilities are described in detail in the
.Ch SHELL
chapter.

.N 3 "Remote Access to the Shell"
.LP
In addition to accessing the VxWorks shell on the target console terminal,
you can also access the shell from a terminal or workstation on your UNIX host
using the remote login facility
.Sy rlogin .
In our example, you would type:
.DS
.Ci "rlogin phobos"
.DE
on your UNIX terminal or workstation, to login into the VxWorks target system.
The
.Sy telnet
remote login protocol is also available.
See the
.Ch SHELL
chapter for more information.

.N 2 "On-Line Help"
.LP
VxWorks provides several on-line ``help'' commands.
The following help
commands will be available if the corresponding sub-system has been
included in your VxWorks system configuration.
.DS
.Ci
-> help
-> dbgHelp
-> timexHelp
-> spyHelp
-> netHelp
-> nfsHelp
.R
.DE
These commands print brief summaries of various VxWorks subsystems.
These help commands are not intended to be tutorial,
but rather are convenient memory joggers for some commonly used VxWorks
functions.

.N 2 "A Demo Program"
.LP
In order to illustrate some basic VxWorks concepts and techniques, this
section describes loading and debugging a demo program called
.Sy demo .
The
.Sy demo
program prints its own task id,
task name, and startup parameter on the console, and then exits.
Additional demo programs are provided in the
.Mo vw/demo
directory.
.LP
In this example, the following assumptions are made:
.RS .5i
.sp
\(bu The VxWorks tape was loaded into
.Mo /usr/vw .
.br
\(bu Your home directory is
.Mo /usr/fred .
.br
\(bu You are playing with the demo program in a directory called
.Mo /usr/fred/vwdemo .
.br
\(bu The host machine's name is ``mars''.
.RE
.sp
To start, make a working directory somewhere on the host system \z(
.Mo /usr/fred/vwdemo
for this example) and copy
.Mo /usr/vw/demo/1/demo.c
into it:
.DS
.Ci
% cd /usr/fred
% mkdir vwdemo
% cd vwdemo
% cp /usr/vw/demo/1/demo.c demo.c
.R
.DE
Compile the
.Sy demo
program with the following command:
.DS
.Ci "% cc -c -O -I/usr/vw/h demo.c"
.DE
The \fI-c\fP flag suppresses linking with the UNIX C libraries and
leaves the undefined externals unresolved.
These will be resolved by the VxWorks linking loader.
The \fI-O\fP flag optimizes the code (this flag is optional).
The \fI-I\fP flag tells the compiler where to find the VxWorks header
files which are included in
.Mo demo.c .
.LP
If VxWorks is not booted yet, now is the time to do it.
Access VxWorks either by its system console or by remote login with
.Sy rlogin .
.LP
Next check the user name that the VxWorks system will use on the remote
host system with the
.Sy whoami
command:
.DS
.Ci "-> whoami"
.DE
The user name is used primarily for access privileges.
When VxWorks first comes up, the user name will be set to the user
name specified in the boot parameters.
You should change to your own user name, if it is not already, with the
.Sy iam
command:
.DS
.Ci
-> iam "fred"
.R
.DE
.LP
Next set your current working directory with the
.Sy cd
command:
.DS
.Ci
-> cd "mars:/usr/fred/vwdemo"
.R
.DE
(where ``mars'' is the name of the host system as specified in the boot
parameters).
This sets the default directory to be the directory where you previously
compiled
.Sy demo .
.LP
Now you can load your program into memory on the VxWorks system with the
.Sy ld
command:
.DS
.Ci
-> ld < demo.o
.Co
value = 0 ...
.R
.DE
When
.Sy demo
is loaded, all of its undefined externals are resolved by the VxWorks linking
loader.
You can see this by disassembling the
.Sy demo
routine.  Type:
.DS
.Ci
-> l demo
-> l
-> l
.R
.DE
The
.Sy l
command
(lower case `L') shows a symbolic disassembly of the code in the
.Mo demo.c
program.
The assembler code shows addresses symbolically.
Any code in the system can be disassembled. (Try ``l printf'', for example.)
.LP
Try the following commands:
.DS
.ta 3i
.Ci
-> demo 1234			[1]
-> sp demo, 1234			[2]
-> taskSpawn "demo", 50, 0, 2000, demo, 1234			[3]
.R
.ta
.DE
Each of these will run the
.Sy demo
program, but in a different way.  [1] will run demo as a
subroutine in the shell's context.
It will tell you that its task name is ``shellTask'',
[2] will spawn
.Sy demo
as a separate task, and assign it some default numbers for a task
name and a priority.  [3] will spawn
.Sy demo
also, but with an explicit task name ``demo'', priority (50),
and stack size (2000).
.LP
Now try:
.DS
.ta 3i
.Ci
-> i			[1]
-> period 5, demo, 5			[2]
-> i			[3]
.R
.ta
.DE
The first
.Sy i
command [1] shows the tasks that are currently running.
The tasks that you see (the
.Sy shell ,
.Sy logTask ,
.Sy excTask ,
.Sy netTask ,
and
.Sy rlogind )
are system tasks that are normally present.
The second command [2] spawns a new task, called
.Sy periodRun ,
that calls
.Sy demo
in its context every 5 seconds.
.Sy Demo
should now be printing its message every five seconds.
The second
.Sy i
command [3] again shows all the tasks that are running.
Notice the new
.Sy periodRun
task.
.LP
You can insert a breakpoint with the
.Sy b
command:
.DS
.Ci
-> b printf
.R
.DE
This sets a breakpoint at address
.Sy printf .
The
.Sy periodRun
task should hit it within 5 seconds.
When it does, a message will
print out telling you about it.  Now type:
.DS
.ta 3i
.Ci
-> i			[1]
-> tt			[2]
.R
.ta
.DE
The information that [1] prints now shows that
.Sy periodRun
is suspended (because it hit a breakpoint). 
The task trace [2] shows where the task was when it hit the breakpoint.
You can see what routines called what routines, with what parameters.
.LP
To continue, type:
.DS
.ta 3i
.Ci
-> bdall		[1]
-> c		[2]
.R
.ta
.DE
[1] deletes the breakpoint (actually, it deletes all breakpoints)
and [2] continues the task.
If the breakpoint had not been deleted,
the task would have hit it again in 5 seconds.
Now type:
.DS
.ta 3i
.Ci
-> period 7, demo, 7		[1]
-> i		[2]
-> sp demo, 1111		[3]
.R
.ta
.DE
When you type [1], you spawn yet another task, also called
.Sy periodRun
(in fact it is the same code in memory) which will call
.Sy demo
every 7 seconds.
The information display [2] will show you
another task, with a different ID but the same name.
Since
.Sy demo
is being called from the context of a different task, the 7-second
cycle will tell you a different ID than the 5-second cycle which is
still running.
In fact, when you spawn
.Sy demo
as a task yet again [3],
it will tell you still another ID, even though it is the same code in
memory.
Remember, there is only one copy of the code for
.Sy demo
in memory, but it is being executed in three different task contexts.
To delete the periodic
.Sy periodRun
tasks, type:
.DS
.Ci
-> td <name or ID>
-> td <name or ID>
.R
.DE
where <name or ID> is either the name of the task as a string,
the name of the task as a numeric value, or the task ID,
which you can find by typing ``i''.
Thus a task whose name is ``7'' and whose ID is 0x5a89e can be deleted by
any of the following:
.DS
.Ci
-> td 7
-> td "7"
-> td 0x5a89e
.R
.DE
This way of refering to tasks applies to all the routines in
.Mo usrLib
and
.Mo dbgLib ,
which are oriented to interactive use.
It does not apply to lower-level VxWorks tasking functions,
which require the task ID.

.N 1 "TROUBLESHOOTING"
.LP
If you encountered problems booting or exercising VxWorks,
there are many possible causes.
This section discusses the most common sources of error and
how to narrow the possibilities.
Please read the section \fBThings To Check\fP
before contacting Wind River Systems Technical Support.
Very often, by simply rechecking the installation
steps, your hardware configuration, and so forth, you can locate the problem.
.N 2 "Technical Support & Bug Reports"
.LP
If you have questions about VxWorks or
you find a bug in VxWorks, you can reach Wind River's Technical Support
by either by phone (1-800-545-WIND) or sending electronic mail over USENET to
.Mo sun!wrs!vwbug
with the
.Sy vwbug
script provided in
.Mo vw/bin .
.N 2 "Things to Check"
.LP
Most often, a problem with running VxWorks can be traced to hardware
or software configuration errors.
Use the following checklist to locate
a problem:
.N 3 "Hardware Configuration"
.LP
.IP "\\(bu \fB Limit the number of variables.\fP"
.br
Start with a minimal configuration of
a single CPU board and an Ethernet board.
.sp .5
.IP "\\(bu \\fB Make sure that your backplane is properly powered and bussed.\fP"
.br
For the VMEbus backplane, most configurations require that the P2 B-Row
be bussed and that there is power supplied to both the P1 and P2.
.sp .5
.IP "\\(bu \\fB Be sure boards are in adjacent slots,\fP"
.br
unless the backplane is jumpered
to propagate the BUS GRANT and INT ACK daisy chains.
.sp .5
.IP "\\(bu \\fB Check that the RS-232 cables are correctly constructed.\fP"
.br
In most cases, the documentation that accompanies the hardware explains the
requirements for that hardware.
.sp .5
.IP "\\(bu \\fB Check the boot ROMs for correct insertion,\fP"
.br
if the CPU board seems completely dead
when applying power
(some have front panel LEDs).
You may also validate the checksum provided on the labels of the
boot ROMs.
.sp .5
.IP "\\(bu \\fB Press the \s-2RESET\s0 button if required.\fP"
.br
Some system controller boards do not reset the backplane on power-on,
requiring you to reset manually.
.sp .5
.IP "\\(bu \\fB Check that the CPU and Ethernet boards are properly jumpered.\fP"
.br
Refer to the section on the
.Sy jump
program earlier in this chapter.
.N 3 "Booting Problems"
.LP
.IP "\\(bu \\fB Check the Ethernet transceiver site.\fP"
.br
For example, connect a known working
system to the transceiver and check whether the network functions.
.sp
.IP "\\(bu \\fB Verify Internet addresses.\fP"
.br
An Internet address consists of a network number and a host number.
There are several different classes of Internet addresses that assign
different parts of the 32-bit Internet address to these two parts, but
in all cases the network number is the most significant bits and the
host number is least significant bits.
The simple configuration described in this chapter assumes that the
host and target are on the same network, i.e. have the same network number.
(See the
.Ch NETWORK
chapter for a discussion of setting up
.Sy gateways
if the host and target are not on the same network.)
If the target Internet address is not on the same net as the host, the
VxWorks boot ROMs will say:
.DS
.Co "Error loading file: status = 0x33."
.DE
.Co 0x33
corresponds to host errno 51 (decimal) ENETUNREACH.
.IP
If the target Internet address is not in
.Mo /etc/hosts,
then the host doesn't know about your target.
The VxWorks boot ROMs
will receive an error message from the host:
.DS
.Co "host name for your address unknown"
.br
.Co "Error loading file: status = 0x320001."
.DE
.Co 0x32
is the VxWorks module number for hostLib 50 (decimal).
\fI1\fP corresponds to S_hostLib_UNKNOWN_HOST.
.IP
Note that these error values correspond to VxWorks version 4.0 and later.
.in -3
.sp
.IP "\\(bu \\fB Verify host file permissions.\fP"
.br
The target name \fImust\fP be in either
.Mo <user-home-directory>/.rhosts
or
.Mo /etc/hosts.equiv
(target user name can be any user on the host).
Note that the user name ``root'' is special: having the target name in
.Mo /etc/hosts.equiv
is not sufficient for root access; the target name
\fImust\fP appear in
.Mo /.rhosts
for root access.
.sp
Make sure that the user name you are using on the target
has access to the host files.
To verify that the user name you've chosen does indeed have permission to
read the
.Mo vxWorks
file, try logging in on the host with the target user name and accessing
the file (for instance, with the UNIX
.Sy size
command).
This is essentially what the target does when it boots.
.IP
If you have trouble with access permissions,
you might try using the
.Sy ftp
(File Transfer Protocol) instead of relying on
.Sy rsh
(remote shell).
Normally, if no password is specified in the boot parameters,
the VxWorks object module will be loaded using the
.Sy rsh
service.
However, if a password is specified, then
.Sy ftp
will be used.
Sometimes
.Sy ftp
is easier because you specify the password explicitly,
instead of relying on the configuration files on the host.
Also some non-UNIX systems do not support
.Sy rsh ,
in which case you must use
.Sy ftp .
.sp
.IP "\\(bu \fB Helpful Troubleshooting Tools.\fP"
.br
In tracking down configuration problems, the following
UNIX tools may be helpful:
.sp .5
.in +3
.IP "\fIifconfig <interface>\fP"
.Sy ifconfig
will report the configuration of the specified interface (e.g.
.Sy ie0
or
.Sy le0
on a Sun system).
It should report that the interface is configured for the appropriate
Internet address and that the interface is up.
.IP "\fIarp -a\fP"
.br
.Sy arp
displays the "address resolution protocol" tables that map Internet
addresses to Ethernet addresses.
Your target machine will be listed if at least one packet got through
from your target to your host.
.IP "\fI/usr/etc/etherfind\fP"
.Sy etherfind
can be used on Sun systems to watch all traffic on a network.
.IP "\fInetstat -r\fP"
.Sy netstat
will give various network status reports.
The
.Sy -r
option will display the network routing tables.
This is useful when gateways are being used to access the target.
.in -3
.N 1 "VxWORKS DIRECTORIES AND FILES"
.LP
The following is a description of the various directories and files for VxWorks.
.IP \fBbin\fP
.br
Directory containing the executable binaries of the VxWorks tools
that run on the host.
In order to facilitate use of these tools, you may want to add
.Mo /usr/vw/bin
to your ``path'' in your shell environment.
.IP \fBh\fP
.br
Directory containing all the header (include) files supplied by
VxWorks.
Your applications modules will need to include several of them in order to
access VxWorks facilities.
This is discussed in detail in a section below.
The \fIh\fP directory contains two subdirectories \(em \f3net\fP and \f3rpc\fP.
.RS .5i
.IP \fBh/net\fP
.br
Directory containing all the internal header (include) files used by the
the VxWorks network.
Network drivers will need to include several of these headers,
but no application modules should need them.
.IP \fBh/rpc\fP
.br
Directory containing header files which must be included by applications
using the Remote Procedure Call library.
.RE
.IP \fBlib\fP
.br
Directory containing all the machine independent object libraries and
modules provided by VxWorks.
The directory contains five subdirectories \(em
\fB68000\fP, \fB68010\fP, \fB68020\fP, \fBhost\fP, and \fBlint\fP.
For each target CPU type the following files are included:
.RS .5i
.IP \fBlib/host\fP
.br
Directory containing one library used for VxWorks' host tools.
.IP \fBlib/lint\fP
.br
Directory containing lint libraries (*.ln).
.IP \fBlib/680x0/vxWorks.a\fP
.br
An archive
.To (ar )
format library which contains all the object modules that make up the basic
VxWorks operating system.
.IP \fBlib/680x0/vxConfig.a\fP
.br
An
.To ar
format library which contains all the object modules whose sources are in the
.Mo config/all
directory.
These are the VxWorks drivers and several user-configurable modules.
.IP \fBlib/680x0/vxFort.a\fP
.br
An
.To ar
format library which contains all the object modules that make up the basic
VxWorks operating system suitable for calling from Fortran programs.
.IP \fBlib/680x0/network.a\fP
.br
An
.To ar
format library which contains all the object modules that comprise the
VxWorks network subsystem.
.IP \fBlib/680x0/rpclib.a\fP
.br
An
.To ar
format library which contains all the object modules for the Remote
Procedure Call library.
.IP \fBlib/680x0/{wind.a,\ psos.a,\ vrtx.a}\fP
.br
An
.To ar
format library which contains all the object modules for the VxWorks,
pSOS, or VRTX kernel interfaces, respectively.
.RE
.IP \fBconfig\fP
.br
Directory containing all the files used to configure and build particular
VxWorks systems.
It includes source to all VxWorks I/O drivers, system-dependent modules,
and some user-alterable modules.
These files are organized into several sub-directories: the sub-directory
\fBall\fP, which contains modules common to all implementations
of VxWorks (system \fIindependent\fP modules), and a sub-directory for each
port of VxWorks to specific target hardware (system \fIdependent\fP modules).
.RS .5
.IP \fBconfig/all\fP
.br
Sub-directory contains all \fIsystem-independent\fP VxWorks
I/O drivers and system configuration modules.
The object modules from the sources in this directory are collected
in the
.To ar
format library
.Mo lib/vxConfig.a .
This directory includes the following files:
.RS .5i
.IP "\fBusrConfig.c\fP and \fBbootConfig.c\fP"
.br
Source of the configuration module for a VxWorks development system
.Mo \f1(\fPusrConfig.c ),
and a configuration module for the VxWorks boot ROM
.Mo \f1(\fPbootConfig.c ).
configuration files can be tailored per the instructions
in the chapter
.Mo CROSS-DEVELOPMENT.
.IP \fBusrLib.c\fP
.br
Library of routines designed for interactive invocation,
which can be modified or extended if desired.
.IP \fBstatTbl.c\fP
.br
Source of the error status table.
It contains a symbol table of the
names and values of all error status codes in VxWorks.
This table is used
by the routine \fIprintError(2)\fP, translating error status codes into
meaningful messages.
.IP \fB*Drv.c\fP
.br
VxWorks I/O drivers for selected controller boards.
.IP \fBconfigAll.h\fP
Generic header file used in the target directories.
.RE
.IP \fBconfig/<target>\fP
The other sub-directories of the \fBconfig\fP directory contain the
\fIsystem-dependent\fP modules for each port of VxWorks to particular target
hardware.
Each of these directories includes the following files:
.RS .5i
.IP "\fBsysLib.c\fP and \fBsysALib.s\fP"
.br
Two source modules of system-dependent routines.
.IP "\fBtyCoDrv.c\fP"
.br
A driver for on-board serial ports.
.IP "\fBconfig.h\fP"
Header file of hardware configuration parameters.
.IP \fBvxWorks\fP\ and\ \fBvxWorks.sym\fP.
.br
Complete, linked VxWorks system binary \z(
.Mo vxWorks ),
and its symbol table \z(
.Mo vxWorks.sym )
created with the supplied configuration files.
.IP \fBbootrom\fP
.br
Object module containing the VxWorks boot ROM code.
.IP \fBbootrom.hex\fP
.br
ASCII file containing the VxWorks boot ROM code in Motorola S-record format,
suitable for downloading over a serial connection to a prom programmer.
.IP \fBromInit.s\fP
.br
Assembly language source for initialization code that is the entry point
for ROM-based versions of VxWorks (also used in the VxWorks boot ROMs).
.RE
.RE
.IP \fBdemo\fP
.br
This directory contains sample application modules for demonstration purposes,
including both the source and the compiled object modules ready to
be loaded into
.Mo vxWorks .
.RS .5i
.IP \fBdemo/1\fP
.br
Directory containing a simple introductory demo program as well as
a server/client socket demonstration.
.IP \fBdemo/dg\fP
.br
Directory containing a simple datagram facility, useful for demonstrating
and testing datagrams on VxWorks and/or other TCP/IP systems.
.IP \fBdemo/sprites\fP
.br
Directory containing a SUN RPC demonstration.
The programs use a
``suntools'' window, so they can only be run in combination with a SUN monitor.
However, the code demonstrates general programming with RPC on any system.
.RE .5i
.IP \fBman\fP
.br
Directory containing the formatted text for the VxWorks manual
including manual entries for each of VxWorks' libraries and routines.
.IP \fBmansrc\fP
.br
Directory containing the
.To nroff/troff
sources for each of the files in the
.Mo man
directory.
.IP \fBpub/rpc3.9\fP
.br
Directory containing Public Domain SUN source code for the RPC version 3.9.
.IP \fBmisc\fP
.br
Directory containing miscellaneous support files including
.Mo Makefile
templates and documentation macros.
.LP
.IP \fBsrc\fP
.br
Directory containing all source files for VxWorks.
If you have a VxWorks source
license, you will have the following additional directories. 
.RS .5i
.IP \fBsrc/all\fP
.br
Directory containing the source files for all of the basic VxWorks
operating system modules.
The object modules of these modules are
collected in the
.Mo lib/680x0/vxWorks.a
libraries.
.IP \fBsrc/net\fP
.br
Directory containing the source files for all the VxWorks network modules.
The object files of these modules are collected in the
.Mo lib/680x0/network.a
library.
.IP \fBsrc/rpc\fP
.br
Directory containing the source code for RPC
which has been modified to run under VxWorks.
.IP \fBsrc/bin\fP
.br
Directory containing the source files for all
the tools in the \fBbin\fP directory.
.IP \fBsrc/fortran\fP
.br
Directory containing source code for the VxWorks/Fortran interface library.
The object files of these modules are in the
.Mo lib/680x0/vxFort.a
library.
.IP \fBsrc/{wind,\ psos,\ vrtx}\fP
.br
Directories containing source code for the VxWorks, pSOS, or VRTX
kernel interfaces respectively.
The object files of these modules are in the
.Mo lib/680x0/{wind.a,\ psos.a,\ vrtx.a}
libraries, respectively.
.RE
.TO
