.WP "Network" VxWorks 4.00
.TL
VxWORKS NETWORK
.N 1 "INTRODUCTION"
.LP
The VxWorks network is the link that connects VxWorks systems with UNIX systems
and other VxWorks systems.
It is fully compatible with the UNIX BSD 4.2/4.3 network facilities.
This document gives an overview of the VxWorks network components,
and the procedures necessary to configure the network.

.N 1 "NETWORK COMPONENTS"
.LP
The hierarchy of VxWorks network components is shown in Figure 1.
At the lowest level, VxWorks typically uses Ethernet as the basic
transmission medium,
although it can also use shared memory on a common backplane
in more closely coupled environments.
On top of the transmission media, VxWorks uses the
Internet protocols TCP/IP and UDP/IP to transport data between processes
running under either VxWorks or UNIX.
.KF
.sp 8.8i
.ce
\fBFigure 1.  VxWorks Network Components\fP
.KE
.LP
Using Internet protocols, VxWorks makes several types of network facilities
available to the user:
.sp .5
.IP "\\(bu  \fBSockets\fP"
Allow communications between tasks, running either under VxWorks or UNIX.
.sp .5
.IP "\\(bu  \fBRemote Procedure Calls\fP"
Allow a task on one machine to invoke procedures which actually run
on other machines.
Both the calling task and the called procedure may run under either VxWorks
or UNIX.
.sp .5
.IP "\\(bu  \fBRemote Command Execution\fP"
Allows VxWorks tasks to invoke shell commands on a UNIX system, via the
network.
.sp .5
.IP "\\(bu  \fBRemote File Access\fP"
Allows VxWorks tasks to access UNIX files remotely, via the
Network File System (NFS),
UNIX remote shell
.Sy (rsh) ,
or the Internet File Transfer Protocol
.Sy (ftp) .
.sp .5
.IP "\\(bu  \fBRemote Login\fP"
Allows remote access to the VxWorks from a UNIX system,
and remote access to a UNIX shell from a VxWorks system.

.N 2 "Ethernet"
.LP
Ethernet is just one available medium over which the VxWorks network operates.
Ethernet is a 10 MBit/Sec network that is
standardized and well supported by UNIX and numerous vendors.
It is ideal for most VxWorks applications,
but there is nothing that is inherently tied to Ethernet in either the
VxWorks or UNIX network systems.

.N 2 "Backplane Network"
.LP
The VxWorks network can also be used for communication among multiple
processors on a common backplane.
In this case, data is passed via shared memory.
This is implemented in the form of a standard network driver so that
all the higher levels of network components are fully functional
over this ``backplane network''.
Thus, all the high-level network facilities provided over Ethernet are also
available over the backplane.
.LP
The backplane network allows multiple VxWorks CPUs to communicate with each other
over a backplane.
In addition, it allows VxWorks CPUs to be plugged directly into the backplane
of some UNIX systems and to communicate with a UNIX CPU using the same
shared memory scheme.
In this configuration, all VxWorks-to-UNIX network facilities
normally available over Ethernet are also available over the backplane.
This involves a special UNIX version of the VxWorks backplane network driver
that must be configured into the UNIX system.

.N 2 "TCP/IP Internet Protocols and Addresses"
.N 3 "Protocols"
.LP
On top of the raw Ethernet and backplane transmission mechanisms,
VxWorks uses the Internet protocol family (often referred to as TCP/IP)
to effect process-to-process communication across the network.
There are three main protocols involved:
.sp .5
.IP "\\(bu  \fBInternet Protocol (IP)\fP"
The base network protocol of the Internet protocol family.
With IP, each ``host''
(i.e. computer) in the network has a unique four-byte Internet address
(described below).
IP accepts messages addressed to a particular host and tries to deliver them.
If multiple networks are connected, IP keeps track of the
interconnections and will route messages from network to network if necessary.
Thus, IP sends messages from a host on one network to a host on another network.
IP will also fragment and re-assemble messages that are too long for any
particular network.
However, IP makes no guarantees that messages will be delivered correctly
or even delivered at all.
Although it is possible to access IP directly, almost all applications
will use one of the higher-level protocols, UDP or TCP.
.sp .5
.IP "\\(bu  \fBUser Datagram Protocol (UDP)\fP"
Provides a simple ``datagram''
based process-to-process communication mechanism.
UDP extends the message address to include a ``port address''
in addition to the host Internet address, where a port address
identifies one of several distinct destinations within a single host.
Thus UDP accepts messages addressed to a particular port on a particular
host, and tries to deliver them, using IP to transport the messages
between the hosts.
Like IP, UDP makes no guarantees that messages will be delivered correctly
or even delivered at all.
.sp .5
.IP "\\(bu  \fBTransmission Control Protocol (TCP)\fP"
Provides reliable, flow-controlled, two-way, process-to-process
transmission of data.
TCP is a ``connection'' based communication mechanism.
This means that before data can be exchanged via TCP,
the two communicating processes
must first establish a connection via a distinct connection phase.
Data is then sent and received as a byte stream at both ends.
Like UDP, TCP extends the connection address to include a ``port address''
in addition to the host Internet address.
That is, a connection is established between a particular port in one host and
a particular port in another host.
TCP
.I guarantees
correct delivery of all data sent, or will announce the failure and
terminate the connection.
.sp .5
.LP
The VxWorks network also fully supports the associated
Internet Control Message Protocol (ICMP) and
the Ethernet Address Resolution Protocol (ARP),
as implemented in UNIX BSD 4.3.
However, these protocols are used internally and are not generally
accessible by the user.

.N 3 "Internet Addresses"
.LP
Each machine in an Internet network has a unique Internet address.
An Internet address is 32 bits long, and begins with a network number,
followed by the local address or host number.
There are three formats or classes of Internet addresses,
which accommodate the different addressing schemes
used in the following situations:  (1) a small number of networks
each with a large number of hosts,
(2) a moderate number of networks each with a moderate number of hosts,
and (3) a large number of networks each with a small number of hosts.
The three classes are distinguished by their high-order bits.
.sp .5
.TS
box center ;
cp12f3  s     s     s     s
cf3   | cf3 | cf3 | cf3 | cf3
c     | c   | n   | n   | n   .
.sp .25
Internet Address Classes
.sp .25
_
.sp .25
Class	High Order Bits	Network Number	Host Number	Example
.sp .25
=
.sp .25
A	0	7 bits	24 bits	90.1.2.3
B	10	14 bits	16 bits	128.0.1.2
C	110	21 bits	8 bits	192.0.0.1
.sp .25
.TE
.sp .5
Externally, Internet addresses are usually represented as a character string
in dot (``.'') notation.
Dot notation lists the 32-bit number as a string of four 8-bit values
separated by dots.
Internally, the Internet address is often kept as a simple 32-bit value
(e.g. as an
.Sy int ,
.Sy long ,
.Sy u_long ,
.Sy "struct in_addr" ,
etc.).
For example, the Internet address 0x5a010203 is
``90.1.2.3'' in standard dot notation.
.LP
VxWorks includes routines for manipulating Internet addresses.
For instance, there are routines for converting between dot notation and
integer notation, routines for extracting network and host portions of
an address, and routines for creating a new address from a network and
host number.
See the manual entry for
.Mo inetLib (1).

.N 2 "Sockets"
.LP
In VxWorks, just as in many UNIX systems,
the direct user interface to the Internet protocols is via ``sockets''.
A socket is an end point for communications which gets ``bound''
to a UDP/TCP port within the host.
.LP
A process can create a datagram socket (UDP)
and bind it to a particular port number.
Other processes, on any host in the network, can then send messages
to that socket by specifying the host Internet address and the port number.
.LP
Similarly, a process can create a stream socket (TCP)
and bind it to a particular port number.
Another process, on any host in the network, can then create another
stream socket and request that it be connected to the first socket
by specifying its host Internet address and port number.
Once the two TCP sockets have been thus connected, there is a ``virtual
circuit'' set up between them allowing error-free socket-to-socket
communications.
.LP
Note that socket communications between processes are exactly the same
regardless of their location in the network.
Processes can communicate within a single CPU, across a backplane,
across an Ethernet, or across any connected combination of networks,
with no apparent distinction at all, other than performance.
Socket communications can connect VxWorks processes and UNIX processes
in any combination.

.N 2 "Remote Procedure Calls"
.LP
Remote Procedure Call (RPC) is a facility which allows a process on
one machine to call a procedure which is executed by another process
on another machine.
Thus with RPC, a VxWorks task or UNIX process can invoke routines that
are executed on other VxWorks or UNIX machines, in any combination.
.LP
Internally, RPC uses sockets as the underlying communication mechanism.
RPC, in turn, is used in the implementation of several higher-level
facilities, including the Network File System (NFS) and remote source-level
debugging.
.LP
RPC was originally designed by SUN Microsystems and is now in the public domain.
See the public domain RPC documentation and the manual entry for
.Mo rpcLib(1)
for more information.

.N 2 "Remote Command Execution:  \fIrsh\fP"
.LP
The VxWorks remote command execution facilities allow programs running
on VxWorks to invoke UNIX commands and have the results
(on \fIstandard out\fP and \fIstandard error\fP)
returned via socket connections.
This is accomplished using the UNIX ``remote shell'' protocol,
which is serviced by the ``remote shell daemon''
.Sy rshd
on UNIX.
See the manual entry on
.Mo remLib (1).

.N 2 "File Transfer Protocol:  \fIftp\fP"
.LP
VxWorks includes a library of routines, in
.Mo ftpLib ,
that implements the ``client'' side for the Internet
File Transfer Protocol.
Using these routines, VxWorks tasks can transfer files to and from
.Sy ftp
servers on the network and invoke other
.Sy ftp
functions.
Although these routines are available directly to VxWorks applications,
their main use is providing one form of transparent remote file access
described below.

.N 2 "Remote File Access"
.LP
The VxWorks network provides transparent remote access of UNIX files.
Programs running under VxWorks can access files on any UNIX system,
via the network, exactly as if they were local to the VxWorks system.
For example,
.Mo ``/dk/file''
might be a file local to the VxWorks system, while
.Mo ``/host/file''
might be a file located on another machine entirely.
To programs running under VxWorks, the files operate in exactly the same way;
only the name is different.
.LP
Remote file access can be provided using
any of three different protocols:\ \ UNIX remote shell
.Sy (rsh) ,
the Internet File Transfer Protocol
.Sy (ftp) ,
or the Network File System (NFS).

.N 3 "Remote File Access Using \fIrsh\fP and \fIftp\fP"
.LP
VxWorks provides an I/O driver called
.Sy netDrv
that uses either
.Sy rsh
or
.Sy ftp ,
described above, to provide transparent access to remote files.
A separate VxWorks I/O device is created for each host for which remote file
access is desired.
When a file on one of these devices is accessed,
.Sy netDrv
uses one of the underlying protocols to transfer the file to or from VxWorks.
This happens transparently, of course, without intervention from the application
which simply performs normal VxWorks I/O.

.N 3 "Remote File Access Using \fINFS\fP"
.LP
A newer and more efficient remote file access mechanism is provided by
the Network File System (NFS) protocol.
NFS is a specification for a distributed file system
developed by SUN Microsystems.
VxWorks provides an I/O driver called
.Sy nfsDrv
that acts as an NFS ``client'' to access files on any NFS server on the network.
VxWorks' NFS has been tested with approximately 70 different
implementations of NFS servers on various operating systems.

.N 2 "Remote Login with \fIrlogin\fP and \fItelnet\fP"
.LP
The VxWorks
.To rlogin
facilities allow remote access to the VxWorks shell by users on UNIX systems,
and remote access to UNIX shells by users on VxWorks systems.
Using the UNIX
.To rlogin
function, you can access the VxWorks target system's shell from a UNIX
terminal or workstation.  In fact, with a window-based UNIX workstation,
you can access many VxWorks target systems at the same time, each
in a separate window on the workstation.
.LP
VxWorks also allows remote access to the VxWorks shell via
.To telnet .
From the host computer, this works very similarly to
.To rlogin .
However, VxWorks
.To telnet
does not currently support
.To telnet
access from the VxWorks system to the host.

.N 1 "CONFIGURING THE NETWORK"
.LP
Before the VxWorks network can be used,
both the UNIX and VxWorks systems must be configured properly.
There are two main concerns in configuring the network:  establishing
system names and addresses, and establishing appropriate access permissions
for each system.
.LP
On UNIX, most of the configuration consists of setting up various network
``database'' files and the system start-up files.
In VxWorks, most of the configuration information necessary for
access to a single host is contained in the boot line.
Further initialization can be added to
.Mo usrConfig.c ,
or handled by application code, or done interactively from the shell.
.LP
The network configuration procedures for VxWorks and the host are
summarized in Table 1, and discussed in the sections below.

.N 2 "Associating Internet Addresses with Network Interfaces"
.LP
A system's physical connection to a network is called a ``network interface''.
Each network interface must be assigned a unique Internet address.
Note that since a system may be connected to several networks,
or may even have several connections to the same network,
a system may have several network interfaces.
.LP
On a UNIX system,
the Internet address of a network interface is specified using the
.To ifconfig
command:
.DS
ifconfig ex0 90.0.0.1
.DE
This is usually done in the UNIX start-up file
.Mo /etc/rc.local .
For more information,
see the UNIX manual entry for
.To ifconfig .
.LP
In VxWorks, the Internet address of a network interface is specified by calling
the routine
.Sy ifAddrSet :
.DS
ifAddrSet ("ex0", "90.0.0.2");
.DE
See the VxWorks manual entry for
.Mo ifLib .
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically sets the address of the interface that was used to boot VxWorks
to the Internet address specified in the VxWorks boot parameters.

.N 2 "Associating Internet Addresses with Host Names"
.LP
The underlying Internet protocol addresses systems with 32-bit
Internet addresses.
People, however, prefer to refer to systems with names that are more
meaningful to them.
Thus both UNIX and VxWorks maintain a mapping between system
names and Internet addresses.
.LP
On a UNIX system, the file
.Mo /etc/hosts
contains the mapping between system names and Internet addresses.
Each line consists of an
Internet address and the name(s) of the computer at that address:
.DS
90.0.0.2	vw1
.DE
There must be a line in this file for each UNIX system and for each
VxWorks system in the network.
For more information on
.Mo /etc/hosts ,
see the UNIX manual entry
.Ch hosts(5) .
.LP
In VxWorks, calls to the routine
.Sy hostAdd
are used to associate system names with Internet addresses.
One call to
.Sy hostAdd
should be made for each system the VxWorks system will communicate with:
.DS
hostAdd ("host", "90.0.0.1");
.DE
To associate more than one name with an Internet address,
.Sy hostAdd
may be called several times with different host names and the same
Internet address.
The VxWorks routine
.Sy hostShow
displays the current system name and Internet address associations.
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically adds the name of the host VxWorks was booted from,
using the host name specified in the VxWorks boot parameters.
.KF
.na
.vs 10
.TS
box;
cBp12      s             s
cBp10    | cBp10       | cBp10
lp8w(1i) | lp8w(2.25i) | lp8w(2.25i) .
.sp .5
Network Procedures
.sp .5
_
.sp .5
Function	On UNIX	On VxWorks
.sp .5
=
.sp .5
T{
Associate Internet addresses with network interfaces.
T}	T{
Use \fIifconfig\fP in \fB/etc/rc.local\fP:
.nf
    ifconfig ex0 90.0.0.1s
or:
    ifconfig ex0 host
.fi
T}	T{
Call \fIifAddrSet\fP:
.nf
    ifAddrSet ("ex0", "90.0.0.2");
.fi
T}
.sp .5
_
.sp .25
T{
Associate Internet addresses with system names.
T}	T{
Add address-name pairs to \fB/etc/hosts\fP:
.nf
    90.0.0.1    host
    90.0.0.2    vw1 sonny
.fi
T}	T{
Call \fIhostAdd\fP:
.nf
    hostAdd ("host", "90.0.0.1");
    hostAdd ("vw1", "90.0.0.2");
    hostAdd ("sonny", "90.0.0.2");
.fi
T}
.sp .5
_
.sp .25
T{
Examine host names.
T}	T{
Look at \fB/etc/hosts\fP.
T}	T{
Call \fIhostShow\fP.
T}
.sp .75
=
.sp .5
T{
Transparent remote file access via \fIrsh\fP.
T}	T{
Add remote system names to \fB/etc/hosts.equiv\fP
or \fB/<user-home-dir>/.rhosts\fP:
.nf
    vw1
    vw2
.fi
T}	T{
Create network devices to remote systems using \fIrsh\fP:
.nf
    netDevCreate ("host:", "host", 0);
Set user name \fIiam\fP:
.nf
    iam ("fred", 0);
.fi
Access file with created device name:
.nf
    copy < host:/usr/fred/myfile
.fi
T}
.sp .5
_
.sp .25
T{
Transparent remote file access via \fIftp\fP.
T}	T{
No action necessary.
T}	T{
Create network devices to remote systems using \fIftp\fP:
.nf
    netDevCreate ("host:", "host", 1);
.fi
Set user name and password with \fIiam\fP:
.nf
    iam ("fred", "flintstone");
.fi
Access file with created device name:
.nf
    copy < host:/usr/fred/myfile
.fi
T}
.sp .5
_
.sp .25
T{
Transparent remote file access via \fINFS\fP.
T}	T{
Add the names of mountable file systems and a list of groups
that have access to them in \fB/etc/exports\fP.
T}	T{
Create NFS device:
.nf
    nfsMount ("host", "/usr", "/hostUsr");
.fi
Set NFS authorization with \fInfsAuthUnixSet\fP or \fInfsAuthUnixPrompt\fP:
.nf
    nfsAuthUnixSet ("host", <uid>, <gid>, 0);
.fi
Access files with mounted name:
.nf
    copy < /hostUsr/fred/myfile
.fi
T}
.sp .75
=
.sp .5
T{
Remote login from UNIX to VxWorks via \fIrlogin\fP.
T}	T{
Use \fIrlogin\fP:
.nf
    % rlogin vw
.fi
T}	T{
Initialize \fIrlogin\fP:
.nf
    rlogInit ();
.fi
T}
.sp .5
_
.sp .25
T{
Remote login from UNIX to VxWorks via \fItelnet\fP.
T}	T{
Use \fItelnet\fP:
.nf
    % telnet vw
.fi
T}	T{
Initialize \fItelnet\fP:
.nf
    telnetInit ();
.fi
T}
.sp .5
_
.sp .25
T{
Remote login from VxWorks to UNIX via \fIrlogin\fP.
T}	T{
Add remote system names to \fB/etc/hosts.equiv\fP
or \fB/<user-home-dir>/.rhosts\fP:
.nf
    vw1
.fi
T}	T{
Set user name with \fIiam\fP:
.nf
    iam ("fred");
.fi
Use \fIrlogin\fP:
.nf
    rlogin "host"
.fi
T}
.sp .75
=
.sp .5
T{
Adding gateways to a network.
T}	T{
Add gateway to \fB/etc/gateways\fP and restart \fIrouted\fP:
.nf
    net 91.0.0.0 gateway 90.0.0.3 metric 1 passive
.fi
or use \fIroute\fP:
.nf
    % route add 91.0.0.0 90.0.0.3 1
.fi
T}	T{
Call \fIrouteAdd\fP:
.nf
    routeAdd ("90.0.0.0", "vw3")
    routeAdd ("90.0.0.0", "91.0.0.3")
.fi
T}
.sp .5
_
.sp .25
T{
Examine routing tables.
T}	T{
Use \fInetstat\fP:
.nf
    % netstat -r
.fi
T}	T{
Call \fIrouteShow\fP.
T}
.sp .5
_
.TE
.vs 12
.ce 1
.B "- Table 1 -"
.sp 1
.KE

.N 2 "Transparent Remote File Access"
.LP
``Transparent remote file access'' allows files on remote systems to be
accessed just as if they were local.
An application program sees no distinction between local and remote files.
VxWorks can use any of three different underlying protocols to provide
transparent remote file access:
UNIX remote shell
.Sy (rsh) ,
the Internet File Transfer Protocol
.Sy (ftp) ,
or the Network File System (NFS).
.LP
The VxWorks I/O driver
.Sy netDrv
implements remote file access using either of the first two protocols,
.Sy rsh
or
.Sy ftp .
The
.Sy netDrv
driver uses these protocols to read the entire remote file into local memory
when the file is opened
and to write the file back when it is closed if it was modified.
.LP
The VxWorks I/O driver
.Sy nfsDrv
implements remote file access using NFS.
This protocol transfers only the data actually read or written to the file
and so is considerably more efficient, both in terms of memory utilization
and throughput.
However, it is somewhat more cumbersome to set up initially than
the other protocols.

.N 3 "Transparent Remote File Access via \fIrsh\fP and \fIftp\fP"
.LP
The VxWorks I/O driver
.Sy netDrv
implements remote file access using either
.Sy rsh
or
.Sy ftp .
Using
.Sy rsh ,
.Sy netDrv
remotely executes the UNIX
.Sy cat
command to copy the entire requested file to and from the target.
Using
.Sy ftp ,
.Sy netDrv
uses the
.Sy RETR
and
.Sy STOR
commands to ``retrieve'' and ``store'' the entire requested file.

.N 4 "Allowing Remote File Access via \fIrsh\fP on UNIX"
.LP
An
.Sy rsh
request includes the name of the requesting user.
The request is treated just like a remote login by that user.
UNIX restricts such remote logins via the file
.Mo .rhosts
in users' home directories, and more globally with the file
.Mo /etc/hosts.equiv .
The
.Mo .rhosts
file contains a list of system names
(as defined in the
.Mo /etc/hosts
file)
that have access to that user's login.
Therefore, you should have a
.Mo .rhosts
file in your home directory
listing the VxWorks systems, each on a separate line,
that are allowed to access files remotely using your user name.
.LP
The
.Mo /etc/hosts.equiv
file provides a less selective mechanism.
Systems listed in
this file
are allowed login access to
.I any
user defined on the local system (except the super-user
.I root ).
Thus, adding VxWorks system names to
.Mo /etc/hosts.equiv
will allow those VxWorks systems to
access files using any user name on the UNIX system.
.LP
The
.Sy ftp
protocol, unlike
.Sy rsh ,
specifies both the user name and password on every request.
Therefore,
when using
.Sy ftp ,
the UNIX system does not use
.Mo .rhosts
or
.Mo /etc/hosts.equiv
to authorize remote access.

.N 4 "Creating VxWorks Network Devices That Use \fIrsh\fP or \fIftp\fP"
.LP
In order to access files across the network via
.Sy rsh
or
.Sy ftp ,
a network device must be created for each
remote system whose files will be accessed.
The routine
.Sy netDevCreate
is used to create
a VxWorks I/O device for a particular remote host system:
.DS
netDevCreate ("<device-name>", "<host>", <protocol>);
.DE
.B <device-name>
is the name of the device to be created.
.B <host>
is either an Internet address in dot notation or the name of the remote system
as specified in a previous call to
.Sy hostAdd .
It is traditional to make the device name be the host name followed by a colon.
.B <protocol>
is 0 for
.Sy rsh
or 1 for
.Sy ftp .
.LP
For example, the call:
.DS
netDevCreate ("gecko:", "gecko", 0);
.DE
creates a new I/O device on VxWorks called ``gecko:'', which accesses
files on the host system ``gecko'' using
.Sy rsh .
.LP
Once a network device has been created, files on that host can be
accessed by appending the host path name to the device name.
For example, the filename
.Mo gecko:/usr/fred/myfile
refers to the file
.Mo /usr/fred/myfile
on the ``gecko'' system.
This file can be read and/or written exactly like a local file.
For example, the VxWorks shell command:
.DS
-> copy < gecko:/usr/fred/myfile
.DE
would copy that file to the screen.
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically creates a network device for the host name specified
in the VxWorks boot parameters.
If no
.Sy ftp
password was specified in the boot parameters, the network device will be
specified with the
.Sy rsh
protocol.
If a password was specified,
.Sy ftp
will be used.

.N 4 "Setting the User ID for Remote File Access via \fIrsh\fP or \fIftp\fP"
.LP
All
.Sy ftp
and
.Sy rsh
requests to a remote system include the name of the user.
All
.Sy ftp
requests include a password as well as a user name.
From VxWorks you can specify the user name and password for
remote requests by calling the routine
.Sy iam :
.DS
iam ("<username>", "<password>");
.DE
The first argument to
.Sy iam
is the user name which will be used when you access remote systems.
The second argument is the
.Sy ftp
password.
This is ignored if using
.Sy rsh ,
and can be specified as
.Sy NULL
or 0.
.LP
For example, the call:
.DS
iam ("fred", "flintstone");
.DE
tells VxWorks that all accesses to remote systems via either
.Sy rsh
or
.Sy ftp
will be through user ``fred'',
and if
.Sy ftp
is used, the password will be ``flintstone''.
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
initially sets the user name and password to those specified in the
boot parameters.

.N 4 "File Permissions"
.LP
In order for a VxWorks system to have access to a particular file on a
host, permissions on the host system must be set up so that the
user name VxWorks is using has permission
to read that file (and write it, if necessary).
This means that it must have permission
to access all directories in the path,
as well as the file itself.
.LP
The easiest way to check this is to log in to the host with the user name
VxWorks will be using, and try to read or write the file in question.
If you can't do it, neither can the VxWorks system.

.N 3 "Transparent Remote File Access via \fINFS\fP
.LP
The VxWorks I/O driver
.Sy nfsDrv
implements remote file access using NFS.
Using this driver, VxWorks can access files on any host with an NFS server.
.LP
\fBNOTE:\fP VxWorks is delivered with NFS disabled.
To enable NFS, modify the VxWorks configuration header
.Mo /usr/vw/config/all/configAll.h
to include a definition of the symbol
.Sy INCLUDE_NFS .
Also modify the default NFS parameters
.Sy NFS_USER_ID
and
.Sy NFS_GROUP_ID
(explained below) in the same file.
Then re-make VxWorks by changing directory to
.Mo /usr/vw/config/<target>
and typing:
.DS
make vxWorks
.DE

.N 4 "Allowing Remote File Access via \fINFS\fP on UNIX"
.LP
In order to access files, NFS clients
.I mount
file systems from NFS servers.
On a UNIX NFS server, the file
.Mo /etc/exports
specifies which of the server's file systems
can be mounted by NFS clients.
For example, if this file contained the line:
.DS
/usr
.DE
then the file system
.Mo /usr
could be mounted by NFS clients such as VxWorks.
If a file system is not listed in this file, then it cannot be mounted by
other machines.
Other optional fields in
.Mo /etc/exports
allow the exporting of a file system to be restricted to
certain machines or users.

.N 4 "Creating VxWorks Network Devices That Use \fINFS\fP"
.LP
In VxWorks, a remote file system is NFS mounted and an I/O device created for
it by calling the routine
.Sy nfsMount :
.DS
nfsMount ("<host>", "<remote-file-system>", "<local-name>");
.DE
For example, the call:
.DS
nfsMount ("gecko", "/usr", "/geckoUsr");
.DE
mounts the file system
.Mo /usr
from the NFS server machine named ``gecko''.
The host name ``gecko'' must have already been added to VxWorks' list
of hosts using the routine
.Sy hostAdd .
VxWorks then creates the local I/O device
.Mo /geckoUsr/
that refers to the mounted file system.
A reference on VxWorks to a file with the name
.Mo /geckoUsr/fred/myfile
refers to the file
.Mo /usr/fred/myfile
on the host machine ``gecko'' as if it were local to the VxWorks system.
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically tries to mount the file system VxWorks was booted from,
as long as NFS is included in the VxWorks configuration
and the VxWorks boot file
begins with a "/".
For example, if NFS is included and you boot
.Mo /usr/vw/config/<target>/vxWorks ,
then VxWorks will attempt to mount
.Mo /usr
from the boot host via NFS.

.N 4 "Setting the User ID for Remote File Access via \fINFS\fP"
.LP
When making an NFS request to a host system, the NFS server expects
more in-depth information about the user than just the user's name.
NFS is built on top of Remote Procedure Call (RPC) and uses a type of RPC
authentication known as AUTH_UNIX.
This authentication mechanism requires the user ID and a list of
group IDs that user belongs to.
.LP
These parameters can be set on VxWorks using the routine
.Sy nfsAuthUnixSet:
.DS
nfsAuthUnixSet ("gecko", 1000, 200, 0);
.DE
This would set the NFS authentication to user ID 1000 with the single
group ID 200.
The routine
.Sy nfsAuthUnixPrompt
provides a more interactive way of setting the NFS authentication parameters.
.LP
On UNIX systems, a user ID is specified in the
.Mo /etc/passwd
file.
A list of groups that a user belongs to is specified in the
.Mo /etc/group
file.
.LP
A default user ID and group ID is specified in the VxWorks configuration
header
.Mo /usr/vw/config/all/configAll.h
by defining the values of
.Sy NFS_USER_ID
and
.Sy NFS_GROUP_ID
respectively.
The NFS authorization parameters will be set to these values at system
start-up.

.N 2 "Remote Login from UNIX to VxWorks:  \fIrlogin\fP and \fItelnet\fP"
.LP
You can log in to a VxWorks shell from a UNIX terminal or workstation
using either
.Sy rlogin
or
.Sy telnet .
These facilities are initialized on VxWorks by the routines
.Sy rlogInit
and
.Sy telnetInit ,
respectively.
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically initializes either
.Sy rlogin
or
.Sy telnet .
If no password is specified in the boot parameters,
then
.Sy rlogin
will automatically be initialized.
If a password is specified in the boot parameters,
then
.Sy telnet
will automatically be initialized.

.N 2 "Remote Login from VxWorks to UNIX"
.LP
You can login to a UNIX shell from a VxWorks terminal using
.Sy rlogin .
To do this,
access permission must be granted to the VxWorks system by entering
its system name either in the
.Mo .rhosts
file (in the user home directory) or in the
.Mo /etc/hosts.equiv
file.
See the section above on
``Allowing Remote File Access via \fIrsh\fP on UNIX.''

.N 2 "Adding Gateways To A Network"
.LP
The Internet protocols allow hosts on different but connected networks
to communicate.
If a machine on one network sends a packet to a machine on another network,
then a
.I gateway
is sought that can forward the message from the sender's network to
the destination's network.
If a system has interfaces to more than one network, then it can be a
.I gateway
between those networks.
One of the primary functions of IP (the lower-level protocol of TCP/IP)
is to perform this routing and forwarding among interconnected networks.
.LP
Many systems, including most UNIX systems, have a routing daemon
.To \f1(\fProuted )
which exchanges routing information with other systems to determine
network connectivity.
VxWorks, however, has no routing daemon,
and must instead be told explicitly about any gateways it may need.
Similarly, if VxWorks systems are gateways, the UNIX systems must
be told about them explicitly, since the VxWorks systems will not
broadcast their routing information.

.N 3 "Adding a Route on UNIX"
.LP
A UNIX system can be told explicitly about a gateway
in one of two ways:  by editing
.Mo /etc/gateways
or using the
.Sy route
command.
.LP
When the UNIX route daemon
.Sy routed
is started
(usually at boot time),
it reads a static routing configuration from
.Mo /etc/gateways .
Each line in
.Mo /etc/gateways
specifies a network gateway in the following format:
.DS
.sp
net <destination-address> gateway <gateway-address> metric <n> passive
.sp
.DE
where
.B <n>
is the ``hopcount'' from the host machine to the destination network
(i.e. the number of gateways between the host and the destination
network).
.LP
For example, consider a system on network 90.
The following line in
.Mo /etc/gateways
describes a gateway between networks 90 and 91,
with an Internet address 90.0.0.3 on network 90;
a hopcount of 1 specifies that the gateway is a direct connection
between the two networks:
.DS
.sp
net 91.0.0.0 gateway 90.0.0.3 metric 1 passive
.sp
.DE
.LP
After editing
.Mo /etc/gateways ,
you must kill the route daemon and restart it,
since it only reads
.Mo /etc/gateways
when it starts, and will otherwise be unaware of subsequent changes
to the file.
.LP
Alternatively, you can use the
.Sy route
command to add routing information explicitly:
.DS
route add <destination-network> <gateway-address> <metric>
.DE
For example, the command:
.DS
route add 91.0.0.0 90.0.0.3 1
.DE
will configure the gateway as in the above example with the
.Mo /etc/gateways
file.
Note, however, that routes added with this ``manual'' method
will be lost next time the system is rebooted.

.N 3 "Adding a Route on VxWorks"
.LP
To add gateways to the VxWorks network routing tables,
use the
.Sy routeAdd
routine.
.DS
routeAdd ("<destination-address>", "<gateway-address>")
.DE
Both addresses can be specified by dot notation or by the host names
defined by the routine
.Sy hostAdd .
.LP
For example, consider two VxWorks machines \fIvw2\fP and \fIvw3\fP,
both interfaced to network 91.
Suppose that \fIvw3\fP is a gateway between networks 90 and 91 and that
its Internet address on network 91 is 91.0.0.3.
The following calls can then be made on \fIvw2\fP to establish
\fIvw3\fP as a gateway to network 90:
.DS
routeAdd ("90.0.0.0", "vw3");
.ti 0
or
routeAdd ("90.0.0.0", "91.0.0.3");
.DE
Other routing routines are available in the routing library
.Mo routeLib .
.LP
The VxWorks network start-up routine,
.Sy usrNetInit
in
.Mo usrConfig.c ,
automatically adds the gateway specified in the
the boot parameters (if any) to the routing tables.
In this case, the address specified in the gateway field (``g = '')
is added as the gateway to the network of the boot host.

.N 2 "Broadcast Addresses"
.LP
Many physical networks support the notion of ``broadcasting'' a packet
to all hosts on the network.
A special Internet ``broadcast address'' is interpreted by the network
sub-system to mean ``all systems'' when specified as the destination address
of a datagram message (UDP).
An example of this can be found in the demo program
.Mo /usr/vw/demo/dg/dgTest.c .
.LP
Unfortunately there is some ambiguity about what address is to be interpreted
as the broadcast address.
The Internet specification now states that the
broadcast address is an Internet address with a host part of all
.UL ones .
However, some older systems use an Internet address with a host part of all
.UL zeros
as the broadcast address.
.LP
Most newer systems, including VxWorks, will
.I accept
either address on incoming packets as being a broadcast packet.
But when an application wants to
.I send
a broadcast packet, it must use the correct broadcast address for its system.
.LP
VxWorks normally uses a host part of all ones as the broadcast address.
Thus a datagram sent to Internet address ``90.255.255.255'' (0x5affffff)
would be broadcast to all systems on network 90.
However, to allow compatibility with other systems, VxWorks allows
the broadcast address to be reassigned for each network interface
by calling the routine
.Sy ifBroadcastSet .
Similarly, most UNIX systems have a
.Sy broadcast
option to the
.Sy ifconfig
command that allows the broadcast address for an interface to be reassigned.
See the VxWorks manual entry for
.Sy ifBroadcastSet
and the UNIX manual entry for
.Sy ifconfig
for more information.

.N 2 "Using Subnets"
.LP
An Internet address consists of a
network address portion and a host address portion.
As described previously, there are different classes of
Internet addresses in which different parts of the 32-bit address
are assigned to each portion.
This provides a great deal of flexibility in network addressing.
Even so, in some environments network addresses are a scarce resource \(em
an organization may be limited to certain number of network addresses
by a higher authority.
.LP
To allow a single network address to be subdivided into
multiple sub-networks, a technique called ``subnet addressing'' is used.
This technique involves extending the network portion of the addresses used
on a particular set of physical networks.
The interpretation of the Internet address is altered to include more
bits in the network portion and fewer in host portion.
.LP
The specification of which bits are to be interpreted as network address
is called the ``net mask''.  A net mask is a 32-bit value with
.I ones
in all bit positions that are to be interpreted as the network portion.
In VxWorks, the net mask can be specified for a particular network
interface with the routine
.Sy ifMaskSet .
See the manual entry for
.Sy ifMaskSet
for more information.
.LP
It may be necessary to specify a net mask during booting, in order to
correctly access the host from which you are booting.
This can be done by appending ``:<mask>'' to the Internet address specifications
for the Ethernet and/or backplane interfaces in the boot parameters,
where ``<mask>'' is the desired net mask in hexadecimal.
For example, when entering boot parameters interactively:
.DS
inet on ethernet (e):   90.0.0.1:ffffff00
inet on backplane (b):  90.0.1.1:ffffff00
.DE
or when specifying the boot parameters in a boot string:
.DS
e=90.0.0.1:ffffff00 b=90.0.1.1:ffffff00
.DE

.N 1 "NETWORK INITIALIZATION ON START-UP"
.LP
Most of the information that VxWorks needs to set up its network and
access its boot host is taken from the boot parameters you supply
to the VxWorks Boot ROMs via the bootline or the boot menu commands.
This section summarizes the network configuration
performed automatically by VxWorks,
based on these parameters.
Most of this configuration is done by the routine
.Sy usrNetInit
in the configuration module
.Mo /usr/vw/config/all/usrConfig.c .
See the
.Ch CROSS-DEVELOPMENT
chapter for more information on
.Sy usrConfig .
.LP
VxWorks start-up procedures
configure the network based on the following boot parameters:

.IP "\\(bu \fBBoot Device\fP"
The network device to boot from,
e.g. ``ex'' for Excelan Ethernet controller.
This device will be attached and configured automatically with
the correct Internet address.

.IP "\\(bu \fBHost Name\fP"
The name of the host to boot from.
This need not
be the same name used internally by that system.
VxWorks will add the host name to the host table and create a device by
that name.

.IP "\\(bu \fBHost Inet\fP"
The Internet address of the host to boot from.

.IP "\\(bu \fBInet on Ethernet\fP"
The Internet address of this target on the Ethernet, if any.
If the target has no Ethernet controller (perhaps because it boots
from a backplane network through a gateway) this field should be blank.
A subnet mask may also be specified as described previously.

.IP "\\(bu \fBInet on Backplane\fP"
The Internet address of this target on the ``backplane network''.
This field can be blank if no backplane network is required.
Again, a subnet mask may be specified as described previously.

.IP "\\(bu \fBGateway Inet\fP"
The Internet address of the gateway to boot through, if the host
is not on the same network as the target.

.IP "\\(bu \fBBoot File\fP"
The full path name of the VxWorks object module to be booted.

.IP "\\(bu \fBProcessor Number\fP"
The backplane processor number of the target CPU.
The first CPU must be processor number 0.

.LP
The following network elements are configured from the above parameters:

.IP "\\(bu \fBEthernet Interface\fP"
.br
If ``Inet On Ethernet'' is specified, the Ethernet interface is attached;
the Internet address
and the optional net mask are set
.Sy (ifAddrSet
and
.Sy ifMaskSet ).

.IP "\\(bu \fBBackplane Interface\fP"
.br
If  ``Inet on Backplane'' is specified, the backplane interface is attached;
the Internet address
and the optional net mask are set
.Sy (ifAddrSet
and
.Sy ifMaskSet ).

.IP "\\(bu \fBLoopback Interface\fP"
.br
The loopback is attached and Internet address set (``127.1'').

.IP "\\(bu \fBHost Names\fP"
.br
Host name entries are added
.Sy (hostAdd )
for the specified boot host and for loopback (``localhost'').

.IP "\\(bu \fBRouting\fP"
.br
If a gateway address is specified, a routing entry is added
indicating that that address is a gateway to the network of the specified
boot host.

.IP "\\(bu \fBRemote File Access Device\fP"
.br
This device is created with the name ``<boothost>:''.
.Sy Rsh
is used if no password was specified,
otherwise
.Sy ftp
is used.

.IP "\\(bu \fBNetwork File System\fP"
.br
If the boot file name begins with a ``/'', a mount of the first directory
in the path is attempted.  For example, if you boot
.Mo /usr/vw/config/<target>/vxWorks ,
VxWorks will attempt to mount
.Mo /usr
via NFS.
The NFS user ID and group ID are initialized to values defined in
.Mo /usr/vw/config/all/configAll.h .

.IP "\\(bu \fBRemote Login\fP"
.br
.Sy Rlogin
is initialized if no password was specified, otherwise
.Sy telnet
is initialized.

.IP "\\(bu \fBUser Name and Password\fP"
.br
These are initialized as specified in the boot parameters.

.IP "\\(bu \fBCurrent Working Directory\fP"
.br
This is set to the remote file access device ``<boothost>:'' or to
the NFS mounted file system if the NFS mount succeeds.

.N 1 "BACKPLANE NETWORKS"
.LP
The VxWorks network subsystem has many layers of protocols.
At the bottom layer are the network interface drivers whose job
is to transmit and receive packets on the network medium.
In addition to supplying drivers for traditional network media such as Ethernet,
VxWorks also supplies a ``backplane'' driver,
.Sy bp ,
which provides communication over a backplane bus.
.LP
The advantage of a backplane driver compatible with the
rest of the network subsystem is that all higher-level protocols
are immediately available over the backplane, just as they are over Ethernet.
Socket communications, remote login, remote file access, NFS, remote procedure
calls, and remote source debugging are all available to and from
.UL any
processor on the backplane, simultaneously.
Use of the network facilities over the backplane is indistinguishable from
use over any other medium.
.LP
A multi-processor backplane bus becomes an Internet network of its own.
Each backplane network has its own network number.
As usual, each processor on the backplane has a unique Internet address.
.LP
The routing capabilities of the VxWorks Internet protocols
allow the processors on the backplane network to reach systems on
other networks via a
.I gateway
processor on the backplane.
The gateway processor has connections to both the backplane network and
an external network, typically an Ethernet network.
This makes all levels of network communications available between any processor
on the backplane and any other host or target system on the external network.
.LP
Finally, the low-level transport mechanism of the backplane driver is
also available directly.  This allows alternative protocols to be run
over the backplane in parallel with the standard ones.
.LP
The VxWorks backplane driver uses the following techniques to
send network packets from one processor on the backplane to another:
.sp .5
.RS
.IP \(bu .15i
Packets are transferred across the backplane via a pool of ``shared memory''
that can be accessed by all processors on the backplane.
.IP \(bu
Access to the shared memory pool is interlocked by use of the test-and-set
instruction.
.IP \(bu
Processors can either poll the shared memory data structures
for input packets periodically
or be notified of input packets by interrupts.
.RE
.sp .5
.LP
The backplane network is configured by constants in the configuration header
.Mo config.h
and by parameters specified to the VxWorks boot ROMs.
The following sections give the details of the backplane network operation
and configuration.

.N 2 "The Backplane Shared Memory Pool"
.LP
The basis of the VxWorks backplane network is the ``shared memory pool''.
This is a contiguous block of memory that must be accessible to all
processors on the backplane.
Typically this memory is either part of one of the processors on-board,
dual-ported memory, or on a separate memory board.

.N 3 "Backplane Processor Numbers"
.LP
The processors on the backplane are each assigned a unique
.I "backplane processor number"
starting with 0.
The assignment of processor numbers is arbitrary, except for processor 0,
which, by convention, is the backplane ``master'', described in the next
section.
.LP
The processor numbers are established when the system is booted
by the boot parameters supplied to the boot ROMs.
These parameters can be burned into the ROM, set in the processor's
non-volatile RAM if it has it, or entered interactively.

.N 3 "The Backplane Master \(em Processor 0"
.LP
One of the processors on the backplane is the
.I "backplane master" .
The backplane master has the following responsibilities:
.sp .5
.RS
.IP \(bu .15i
Initializing the shared memory pool and the backplane \fIanchor\fP.
.IP \(bu
Maintaining the backplane \fIheartbeat\fP.
.IP \(bu
Functioning (usually) as the gateway to the external (Ethernet) network.
.IP \(bu
Allocating the shared memory pool itself from its
dual-ported memory, in some configurations.
.RE
.sp .5
.LP
No processor can use the backplane network until the master has initialized it.
However, the master processor is
.I not
involved in the actual transmission of packets on the backplane between
other processors.
Once the shared memory pool is initialized,
the processors, including the master, are all peers.
.LP
The configuration module
.Mo usrConfig.c(1)
is set up to establish backplane processor 0 as the master.
The master processor usually boots from the external (Ethernet) network
directly.
The master will have two Internet addresses in the system:
\ its Internet address on the Ethernet and its address on the backplane network.
.LP
The other processors on the backplane boot indirectly via the backplane network,
using the master as the gateway.
They have only an Internet address on the backplane network.
These processors specify the backplane interface, ``bp'', as the
boot device in the boot parameters.

.N 3 "The Backplane Anchor"
.LP
In various configurations, the shared memory pool may be located at
different locations.
In many situations, it is desirable to allocate the shared memory
at run-time, rather than fixing its location at the time the system is built.
.LP
Of course, all processors on the backplane need to be able to locate the
shared memory pool, even when its location is not known at the time the
system is built.
The
.I "backplane anchor"
serves as a common point of reference for all processors.
The anchor is a very small data structure located at a fixed location
at the time the system is built.
This is usually either in low memory of the dual-ported memory of one of the
processors, or at some fixed address on the separate memory board.
.LP
The anchor contains a pointer to the actual shared memory pool.
This is set up by the backplane master when the backplane network is
initialized.
The anchor's ``pointer'' to the shared memory pool is actually a relative
offset from the anchor itself, so the the anchor and pool must be in the
same address space, so that this offset is the same for all processors.
.LP
The backplane anchor address is established in two ways:  either by
parameters in
.Mo config.h ,
or by boot parameters.
For the backplane master, the anchor address is established
in the master's configuration header
.Mo config.h
at the time the system image is built.
The value of the constant
.Sy BP_ANCHOR_ADRS ,
in
.Mo config.h
of the backplane master, should be set to the address of the anchor
.I "as seen by the master" .
.LP
For the other processors on the backplane, a default anchor address
can be established in the same way, by the setting of
.Sy BP_ANCHOR_ADRS
in
.Mo config.h ,
but this would require burning boot ROMs with that configuration since the
other processors must boot from the backplane to begin with.
For this reason,
the anchor address can also be specified in the boot parameters,
if the backplane network is the boot device.
This is done by appending the address to the backplane boot device code ``bp'',
separated by an ``=''.
Thus the following boot parameter:
.DS
boot device:  bp=800000
.DE
establishes the anchor address at 0x800000.
In this case, this should be the address of the anchor
.I "as seen by the processor being booted" .

.N 3 "The Backplane Heartbeat"
.LP
The processors on the backplane must not ``attach'' to the backplane
network until the shared memory pool initialization has been completed.
To let the other processors know when the backplane is ``alive'',
the master maintains a
.I "backplane heartbeat" .
This heartbeat is a value in the second long word of the anchor data
structure that is incremented by the master once per second.
Processors on the backplane determine that the backplane is alive by
watching the heartbeat for a few seconds.

.N 3 "Shared Memory Location"
.LP
As mentioned above, the backplane shared memory can either be located
at a fixed location at the time the system is built,
or be dynamically allocated at run-time.
The location is determined by the value of the constant
.Sy BP_MEM_ADRS
in the header
.Mo config.h .
This constant can be specified as follows:
.sp .5
.RS
.IP \(bu .15i
Specifying ``NONE'' (-1) means that the shared memory pool is to be
dynamically allocated from the master's on-board dual-ported memory.
.IP \(bu	
Specifying an absolute address
that is \fIdifferent\fP from the anchor address
\fIBP_ANCHOR_ADRS\fP means that the shared memory pool starts
at that fixed address.
.IP \(bu
For convenience, specifying the \fIsame\fP absolute address as the
anchor address means the shared memory pool will start immediately
after the anchor data structure, without having to know the size of
that structure.
.RE

.N 3 "Shared Memory Size"
.LP
The size of the shared memory pool is determined by the value of the constant
.Sy BP_MEM_SIZE
in the header file
.Mo config.h .
.LP
The size required for the shared memory pool is dependent on the number of
processors and the expected traffic.
There is less than 2K bytes of overhead for data structures.
After that, the shared memory pool is divided into 2K-byte packets.
Thus, the maximum number of packets that can be outstanding on the
backplane network is (<poolsize> - 2K) / 2K.
A reasonable minimum is 64K.
A configuration with a large number of processors on one backplane
and many simultaneous connections could require 512K bytes.
Having too small a pool will simply slow down communications.

.N 3 "``On-Board'' and ``Off-Board'' Options"
.LP
The
.Mo config.h
files delivered with VxWorks contain a conditional compilation
that make it easy to select a pair of typical configurations.
The constant
.Sy BP_OFF_BOARD
can be defined
.Sy TRUE
to select a typical ``off-board'' shared memory pool, or
.Sy FALSE
to select a typical ``on-board'' shared memory pool.
.LP
The ``off-board'' configuration establishes the backplane anchor and pool
to be located at an absolute address of 0x800000 on a separate memory board
with a size of 512K bytes.
.LP
The ``on-board'' configuration establishes the backplane anchor at a
low address in the master processor's dual-ported memory.
The shared memory pool is configured to be allocated from the master's
own memory (with
.Sy malloc )
at run time.
The size of the pool allocated is set to 64K.
.LP
These configurations are provided as examples and should be changed to
suit the actual configuration.

.N 3 "Test-and-Set to Shared Memory"
.LP
Unless some form of mutual exclusion is provided,
multiple processors simultaneously accessing certain critical data structures
of the shared memory pool
could interfere with each other's access and cause
fatal errors.
The VxWorks backplane network uses the indivisible ``test-and-set''
instruction to obtain exclusive use of a shared memory data structure.
This translates into a ``read-modify-write'' (RMW) cycle on the backplane bus.
.LP
It is very important that the selected shared memory support the
RMW cycle on the bus and guarantee the indivisibility of such cycles.
This is especially problematic if the memory is dual-ported, as the memory
must then also lock out one port during a RMW cycle on the other.
.LP
Some processors do not support RMW indivisibly in hardware, but do
have software hooks to allow this.
For example, some processor boards have a flag that can be set
to prevent the board from releasing the backplane bus,
once it has been acquired, until that flag is cleared.
These techniques can be implemented in the system-dependent library
.Mo sysLib
for the processor, in the routine
.Sy sysTas .
The backplane driver calls this routine to effect the mutual exclusion
on shared memory data structures.

.N 2 "Inter-Processor Interrupts"
.LP
Each processor on the backplane has a single ``input queue'' of packets
sent from other processors to that destination processor.
There are three methods processors use to determine when to examine
its input queue: polling, bus interrupts, and mailbox interrupts.
.LP
When using polling, the processor simply examines its input queue periodically.
When using interrupts, the processor receives an interrupt from the sending
processor when its input queue has packets.
Of course, interrupt-driven communication is much more efficient than
polling.
.LP
Most backplane busses have a limited number of bus-interrupt lines
available on the backplane (e.g. VMEbus has seven).
A processor can use one of these interrupt lines as its input interrupt.
However, each processor must have its own interrupt line.
Furthermore, not all processor boards are capable of generating bus interrupts.
Thus, bus interrupts are difficult to use.
.LP
A much better interrupt mechanism is ``mailbox'' interrupts, also called
``location monitors'' because they monitor the access to specific memory
locations.
A mailbox interrupt is a bus address which, when written to, causes
a specific interrupt on the processor board.
Each board can be set, with hardware jumpers or software registers,
to use a different address for its mailbox interrupt.
.LP
To generate a mailbox interrupt, a processor simply writes to that location.
There is effectively no limit to the number of processors that can use
mailbox interrupts because each processor just takes up a single address
on the bus.
Most modern processor boards include some kind of mailbox interrupt.
.LP
Each processor must tell the other processors what method to use to
notify it when its input queue has packets.
In the shared memory data structures,
each processor enters its
.I "interrupt type"
and up to three parameters about that type.
This information is used by the backplane driver of the other processors
when sending packets to that processor.
.LP
The interrupt type and parameters for each processor are specified in
.Mo config.h
by the constants
.Sy BP_INT_TYPE
and
.Sy BP_INT_ARG<n> .
The possible values of
.Sy BP_INT_TYPE
and the corresponding parameters are defined in the header
.Mo if_bp.h .
They are summarized in the following table:
.sp .5
.TS
center,box;
cp11fB s s s s
afB afB afB afB afB
a a a a a .
.sp .25
Backplane Interrupt Types
.sp .25
_
Type	Arg 1	Arg 2	Arg 3	Meaning
_
.sp .25
BP_INT_NONE	\&-	\&-	\&-	Polling
BP_INT_BUS	level	vector	\&-	Bus interrupt
BP_INT_MAILBOX_1	address space	address	value	1-byte mailbox
BP_INT_MAILBOX_2	address space	address	value	2-byte mailbox
BP_INT_MAILBOX_4	address space	address	value	4-byte mailbox
.sp .25
.TE

.N 2 "Configuring the UNIX Host"
.LP
The UNIX host is configured to support the backplane network
using the procedures outlined earlier in this chapter for
non-backplane networks.
In particular, a backplane network requires:
.sp .5
.RS
.IP \(bu .15i
all backplane host names and addresses entered in
.Mo /etc/hosts ;
.IP \(bu
all backplane host names entered in
.Mo .rhosts
in your home directory or in
.Mo /etc/hosts.equiv ;
.IP \(bu
a gateway entry specifying the master's Internet address
on the Ethernet as the gateway to the backplane network.
.RE

.N 2 "Example Configuration"
.LP
This section pulls the foregoing discussion together in an example
of a simple backplane network.
The configuration consists of a single UNIX host and two target processors
on a single backplane.
In addition to the two processors, the backplane also has a separate
memory board for the shared memory pool, and an Ethernet controller board.
The additional memory board is not essential, but makes for a configuration
that is easier to describe.
.LP
In this configuration, shown in Figure 2,
we have two networks:  the Ethernet and the backplane.
The Ethernet is assigned network number 90 and the backplane
is assigned 91.
.LP
The host is ``mars'' and is assigned the Internet address 90.0.0.1.
.LP
The backplane master is ``phobos'' and functions as the gateway between
the Ethernet and backplane networks.
It therefore has two Internet addresses:  90.0.0.2 on the Ethernet network
and 91.0.0.2 on the backplane network.
.LP
The other backplane processor is ``deimos'' and is assigned the
backplane address 91.0.0.3.
It has no address on the Ethernet because it is not, in fact,
on the Ethernet.
However, it can communicate with ``mars'' via the backplane network, using
``phobos'' as a gateway.
Of course, the use of the gateway is handled by the Internet protocol
and is completely transparent to the user.
.KF
.sp 4.4i
.ce
.B "Figure 2.  Example Backplane Network"
.sp
.KE
.LP
The network address assignments are summarized in the following table:
.sp .5
.TS
center,box;
cfB s s
afB cfB cfB
a c c.
Network Assignments
_
Name	Inet on Ethernet	Inet on Backplane	
_
.sp .25
mars	90.0.0.1	\&-
phobos	90.0.0.2	91.0.0.2
deimos	\&-	91.0.0.3
.sp .25
.TE
.sp .5
.LP
To configure the UNIX system for our example, the
.Mo /etc/hosts
file must contain the Internet address and name of each system.
Note that the backplane master has two entries.
The second entry, ``phobos.bp'', is not really necessary since the
UNIX system will never access that system with that address,
but it is useful to include it in the file.
.sp .5
.TS
center;
cfB s
a a.
/etc/hosts
.sp .25
_
.sp .5
90.0.0.1	mars
90.0.0.2	phobos
91.0.0.2	phobos.bp
91.0.0.3	deimos
.TE
.sp .5
.LP
To allow remote access of the UNIX host from the target systems, the
.Mo .rhosts
file in the users home directory, or the file
.Mo /etc/hosts.equiv ,
must contain their names:
.sp .5
.TS
center;
cfB
a.
\&.rhost \fIor\fP /etc/hosts.equiv
.sp .25
_
.sp .5
phobos
deimos
.TE
.sp .5
.LP
To inform the UNIX system of the existence of the Ethernet-to-backplane
network gateway, the following line should be in the file
.Mo /etc/gateways ,
\fIat the time the route daemon
.\"	.To routed
\fRrouted\fP
is started\fP.
.sp .5
.TS
center;
cfB
afR .
/etc/gateways
.sp .25
_
.sp .5
net 91.0.0.0 gateway 90.0.0.2 metric 1 passive
.TE
.sp .5
.LP
Alternatively, you can add the route manually with the following UNIX command:
.sp .5
.DS
% route add 91.0.0.0 90.0.0.2 1
.DE
.sp .5
.LP
The target systems are configured in part by the parameters in the
configuration header
.Mo config.h
shown in the table below:
.sp .5
.TS
center,box;
cfB s s
afB afB afB
a a aw(2.2i).
Parameters for config.h
_
Parameter	Value	Comment
_
.sp .5
BP_ANCHOR_ADRS	0x800000	Address of anchor as seen by phobos.
.sp .5
BP_MEM_ADRS	0x800000	T{
Address of shared memory pool as seen by phobos.
T}
BP_MEM_SIZE	0x80000	Size in bytes of shared memory pool.
.sp .5
BP_INT_TYPE	BP_INT_MAILBOX_1	Interrupt targets with 1 byte mailbox.
BP_INT_ARG1	VME_AM_SUP_SHORT_IO	Mailbox in short I/O space.
BP_INT_ARG2	(0xc000 | (sysProcNum * 2))	Mailbox at 0xc000 for phobos.
		\h'\w'Mailbox at'u' 0xc002 for deimos.
BP_INT_ARG3	0	Write 0 value to mailbox.
.sp .5
.TE
.sp .5
.LP
The backplane master ``phobos'' would have the following boot parameters:
.TS
center;
l l.
boot device:	enp
host name:	mars
file name:	/usr/vw/config/<target>/vxWorks
inet on ethernet:	90.0.0.2
inet on backplane:	91.0.0.2
host inet:	90.0.0.1
gateway inet:	<blank>
user:	fred
ftp password:	<blank>
processor number:	0
flags:	0
.TE
.LP
The other target ``deimos'' would have the following boot parameters:
.TS
center;
l l.
boot device:	bp=800000
host name:	mars
file name:	/usr/vw/config/<target>/vxWorks
inet on ethernet:	<blank>
inet on backplane:	91.0.0.3
host inet:	90.0.0.1
gateway inet:	91.0.0.2
user:	fred
ftp password:	<blank>
processor number:	1
flags:	0
.TE

.N 2 "Troubleshooting"
.LP
Getting a backplane network configured for the first time can be tricky.
If you have trouble, here are a few troubleshooting procedures you can use.
Take it one step at a time.
.sp .5
.IP \01. .25i
To begin with, just boot a single processor
in the backplane without any additional memory or processor cards.
Omit the ``inet on backplane'' parameter to prevent the processor from
trying to initialize the backplane.
.IP \02.
Now power off and add the memory board, if you are using one.
Power on and boot the system again.
With the VxWorks boot ROM commands for display memory
.Sy \fR(\fPd )
and modify memory
.Sy \fR(\fPm ),
verify that you can access the shared memory
at the address you expect, with the size you expect.
.IP \03.
Next, reboot the system, this time filling in the ``inet on backplane''
boot parameter.  This will cause VxWorks to initialize the backplane.
While booting, you should see the message:
.DS
.Co "Attaching backplane interface bp0 at \fR<anchor-adrs>\fP... done."
.DE
.IP \04.
When VxWorks is up, you can display the state of the backplane network
by typing:
.DS
.Ci "-> bpShow"
.DE
.IP \05.
Now power off and add the second processor board.
Remember that the second processor must \fInot\fP be configured to be
the system controller board.
Power on and stop the second processor from booting by typing any key
to the boot ROM program.
Boot the first processor as you did before.
.IP \06.
If you have trouble booting the first processor with the second processor
plugged in, you have some hardware conflict.  Check that only the
first processor board is the system controller.
Check that there are no conflicts in the position of the various boards'
memory addresses.
.IP \07.
With the
.Sy d
and
.Sy m
boot ROM commands, verify that
you can see the shared memory from the second processor.
This will be either the memory of the separate memory board if you
are using the ``off-board'' configuration, or the dual-ported memory of the
first processor if you are using the ``on-board'' configuration.
.IP \08.
Using the
.Sy d
command on the second processor, look for the backplane anchor.
The anchor begins with the tell-tale value of 0x1234.
Also you should be able to see the backplane heartbeat \(em
the second long word of the anchor, counting once per second.
.IP \09.
When you have found the anchor from the second processor, enter the
boot parameter for the boot device with that address as the anchor
address:
.DS
boot device: bp=800000
.DE
Enter the other boot parameters and try booting the second processor.
.IP 10.
If the second processor does not boot, you can use
.To bpShow
on the first processor to see if the second processor is attaching
correctly to the backplane.  If not, then you have probably
specified the anchor address incorrectly on the second processor.
If the second processor is attached, then the problem is more likely
to be with the gateway or with the UNIX configuration.
.IP 11.
You can use some of the UNIX tools to examine the state of the network
from the UNIX side.  Use
.To arp ,
.To netstat ,
and
.To etherfind
as suggested in the
.Ch "GETTING STARTED"
chapter.
.IP 12.
If all else fails, call Wind River Systems Technical Support.

.TO
