.WP "I/O System" VxWorks 4.00
.TL
VxWORKS I/O SYSTEM
.sp

.N 1 "INTRODUCTION"
.LP
The VxWorks I/O system is designed to present a simple, uniform,
device-independent interface to any kind of device, including:
.sp .5
.RS
.IP \(bu .15i
Character-oriented devices such as terminals or communications lines.
.IP \(bu
Random-access file system devices such as disks.
.IP \(bu
Virtual devices such as inter-task ``pipes'' and ``sockets''.
.IP \(bu
Monitor and control devices such as digital/analog I/O devices.
.IP \(bu
Network devices that give access to remote devices on other computer systems.
.RE
.sp .5
.LP
The user view of the VxWorks I/O system is source-compatible with that of
the UNIX I/O system.
Standard C language libraries for both basic and buffered I/O functions
are provided.
Internally, however, the I/O system has a unique design that makes the VxWorks
I/O system considerably faster and more flexible than the UNIX I/O system,
and most other I/O systems.
These are important attributes in a real-time system.
.LP
This chapter first describes the nature of ``files'' and ``devices'',
and the user view of basic and buffered I/O.
A middle section discusses the details of some specific devices.
Following this is a detailed discussion of the internal structure
of the I/O system.

.N 1 "FILES, DEVICES, AND DRIVERS"
.LP
In VxWorks, as in UNIX, applications access I/O devices by opening
named ``files''.
A ``file'' can refer to one of two things:
.RS
.IP \(bu .15i
An unstructured ``raw''
.UL device
such as a serial communications channel
or an inter-task pipe.
.IP \(bu
A
.UL "logical file"
on a structured, random-access device containing a file system.
.RE
.LP
For instance, consider the following named files:
.DS
/usr/myfile
/pipe/mypipe
/tyCo/0
.DE
The first refers to a file called ``myfile'',
on a disk device ``/usr''.
The second is a named pipe (by convention, pipe names begin with ``/pipe'').
The third refers to a physical serial channel.
However, I/O can be done to or from any of these in the same way.
Within VxWorks, they are all simply called ``files'',
even though they refer to very different physical objects.
.LP
Devices are handled by program modules called ``drivers''.
In general, using the I/O system does not require any further
understanding of the implementation of devices and drivers.
However, it should be noted that the VxWorks I/O system gives drivers
considerable flexibility in the way they handle each specific device.
Drivers strive to follow the conventional user view presented here,
but may differ in the specifics.
See the section below,
.Ch Basic\ Devices\ in\ VxWorks .
.LP
Although all I/O is directed at named files, I/O can be done at two
different levels \(em ``basic I/O'' and ``buffered I/O''.
The two differ in the way data is buffered
and in the types of calls that can be made.
These two levels are discussed in later sections.

.N 2 "File Names and the Default Device"
.LP
A file name is specified as a character string.
An unstructured device is specified simply with the device name.
In the case of file system devices, the device name is followed by a file name.
Thus the name ``/ty0'' might name a particular serial I/O channel,
and the name ``/dk0/file1''
would likely indicate the file ``file1'' on the device ``/dk0/''.
.LP
Specifically, when a file name is specified in an I/O call,
the I/O system searches for a device whose name matches at least an initial
substring of the file name.
The I/O function is then directed at this device.
.LP
If a matching device name cannot be found,
then the I/O function is directed at a
.I "default device" .
This default device can be set by the user to be any device in the system,
including no device at all,
in which case failure to match a device name will just return an error.
.LP
Devices are named when they are added to the I/O system,
usually at system initialization time.
The VxWorks I/O system imposes no restrictions on the names given to devices.
The I/O system does not interpret device or file names in any way,
other than during the search for matching device and file names.
.LP
It is useful to adopt some naming conventions for device names.
Conventions used in the VxWorks system give the file names a UNIX look,
although the semantics are somewhat different.
In general, device names begin with a ``/''.
File system devices also end with a ``/''.
Thus, a file system device will match the entire specified name up to
the file name portion.
(It will match ``/dk0/'' in the example above, leaving ``file1'' as
the file name portion.)
.LP
By convention, NFS-based network devices are
.I mounted
with names that begin with a ``/'' (e.g. ``/usr'').
Non-NFS network devices are named with the remote machine name followed by a
``:'' (e.g. ``host:'').  The remainder of the name following the ``:'' is the
file name in the remote directory on the remote system.

.N 1 "BASIC I/O"
.LP
Basic I/O is the lowest level of I/O in VxWorks.
The basic I/O interface is source compatible with the I/O primitives
in the standard C library.
There are seven basic I/O calls:
.Sy creat ,
.Sy delete ,
.Sy open ,
.Sy close ,
.Sy read ,
.Sy write ,
and
.Sy ioctl .
Respectively, these create and delete files, open and close files,
read and write to previously created or opened files,
and perform special control on files or devices.

.N 2 "File Descriptors"
.LP
At the basic I/O level, files are referred to by a file descriptor, or
.Sy fd .
An
.Sy fd
is a small integer returned by a call to
.Sy open
or
.Sy creat .
The other basic I/O calls take an
.Sy fd
as a parameter, to specify the intended file.
An
.Sy fd
has no meaning discernible to the user.
It is simply a handle for the I/O system.
.LP
When a file is opened, an
.Sy fd
is allocated and returned.
When the file is closed, the
.Sy fd
is deallocated.
There is a finite number of \fIfd\fPs available within the VxWorks system.
This number is specified in the configuration file.
It is important to close \fIfd\fPs that are no longer in use,
so that the system does not run out of them.

.N 2 "Standard Input, Standard Output, and Standard Error"
.LP
Three
.Sy fd s
are reserved and have special meanings:
.DS
0 - standard input
1 - standard output
2 - standard error output
.DE
These
.Sy fd s
are never returned as the result of an
.Sy open
or
.Sy creat
call,
but rather are indirect references that can be redirected to any other open
.Sy fd .
.LP
These standard
.Sy fd s
are used to make tasks and modules independent of their actual I/O assignments.
If a module does its output to standard output (\fIfd\fP = 1), then its
output can be redirected to any file or device, without altering the module.

.N 3 "Global and Task-Specific Redirection"
.LP
VxWorks allows two levels of redirection.
First, there is a global assignment of the three standard
.Sy fd s.
In addition, individual tasks may override the global assignment of these
.Sy fd s
with their own assignments that apply just for that task.
.LP
When VxWorks is initialized, the global assignments of the standard
.Sy fd s
are directed, by default, to the system console.
When tasks are spawned, they initially have no task-specific assignments,
but instead will just use the global assignments.
.LP
The global assignments can be redirected using the routine
.Sy ioGlobalStdSet .
The parameters to
.Sy ioGlobalStdSet
are the global standard
.Sy fd
to be redirected, and the
.Sy fd
to which it should be directed.  For example:
.DS
ioGlobalStdSet (1, fileFd);
.DE
would set global standard output (\fIfd\fP = 1)
to be the open file whose
.Sy fd
is
.Sy fileFd .
All tasks in the system that do not have their own task-specific redirection
would then write standard output to that file.
.LP
The assignments for a specific task can be redirected using the routine
.Sy ioTaskStdSet .
The parameters to
.Sy ioTaskStdSet
are the task id (0 = self) whose assignment is to be redirected, the standard
.Sy fd
to be redirected, and the
.Sy fd
to which it should be directed.  For example, the task:
.DS
ioTaskStdSet (0, 1, fileFd);
.DE
would then write standard output to
.Sy fileFd .
All other tasks are unaffected by this redirection and
subsequent global redirections of standard output do not affect this task.
.LP
The ``<'' and ``>'' operators of the VxWorks shell allow the
the assignments of the global standard input and output to be conveniently
redirected for the duration of a shell command.
See the chapter
.Ch "VxWORKS SHELL"
for more information.

.N 2 "Open and Close"
.LP
Before I/O can be performed to a device,
a file descriptor must be opened to that device by invoking the
.Sy open
routine
(or
.Sy creat
discussed below).
The arguments to
.Sy open
are the file name, discussed above, and the type of access (READ, WRITE, UPDATE,
O_RDONLY, O_WRONLY, or O_RDWR):
.DS
fd = open ("name", flag);
.DE
The
.Sy open
routine, if successful, returns a file descriptor (a small integer).
This
.Sy fd
is then used in subsequent I/O calls to specify that file.
.LP
The
.Sy fd
is a
.UL global
identifier that is
.UL not
task specific.
One task can open a file, and then any other tasks can use the resulting
.Sy fd .
.LP
In general, only pre-existing devices and files can be opened with
.Sy open .
However, for NFS network devices only, files can also be created with
.Sy open
by or'ing
.Sy O_CREAT
with the flag argument.
In this case,
.Sy open
also takes a third parameter which specifies
the UNIX ``mode'' of the file:
.DS
fd = open ("name", O_CREAT | O_RDWR, 0x644);
.DE
.LP
The
.Sy fd
remains valid until the
.Sy close
routine is invoked with that
.Sy fd :
.DS
close (fd);
.DE
At that point, I/O to the file is flushed (i.e. completely written out)
and the
.Sy fd
may not be used by any task.
However, that same
.Sy fd
number may be used again by the I/O system in any subsequent
.Sy open
call.
.LP
When a task exits or is deleted, the files opened by that task are
.UL not
automatically closed,
since file descriptors are not task specific.
Tasks should explicitly close all files when they are no longer needed.
.LP
There is a limit to the number of files that can be open at once.
This number is specified in the call to initialize the I/O system
(see the section below,
.Ch Initializing\ the\ I/O\ System ,
and the chapter
.Ch CROSS-DEVELOPMENT
).

.N 2 "Create and Delete"
.LP
File-oriented devices need to be able to create and delete files as well as
open existing files.
The
.Sy creat
routine directs a file-oriented device
to make a new file on the device and return a file descriptor for it.
The arguments to
.Sy creat
are similar to those of
.Sy open
except that the file name specifies the name of the new file
rather than an existing one:
.DS
fd = creat ("name", flag);
.DE
The
.Sy creat
routine returns an
.Sy fd
identifying the new file.
.LP
The
.Sy delete
routine directs a file-oriented device to delete the named file:
.DS
delete ("name");
.DE
.LP
Files should not be deleted while they are open.
.LP
Calling
.Sy creat
with a non-file-system oriented device name acts exactly like an
.Sy open .
Calling
.Sy delete
with a non-file-system oriented device name has no effect.

.N 2 "Read and Write"
.LP
Once an
.Sy fd
has been obtained by invoking
.Sy open
or
.Sy creat ,
tasks can read bytes from and write bytes to the file with
.Sy read
and
.Sy write
calls.
The arguments to
.Sy read
are the
.Sy fd ,
the address of the buffer to receive the input,
and the maximum number of bytes to read:
.DS
nBytes = read (fd, buffer, maxBytes);
.DE
The
.Sy read
routine waits for input to be available from the specified file,
and returns the number of bytes actually read.
Device drivers may return any number of bytes between one
and the maximum specified in the call.
Thus repeated
.Sy read s
may be necessary to read a specific number of bytes
(see the manual entry for
.Mo fioRead(2) ).
A byte count of zero returned by
.Sy read
indicates an end-of-file, and a value of ERROR (-1) indicates an
unsuccessful read.
.LP
The arguments to
.Sy write
are the
.Sy fd ,
the address of the buffer that contains the data to be output,
and the number of bytes to be output:
.DS
actualBytes = write (fd, buffer, nBytes);
.DE
The
.Sy write
routine ensures that all the specified data is at least queued
for output before returning to the caller,
though the data might not actually have been written to the device
(driver dependent).
The
.Sy write
routine returns the number of bytes written and it is an error
if the number requested is not equal to the number returned.

.N 2 "Ioctl"
.LP
The
.Sy ioctl
routine is an open-ended mechanism for performing any I/O
functions that do not fit the other I/O calls.
Examples include determining how many bytes are currently available for input,
setting device-specific options,
obtaining information about a file system,
and positioning random-access files to specific byte positions.
The arguments to the
.Sy ioctl
routine are the
.Sy fd ,
a number that identifies the specific control function requested,
and an optional function dependent argument:
.DS
result = ioctl (fd, function, arg);
.DE
The descriptions of the specific devices in the section below,
.Ch Basic\ Devices\ in\ VxWorks ,
enumerate the
.Sy ioctl
functions pertaining to each device.
The specific
.Sy ioctl
control codes are in the header file
.Mo ioLib.h .
See Section 3,
.Mo Drivers ,
of the \f2VxWorks Reference Manual\fP
for information on individual device drivers.

.N 1 "BUFFERED I/O (\fIstdio\fP)"
.LP
The VxWorks ``standard I/O library''
.Mo stdioLib(1)
provides a complete buffered I/O package, compatible with the
.Mo stdio
package in UNIX.
The package includes routines for opening buffered files,
getting characters from and putting characters to a file,
formatted input and output, and other utility routines.
.RS
.LP
NOTE:\ \ \fIIn order for a task to use the VxWorks stdio facility,
it must have been spawned with the stdio option bit
.Sy VX_STDIO
set in the task option word.
.R
.RE
.LP
Also note that implementation of the routines
.Sy printf
and
.Sy sscanf ,
normally considered part of the
.Sy stdio
package, is slightly different in VxWorks.
This is discussed in the section below,
.Ch "Other Formatted I/O" .

.N 2 "Using \fIstdio\fP"
.LP
The VxWorks I/O system is very efficient.
Nevertheless, there is some overhead associated with each low-level call to the
I/O system.
First, the I/O system must dispatch from the device-independent user call
(\fIread\fP, \fIwrite\fP, etc.)
to the driver's specific routine for that function.
Then, most drivers invoke some mutual exclusion or queuing mechanism,
such as semaphores, to prevent simultaneous requests by multiple users
from interfering with each other.
.LP
Because the VxWorks primitives are fast, this overhead is quite small.
However, an application that processed a character at a time
from a file would incur that overhead for each character in the file,
if it were to read one character at a time with the basic I/O
.Sy read
function:
.DS
n = read (fd, &ch, 1)
.DE
.LP
To make this sort of I/O more efficient and more flexible, the
.Sy stdio
package implements a buffering scheme in which data is read from and
written to files and devices in large chunks and buffered in a private buffer.
This buffering is transparent to the application, being handled automatically
by the
.Sy stdio
routines and macros.
.LP
To access a file with buffered
.Sy stdio ,
the file is opened with
.Sy fopen
instead of
.Sy open
(almost all
.Sy stdio
calls begin with ``f''):
.DS
fp = fopen ("/usr/foo", O_RDONLY);
.DE
The returned value,
.Sy fp ,
is a handle for the opened file and its associated buffers and pointers.
An
.Sy fp
is actually a pointer to the associated data structure of type
.Sy FILE
(i.e. declared as ``FILE *'').
By contrast, the low-level I/O routines identify a file with a
``file descriptor'' (\fIfd\fP) which is simply a small integer.
In fact, the
.Sy FILE
structure pointed to by
.Sy fp ,
contains the underlying
.Sy fd
of the open file.
.LP
An already open
.Sy fd
can be belatedly associated with a
.Sy FILE
buffer by calling
.Sy fdopen :
.DS
fp = fdopen (fd, O_RDONLY);
.DE
.LP
After a file has been opened with
.Sy fopen ,
data can be read with
.Sy fread ,
or a character at a time with
.Sy getc ,
and can be written with
.Sy fwrite ,
or a character at a time with
.Sy putc .
.LP
The routines and macros to get data into or out of a file are
extremely efficient.
They simply access the buffer via direct pointers that are
bumped as data is read or written by the user.
They pause to call the low-level
.Sy read
or
.Sy write
functions, only when a read buffer is empty or a write buffer is full.
.LP
It is important to note that the
.Sy stdio
buffers and pointers are
.I private
to a particular task.
They are
.I not
interlocked with semaphores or any other mutual exclusion mechanism,
as this would defeat the point of an efficient private buffering scheme.
Therefore:
.RS
.LP
.I
Multiple tasks must \fBnot\fI perform I/O to the same stdio \fRFILE\fI
pointer at the same time.
.R
.RE

.N 2 "\fIstdin\fP, \fIstdout\fP and \fIstderr\fP"
.LP
As discussed in the earlier section
.Ch Basic\ I/O ,
there are three
special file descriptors \(em 0, 1, and 2 \(em which are reserved for
standard input, standard output, and standard error, respectively.
When a task is spawned with the
.Sy VX_STDIO
option bit set, three corresponding stdio
.Sy FILE
buffers are automatically created and associated with those file descriptors:
.Sy stdin ,
.Sy stdout ,
and
.Sy stderr .
These can be used, as in UNIX, to do buffered I/O to the standard file
descriptors.

.N 1 "OTHER FORMATTED I/O"
.N 2 "Special Cases: \fIprintf\fP and \fIsprintf\fP"
.LP
The routine
.Sy printf
is usually considered a part of the
.Sy stdio
package.
Its function is equivalent to invoking
.Sy fprintf
to
.Sy stdout .
However, the VxWorks implementation of
.Sy printf ,
while functionally the same, does not use the
.Sy stdio
package.
Instead, it uses a self-contained, formatted, but un-buffered interface to
the I/O system in the library
.Mo fioLib(1) .
.LP
.Sy printf
is implemented in this way for several reasons.
First, a task does not have to be spawned with the
.Sy VX_STDIO
option to use
.Sy printf .
Also, the entire
.Sy stdio
package, which is optional, may be omitted from a
VxWorks configuration without losing the functionality of
.Sy printf .
Note that an application requiring buffered output to standard output
can still accomplish this explicitly by calling
.Sy fprintf
to
.Sy stdout .
.LP
The routine
.Sy sscanf
is also implemented in
.Mo fioLib
and can be used even if
.Sy stdio
is omitted from VxWorks.
However, this is
.I not
true for
.Sy scanf
which is implemented in the usual way in
.Sy stdio .

.N 2 "Additional Functions: \fIprintErr\fP and \fIfdprintf\fP"
.LP
There are a few additional routines in
.Mo fioLib(1)
that provide formatted but un-buffered output.
The routine
.Sy printErr
is analogous to
.Sy printf
but outputs formatted strings to the standard error
.Sy fd
(2).
The routine
.Sy fdprintf
outputs formatted strings to a specified
.Sy fd .

.N 2 "Message Logging"
.LP
Another higher-level I/O facility is provided by
.Mo logLib ,
which allows formatted messages to be logged without having to do
I/O in the current task's context, or when there is no task context.
The message format and parameters are sent on a pipe to a
logging task, which then formats and outputs the message.
This is useful when messages must be logged from interrupt level,
or when it is desirable not to delay the current task for I/O
or use the current task's stack for message formatting
(formatting can take up significant stack space).
The message is displayed on the console unless otherwise redirected
by
.Sy logInit
or
.Sy logFdSet.

.N 1 "DIFFERENCES BETWEEN VxWORKS AND UNIX I/O"
.LP
Most commonplace use of I/O under VxWorks is completely source-compatible
with I/O under UNIX.
However, the following differences should be noted:

.IP "\fBDevice\ Configuration:\fP" 1i
In VxWorks device drivers may be installed and removed dynamically.

.IP "\fBFile\ Names:\fP" 1i
In UNIX, file names are path names where ``/'' separates successive levels
of directories.
In VxWorks, file names are just device names possibly followed by file names.
Device-name conventions use ``/'' to achieve a UNIX-like syntax.

.IP "\fBFile\ Descriptors:\fP" 1i
.br
In UNIX, \fIfd\fPs are unique to each process.
In VxWorks, \fIfd\fPs are global entities, accessible by any task,
except for standard input, output, and error (0, 1, and 2, respectively)
which \fImay\fP be task-specific.

.IP "\fBIoctl:\fP" 1i
The specific parameters passed to
.Sy ioctl
requests may be different in UNIX and VxWorks.

.N 1 "DEVICES IN VxWORKS"
.LP
The VxWorks I/O system allows considerable flexibility in the way
specific device drivers handle the seven I/O functions.
All the device drivers
follow the basic conventions outlined above, but differ in specifics.
The following sections describe the nature of I/O
for each of the devices supplied with VxWorks.

.N 2 "Driver Names"
.LP
The following drivers are provided:
.sp .5
.TS
box center;
cp11fB s
afB | afB
afI | a .
.sp .25
VxWorks Drivers
.sp .25
_
Module	Driver Description
_
.sp .25
tyCoDrv	Terminal Driver
ptyDrv	Pseudo Terminal Driver
pipeDrv	Pipe Driver
netDrv	Network Driver
nfsDrv	NFS Driver
ramDrv	RAM Driver
-	Other hardware-specific drivers
.sp .25
.TE

.N 2 "Serial I/O  Devices (TTY and PTY)"
.LP
VxWorks supplies terminal and pseudo terminal device drivers (tty and pty
drivers).  The tty driver is used for actual terminals.
The pty driver is used for processes which simulate terminals.
Pseudo terminals are useful in applications such as the
.Sy rlogin
facility.
The remainder of this section will use tty to indicate both tty and pty devices.
.LP
Serial I/O devices which are supplied with VxWorks are buffered serial byte
streams.
Each device has a ring buffer (circular buffer) for both input and output.
Reading from a tty device extracts bytes from the input ring.
Writing to a tty device adds bytes to the output ring.
The size of each ring buffer is specified when the device is created at system
initialization.

.N 3 "TTY Options"
.LP
The tty devices have a full range of options that affect the behavior
of the device.
These options are selected by setting bits in the device option word,
by using the
.Sy FIOSETOPTIONS
request in the
.Sy ioctl
function (see section on
.Sy ioctl
functions below).
The following is a list of options that are available.
The listed names are defined in the header file
.Mo ioLib.h .
.sp
.de iP
.IP "\fB\\$1\fP" 1i
..
.iP OPT_LINE
A tty device operates in one of two modes:  raw (unbuffered) mode or line mode.
Raw mode is the default.
Line mode is selected with this option.
In raw mode, each byte of input from the device is immediately available to
readers, and the input is not modified except as directed by other options
below.
In line mode, the input from the device is not available to readers until
a \s-2NEWLINE\s+2 character is received, and the input may be modified by
backspace, line-delete, and end-of-file special characters.
These modes are elaborated below.
.iP OPT_ECHO
This option causes all input characters to be echoed to the output of the
same channel.
This is done simply by putting incoming characters in the output ring as well
as in the input ring.
If the output ring is full, the echoing is lost without affecting the input.
.iP OPT_CRMOD
C language conventions use the
\s-2NEWLINE\s+2 (\\n)
character as the line terminator on both
input and output.
Most terminals, however, supply a
\s-2RETURN\s+2
character when the return key is hit, and require both a
\s-2RETURN\s+2
and a
\s-2LINEFEED\s+2
character to advance the output line.
This option enables the appropriate translation:
\s-2NEWLINE\s+2s
are substituted for input
\s-2RETURN\s+2
characters, and
\s-2NEWLINE\s+2s
in the output file are automatically turned into a
\s-2RETURN-LINEFEED\s+2 .
.iP OPT_TANDEM
.br
This option causes the driver to generate and respond to the special
flow control characters \s-2CONTROL-Q\s+2 and \s-2CONTROL-S\s+2
in what is commonly known as the X-on/X-off protocol.
Receipt of a \s-2CONTROL-S\s+2 input character will suspend output to that
channel.
Subsequent receipt of a \s-2CONTROL-Q\s+2 character will resume the output.
Also, when the VxWorks input buffer is almost full, a \s-2CONTROL-S\s+2
will be output to signal the other side to suspend transmission.
When the input buffer is empty enough, a \s-2CONTROL-Q\s+2 will be output
to signal the other side to resume transmission.
.iP OPT_7_BIT
This option strips the most significant bit from all bytes input from the
device.
.iP OPT_MON_TRAP
This option enables the special
.Sy monitor
.Sy trap
character, by default a
\s-2CONTROL-X\s+2.
When this character is received and this option is enabled, VxWorks will trap
to the ROM resident monitor program.
Note that this is quite drastic.
All normal VxWorks functioning is suspended, and the computer system is
entirely controlled by the monitor.
Depending on the particular monitor, it may or may not be possible
to restart VxWorks from the point of interruption.
The monitor trap character can be changed from the default by calling
.Sy tyMonitorTrapSet .
.iP OPT_ABORT
This option enables the special
.Sy shell
.Sy abort
character, by default a
\s-2CONTROL-C\s+2 .
When this character is received while this option is enabled,
the VxWorks shell is restarted.
This is used to free a shell stuck in an unfriendly routine,
such as an infinite loop or taking an unavailable semaphore.
Refer to the
.Ch "VxWORKS SHELL"
chapter for details.
.iP OPT_TERMINAL
This is not a separate option bit.
It is just the value of the option word with
.UL all
the above bits set.
.iP OPT_RAW
Likewise this is not a separate option bit.
It is just the value of the option word with
.UL none
of the above bits set.

.N 3 "Raw Mode and Line Mode"
.LP
As indicated above, tty devices have two different input modes, raw and line,
selected by the OPT_LINE bit of the device option word.
In raw mode, each character is made available in the input ring
as soon as it is input from the device.
Reading from a tty device in raw mode causes as many characters as
possible to be extracted from the input ring,
up to the limit of the user's read buffer.
.LP
In line mode, the characters are saved until a \s-2NEWLINE\s+2 character
is input,
and then the entire line of characters, including the \s-2NEWLINE\s+2,
is made available in the ring all at once.
Reading from a tty device in line mode causes characters
up to the end of the next line to be extracted from the input ring,
up to the limit of the user's read buffer.
.LP
Line mode also involves special processing of certain characters.
A special backspace character causes successive previous characters
to be deleted from the current line, up to the start of the line.
It does this by echoing a backspace followed by a space, and then
another backspace.  The default backspace character is
\s-2CONTROL-H\s+2.
This can be changed by calling
.Sy tyBackspaceSet .
.LP
Similarly, a special line-delete character, by default a
\s-2CONTROL-U\s+2,
will delete all the characters of the current line.
The line-delete character can be changed by calling
.Sy tyDeleteLineSet .
.LP
Finally, a special end-of-file character, by default a
\s-2CONTROL-D\s+2,
will cause the current line to become available in the input ring
without a \s-2NEWLINE\s+2 and without entering the end-of-file character itself.
Thus if the EOF character is the first character typed on a line,
reading that line will return a zero byte count,
which is the usual indication of end-of-file.
The EOF character can be changed by calling
.Sy tyEOFSet .

.N 3 "Ioctl Functions"
.LP
The tty devices respond to the following
.Sy ioctl
requests.  The request names listed are defined in the header
.Mo ioLib.h .

.iP FIOGETNAME
.br
This request gets the file name of the file descriptor and copies it into
the buffer pointed to by the third argument.
Example:
.DS
status = ioctl (fd, FIOGETNAME, &nameBuf);
.DE
This request is common to all file descriptors for all devices.
.iP FIOSETOPTIONS
This request sets the device option word to the specified argument.
For example, the call
.DS
status = ioctl (fd, FIOSETOPTIONS, OPT_TERMINAL);
.DE
enables all the options described above, putting the device in a
``normal'' terminal mode.
.iP FIOGETOPTIONS
This request returns the current device option word.
Example:
.DS
options = ioctl (fd, FIOGETOPTIONS);
.DE
.iP FIONREAD
This request calculates the number of bytes available to be read in the device's
input ring and places the result in the long integer whose address is
passed as the third argument.
Example:
.DS
status = ioctl (fd, FIONREAD, &nBytes);
.DE
In line-protocol mode (OPT_LINE set) FIONREAD actually returns the
number of characters available PLUS the number of lines in the buffer.
Thus, if five lines consisting of just newlines were in the input buffer,
FIONREAD would return the value ten (five characters + five lines).
.iP FIONWRITE
This request returns the number of bytes available in the output buffer
and places the result in the long integer whose address is
passed as the third argument.
Example:
.DS
status = ioctl (fd, FIONWRITE, &nBytes);
.DE
.iP FIOFLUSH
This request discards all the bytes currently in both the input and the
output rings.
Example:
.DS
status = ioctl (fd, FIOFLUSH);
.DE
.iP FIOCANCEL
This request cancels a read or write.
A task may be blocked at a read, but beforehand it started a watchdog
routine to time-out the read.  The watchdog routine would use this
call on the appropriate
.Sy fd .
Example:
.DS
status = ioctl (fd, FIOCANCEL);
.DE
.iP FIOBAUDRATE
.br
The baud rate of the device is set to the specified argument.
For example, the call:
.DS
status = ioctl (fd, FIOBAUDRATE, 9600);
.DE
sets the device to operate at 9600 baud.
This request has no meaning on a pseudo terminal.

.N 2 "RT-11 Devices (Disk and RAM Disk Devices)"
.LP
RT-11 devices are file structured devices based on the VxWorks file system.
Files on RT-11 devices can be created, deleted, and renamed.
Files on RT-11 devices can be randomly accessed using
.Sy ioctl
functions discussed below.
Also, information from an RT-11 device's file directory can be obtained using
.Sy ioctl
functions.
.LP
RT-11 devices are accessed internally in blocks of 512 bytes.
Each open file on an RT-11 device has a single block buffer.
Data written to an RT-11 file is written to the buffer.
The buffer is actually written to the physical device only when another block is
read or written, when the file is closed, or when explicitly requested with an
.Sy ioctl
function.
See
.Mo rt11Lib
for details.

.N 3 "Accessing the Raw Device"
.LP
The ``raw'' RT-11 device can be accessed, circumventing the file structure
of the device, by opening the device without a file name component.
A file opened to the raw device can access the entire disk, or chunk of memory
on a RAM disk, as a single linear space.
Some
.Sy ioctl
functions operate on the device as a whole instead of specific files,
such as initializing a new file system, or accessing a directory.
For example:
.DS
fd = open ("/dk0/", WRITE)
.DE
opens an
.Sy fd
to the entire ``/dk0/'' disk.

.N 3 "Ioctl Functions"
.LP
RT-11 devices respond to the following
.Sy ioctl
requests.  The request names listed are defined in the header
.Mo ioLib.h .
.sp
.iP FIOGETNAME
.br
This request gets the file name of the file descriptor and copies it into
the buffer pointed to by the third argument.
Example:
.DS
status = ioctl (fd, FIOGETNAME, &nameBuf);
.DE
.iP FIONREAD
This request calculates the number of bytes remaining in the file following
the current position and places the result in the long integer whose address is
passed as the third argument.
Example:
.DS
status = ioctl (fd, FIONREAD, &nBytes);
.DE
.iP FIOFLUSH
This request forces the file descriptor's block buffer to be written
to the device.
It takes no additional argument.
Example:
.DS
status = ioctl (fd, FIOFLUSH);
.DE
.iP FIODISKFORMAT
This request causes the entire disk to be formatted with appropriate
hardware track and sector marks.
No file system is initialized on the disk by this request.
Example:
.DS
fd = open ("/dk0/", WRITE);
status = ioctl (fd, FIODISKFORMAT);
.DE
.iP FIODISKINIT
This request causes a new file system to be initialized on the device.
Example:
.DS
fd = open ("/dk0/", WRITE);
status = ioctl (fd, FIODISKINIT);
.DE
.iP FIODISKCHANGE
This request notifies
.Mo rt11Lib
that the device's disk has been changed.
It should be called whenever a driver senses that a device has come on-line
or gone off-line, e.g. a disk has been inserted or removed.
Example:
.DS
status = ioctl (fd, FIODISKCHANGE);
.DE
A driver may use
.Sy rt11ReadyChange
to achieve the same effect.
.iP FIOSQUEEZE
This request is used to coalesce fragmented free space on an RT-11 volume.
Example:
.DS
status = ioctl (fd, FIOSQUEEZE);
.DE
.iP FIOSEEK
This request sets the current position in the file to the specified byte
offset from the beginning of the file.
Note that an actual seek on the physical device does not occur until data is
read or written at the new position.
Example:
.DS
status = ioctl (fd, FIOSEEK, position);
.DE
.iP FIOWHERE
This request returns the current position in the file.  This is the byte
offset of the next byte to be read or written.
Example:
.DS
position = ioctl (fd, FIOWHERE);
.DE
.iP FIODIRENTRY
.br
This request returns information about specified entries in the device's
directory.
The third argument to the
.Sy ioctl
call is a pointer to a REQ_DIR_ENTRY structure, which is defined in
.Mo ioLib.h .
On entry, the structure contains the number of the directory entry about which
information is requested.
On return, the structure contains the information on the requested entry.
For example, after the following:
.DS
REQ_DIR_ENTRY req;

req.entryNum = 0;
status = ioctl (fd, FIODIRENTRY, &req);
.DE
the request structure contains the name, size, and creation date of the
file in the first entry in the directory.
.iP FIORENAME
This request causes the name of the file
to be changed to the specified argument.
Example:
.DS
status = ioctl (fd, FIORENAME, "newname");
.DE

.N 3 "Creating a RAM Disk Device"
.LP
RAM devices, as implemented in
.Mo ramDrv ,
emulate disk devices but actually keep all data in memory.
Memory location and ``disk'' size are specified when a RAM device is created
by calling
.Sy ramDevCreate
or
.Sy ramMkfs .
These routines may be called many times to create multiple RAM disks
with different names.
.Sy ramMkfs
provides a somewhat simpler way to create
and initialize RAM disks with standard parameters.
The device is created with the specified name and size.
If no memory address is specified, then memory for the RAM disk will be
allocated from the pool.
Example:
.DS
ramMkfs ("/ram/", 200000, 0, 0)
.DE
creates a RAM device named ``/ram/'' with 200000 bytes of memory
allocated from the pool, and initializes an RT-11 directory on it.
.DS
ramMkfs ("/ram/", 200000, 0xc0000, 1)
.DE
creates a RAM device whose starting address is 0xc0000 and does
.UL not
initialize an RT-11 directory on it.  This might be useful
if a RAM disk was created at that same address in a previous
boot of VxWorks, or if several CPU's are sharing a single RAM disk.
The contents of the RAM disk would be preserved.

.N 2 "Pipe Devices"
.LP
Pipes are virtual devices by which tasks communicate with each other through
the I/O system.
In
.Mo pipeDrv
each pipe consists of a single memory-resident FIFO buffer.
Tasks write data to the pipe which can then be read by any other task.
Full-duplex communication between two tasks generally requires
two pipes, one for each direction.

.N 3 "Message Passing"
.LP
VxWorks' pipes are not necessarily simple byte streams.
Most inter-task communication in real-time systems is in
passing discrete messages between tasks, as opposed to continuous byte streams.
To support this, pipe I/O is message oriented.
Each individual
.Sy write
to a pipe is considered a single indivisible message.
Each individual
.Sy read
from a pipe dequeues the data of just a single message, even if more
data from other messages is in the pipe and more space is available in
the reader's buffer.
Moreover, if the reader does not specify a buffer large enough to contain
the entire next message as sent in a single
.Sy write ,
the reader's buffer is filled and the remainder of the message is discarded.

.N 3 "Creating Pipes"
.LP
Pipes are created by calling the pipe create routine:
.DS
status = pipeDevCreate ("/pipe/name", maxMsgs, maxLength);
.DE
The new pipe will be able to have at most
.Sy maxMsgs
queued at a time.
Tasks that write to a pipe that already has the maximum number of messages
queued, are delayed until room is made available by the dequeuing of a message.
Each message in the pipe can be at most
.Sy maxLength
bytes long.
Attempts to write messages longer than the maximum result in an error.

.N 3 "Writing to Pipes from Interrupt Level"
.LP
VxWorks pipes are specially designed to make it possible for interrupt-level
code to write to pipes in the same way as task-level code.
Many VxWorks facilities are not available to interrupt-level code,
including I/O to devices other than pipes.
However, interrupt-level code can use pipes to communicate with tasks which
can then invoke such facilities.
.LP
Interrupt level code writes to a pipe using the normal
.Sy write
call.
Tasks and interrupt-level code can write to the same pipes.
However, if the pipe is full, the message written is discarded since the
interrupt-level code cannot pend.
Interrupt-level code must not invoke any I/O function on pipes other than
.Sy write .
VxWorks supplies a logging mechanism that works in this way and
so can be used by interrupt-level code as well as by tasks.
See the library
.Mo logLib .

.N 3 "Ioctl Functions"
.LP
Pipe devices respond to the following
.Sy ioctl
requests.  The request names listed are defined in the header
.Mo ioLib.h .
.sp
.iP FIOGETNAME
.br
This request gets the file name of the file descriptor and copies it into
the buffer pointed to by the third argument.
Example:
.DS
status = ioctl (fd, FIOGETNAME, &nameBuf);
.DE
.iP FIONREAD
This request calculates the number of bytes remaining in the pipe following the
current position and places the result in the long integer whose address is
passed as the third argument.
Example:
.DS
status = ioctl (fd, FIONREAD, &nBytes);
.DE
.iP FIONMSGS
This request calculates the number of discrete messages available to be read
in the pipe and places the result in the long integer whose address is passed
as the third argument.
Example:
.DS
status = ioctl (fd, FIONMSGS, &nMessages);
.DE
.iP FIOFLUSH
This request discards all the messages in the pipe and releases the memory block
that contained them.
Example:
.DS
status = ioctl (fd, FIOFLUSH);
.DE

.N 2 "Network File System (NFS) Devices"
.LP
NFS devices allow files on remote hosts to be accessed
via the Network File System protocol (NFS).
The driver
.Mo nfsDrv
acts as an NFS ``client'' to access files on any NFS ``server'' on the network.
Using NFS devices, remote files are created, opened, and accessed exactly
as though they were on a file system on a local disk.
This is called
.I "network transparency" .

.N 3 "Mounting an NFS File System"
.LP
Access to a remote NFS file system is established by
.I mounting
that file system locally by calling the routine
.Sy nfsMount .
The arguments to
.Sy nfsMount
are  (1) the host name of the NFS server where the file system resides,
(2) the name of the desired file system or subdirectory on that host,
and (3) the local name by which that file system will be known.
If the local name is specified
.I NULL ,
the local name will be the same as the remote name.
For example, the call:
.DS
nfsMount ("mars", "/usr", "/vwusr");
.DE
would mount
.Mo /usr
of the host
.I mars
as
.Mo /vwusr
locally.
This actually creates a VxWorks I/O device with the specified local name
(i.e. ``/vwusr'' in this example).
.LP
After a remote file system is mounted, the files are accessed just as though
the file system were local.
Thus, after the
.Sy nfsMount
above, opening the file
.Mo /vwusr/foo
would open the file
.Mo /usr/foo
on the host
.I mars .
.LP
The remote file system must have been
.I exported
by the system on which it actually resides.
Also NFS requires
.I authentication
parameters to identify the user making the remote access.
These parameters are set using the routines
.Sy nfsAuthUnixSet
and
.Sy nfsAuthUnixPrompt .
.LP
The issues of exporting and mounting NFS file systems,
and authenticating access permissions, are discussed in more detail in the
.Ch NETWORK
chapter under
.Ch "Transparent Remote File Access via NFS" .
See also SUN's NFS documentation and the manual entries for both
.Mo nfsLib
and
.Mo nfsDrv .

.N 3 "Ioctl Functions"
.LP
Network devices respond to the following
.Sy ioctl
requests.
The request names listed are defined in the header
.Mo ioLib.h .
.sp
.iP FIOGETNAME
.br
This request gets the file name of the file descriptor and copies it into
the buffer pointed to by the third argument.
Example:
.DS
status = ioctl (fd, FIOGETNAME, &nameBuf);
.DE
.iP FIONREAD
This request calculates the number of bytes remaining in the file following the
current position and places the result in the long integer whose address is
passed as the third argument.
Example:
.DS
status = ioctl (fd, FIONREAD, &nBytes);
.DE
.iP FIOSEEK
This request sets the current file position to the specified
byte offset from the beginning of the file.  If the seek goes beyond
the end of file, the file grows.  The end of file pointer gets moved
to the new position, and the new space is filled with 0's.
Example:
.DS
status = ioctl (fd, FIOSEEK, position);
.DE
.iP FIOWHERE
This request returns the current file position.
This is the byte offset of the next byte to be read or written.
It takes no additional argument.
Example:
.DS
position = ioctl (fd, FIOWHERE)
.DE
.iP FIODIRENTRY
.br
This request displays information about specified entries in the device's
directory.
There is no third argument as in RT-11 devices.
The following,
.DS
status = ioctl (fd, FIODIRENTRY);
.DE
will cause the remote directory contents to be printed on standard output.
.I
This implementation is temporary.
.R

.N 2 "Non-NFS Network Devices"
.LP
VxWorks also supports several alternative protocols, other than NFS,
for accessing files on a remote UNIX host via the network.
Using the driver
.Mo netDrv ,
either the UNIX remote shell,
.Sy rsh ,
or the File Transfer Protocol,
.Sy ftp ,
can be used to access remote files.
These implementations of network devices actually copy the
remote files in their entirety into local memory when they are opened.
Subsequent read and write operations are performed on the in-memory
copy of the file.
When the file is closed, it is copied back to the original remote file
if it has been modified.
.LP
In general,
NFS devices are preferable to non-NFS devices described in the previous section,
for performance and flexibility,
since with NFS the entire file is not copied into memory when the file is
opened.
However, NFS is slightly more cumbersome to administer and may not
be supported by all host systems.

.N 3 "Creating Network Devices"
.LP
To access files on a remote host using either
.Sy rsh
or
.Sy ftp ,
a network device must first be created by calling the routine
.Sy netDevCreate .
The arguments to
.Sy netDevCreate
are the name of the device, the name of the host that device will access,
and which protocol will be used.
By convention, a network device's name is the remote machine's name
followed by a ``:''.
.DS
netDevCreate ("mars:", "mars", 0);
.DE
.LP
Files on a network device can be created, opened, and manipulated
just like files on a local disk.
Thus, opening the file ``mars:/usr/foo'' would actually open the file
``/usr/foo''
on the host
.I mars .
.LP
Note that whereas mounting an NFS file system with
.Sy nfsMount ,
discussed in the previous section,
allows access only to a specified file system on the remote system,
creating a network device will allow access to
any file or device on that host.
.LP
In order for the files of a remote host to be accessible via
.Sy rsh
or
.Sy ftp ,
permissions and user identification must have been established
both on the remote and local systems.
The issues of creating and configuring network devices
are discussed in more detail in the
.Ch NETWORK
chapter under
.Ch "Transparent Remote File Access via \fIrsh\fP or \fIftp" .
Also see the manual entry for
.Mo netDrv .
.LP
Non-NFS devices respond to the same
.Sy ioctl
requests as NFS devices.

.N 2 "Sockets"
.LP
In VxWorks, the basis of network communications is ``sockets''.
A socket is an endpoint for communication between tasks;
data is sent from one socket to another.
.LP
Sockets are
.I not
created or opened using the standard I/O functions.
Instead they are created by calling the routine
.Sy socket ,
and connected and accessed using the other functions in
.Mo sockLib(2) .
These routines are source compatible with the socket functions of BSD 4.3 UNIX.
The protocol of using these functions is discussed in the
.Ch ARCHITECTURE
chapter under
.Ch "Inter-Task Communications" .
.LP
Once a ``stream'' socket (using TCP) is created and connected, however,
it can be accessed as a standard I/O device, using
.Sy read ,
.Sy write ,
.Sy ioctl ,
and
.Sy close .
The value returned from the
.Sy socket
routine as the handle on the created socket, is in fact an I/O system
.Sy fd .

.N 1 "INTERNALS"
.LP
The remainder of this chapter discusses the internal structure
of the VxWorks I/O system.
.LP
The VxWorks I/O system is different from most in the way the work of performing
user I/O requests is partitioned between the device-independent I/O system and
the individual device drivers.
In many systems, the device driver simply supplies a few functions
to perform low-level I/O functions such as inputting or outputting
a sequence of bytes to character-oriented devices,
or reading or writing individual blocks on block-oriented devices.
The higher-level protocols,
such as communications protocols on character-oriented devices,
or file systems on block-oriented devices,
are implemented in the device-independent part of the I/O system.
The user requests are heavily processed by the I/O
system before the driver functions get control.
.LP
This architecture is designed to make it easy to implement drivers and to
ensure that devices behave as much alike as possible.
However, it has several drawbacks.
The driver writer is often seriously hampered in implementing
alternative protocols that are not provided by the existing I/O system.
In a real-time system, it may be desirable to bypass the standard protocols
altogether in certain devices where throughput is critical
or where the device does not fit the standard model.
.LP
In the VxWorks I/O system, on the other hand, minimal processing is done on
user I/O requests before control is given to the device driver.
Instead, the VxWorks I/O system just acts as a switch to route user requests
to appropriate driver supplied routines.
Each driver can then process the raw user requests
as appropriate to its devices.
However, several very high-level subroutine libraries are available to driver
writers that implement standard protocols
for both character- and block-oriented devices.
Thus the VxWorks I/O system gives you the best of both worlds:
while it is easy to write a standard driver for most devices
with just a few pages of device-specific code,
driver writers are free to execute the user requests in non-standard ways where
appropriate.
.LP
The three main elements of the VxWorks I/O system,
as alluded to in the preceding discussions, are drivers, devices, and files.
The next sections describe these elements in detail.

.N 2 "The Example"
.LP
Figure 1 shows the abbreviated code for a hypothetical driver which will be
used as an example throughout the following discussions.
It is typical of drivers for character-oriented devices.
.LP
In VxWorks, each driver has a short, unique abbreviation
such as ``net'', ``ram'', or ``tyCo'',
that is prefixed to each of it's routines.
The abbreviation for the example driver is ``xx''.
.KF
.LD
.ps -1
.vs -2
        /**************************************************************************************************
        * xxDrv - driver initialization routine
        *
        * This routine is called to initialize the driver.  It installs the driver by calling iosDrvInstall.
	* It may allocate data structures, connect interrupt routines to their interrupts,
	* and initialize device hardware.
        */
        STATUS	xxDrv ()
            {
            xxDrvNum = iosDrvInstall (xxCr, 0, xxOp, 0, xxRd, xxWrt, xxIoctl);
            (void) intConnect (intvec, xxInterrupt, ...);
            ...
            }
        /**************************************************************************************************
        * xxDevCreate - device creation routine
        *
        * This routine is called to add a device to the system that will be serviced by this driver, by the specified name.
        * Other driver dependent arguments may be required such as buffer sizes, device addresses, etc.
        * The routine adds the device to the I/O system by calling iosDevAdd.
        * It may also allocate and initialize data structures for the device,  initialize semaphores,
        * initialize device hardware, etc.
        */
        STATUS xxDevCreate (name, ...)
            char *name;
            ...
            {
            status = iosDevAdd (xxDev, name, xxDrvNum);
            ...
            }
        /**************************************************************************************************
        * The following routines implement the basic I/O functions.  Note that the return value type is driver dependent.
        */
        XXDEV *xxOpen (xxDev, remainder, mode)
            XXDEV *xxDev;
            char *remainder;
            int mode;
            {
	    /* serial devices should have no file name part */

            if (remainder[0] != 0)
                return (ERROR);
            else
                return (xxDev);
            }
        int xxRead (xxDev, buffer, nBytes)
            XXDEV *xxDev;
            char *buffer;
            int nBytes;
            ...
        int xxWrite (xxDev, buffer, nBytes)
            ...
        int xxIoctl (xxDev, requestCode, arg)
            ...
        /**************************************************************************************************
        * xxInterrupt - interrupt service routine
        *
        * Most drivers have routines that handle interrupts from the devices serviced by the driver.
	* These routines are connected to the interrupts by calling intConnect  (usually in xxDrv above).
	* They can receive a single argument, specified in the call to intConnect (see intLib).
        */
        VOID xxInterrupt (arg)
            ...
.ps
.vs
.ce
\fBFigure 1.\fP
.DE
.KE

.N 2 "Drivers"
.LP
A driver implements the seven basic I/O functions,
.Sy creat ,
.Sy delete ,
.Sy open ,
.Sy close ,
.Sy read ,
.Sy write ,
and
.Sy ioctl ,
for a particular kind of device.
In general, a driver has routines that implement each of these functions,
although some of the routines may be omitted if the function
is a no-op for that device.
.LP
When users invoke one of the basic I/O functions, the I/O system eventually
routes the request to the appropriate routine of a specific driver,
through a path that is detailed in subsequent sections.
The driver's routine runs in the calling task's context,
just as though it had been called directly from the user program.
Thus the driver is free to use any facilities
normally available to tasks, including doing I/O to other devices.
Note that this means that most drivers have to use some mechanism
to provide mutual-exclusion to critical regions of code.
The usual mechanism is the semaphore facility provided by the
subroutine library,
.Mo semLib .
.LP
In addition to the routines that implement the seven basic I/O functions,
drivers also have three other routines.
First, drivers have an initialization routine that installs the driver
in the I/O system as described below,
connects to any interrupts used by the devices serviced by the driver,
and may perform some hardware initialization.
Next, drivers provide a routine to add devices to the I/O system
that are to be serviced by the driver.
Finally, most drivers involve some interrupt-level routines
that are connected to the interrupts of the devices serviced by the driver.
See Figure 3 for an example of a device list.

.N 3 "The Driver Table and Installing Drivers"
.LP
The function of the I/O system is to route user I/O requests to the appropriate
routine of the appropriate driver.
This is done by means of a table maintained by the I/O system
that contains the address of each routine for each driver.
Drivers are installed dynamically by calling the I/O system internal
function
.Sy iosDrvInstall .
The arguments to this routine are the addresses of the seven I/O routines
for the new driver.
The
.Sy iosDrvInstall
routine enters these addresses in a free slot
in the driver table.
The index of this slot in the table is returned as the result
of the
.Sy iosDrvInstall
function.
This number is known as the driver number and is used subsequently
to associate particular devices with the driver.
.LP
NULL (0) addresses may be specified for some of the seven routines.
This indicates that the driver does not have any processing to do
to perform those functions.
For non-file system drivers,
.Sy close
and
.Sy delete
are often no-ops as
far as the driver is concerned.

.N 3 "Example of Installing a Driver"
.LP
In Figure 2, the initialization routine
.Sy xxDrv
of our example driver calls
.Sy iosDrvInstall ,
specifying the addresses of the driver's
routines for the seven basic I/O functions.
The I/O system locates the next available slot in the driver table,
in this case slot 3.
The driver's function addresses are entered in the table
and the slot number returned as the driver number of the newly installed driver.
.KF
.sp 8.8i
.ce
\fBFigure 2.\fP
.KE

.N 2 "Devices"
.LP
A driver may be capable of servicing many instances of a particular kind of
device.
For example, a single driver for a serial communications device
can often handle many individual channels that differ only in a few parameters,
such as device address.
.LP
In the VxWorks I/O system, devices are defined by a data structure called a
.UL device
.UL header .
This data structure contains the device name string and the driver number
for the driver that will service this device.
The device headers for all the devices in the system are kept
in a memory-resident linked list called the
.UL device
.UL list .
The device header is the initial part of a
larger structure determined by the individual drivers.
This larger structure, called a
.UL device
.UL descriptor ,
contains additional device-specific data such as device addresses,
buffers, semaphores, etc.

.N 3 "The Device List and Adding Devices"
.LP
Devices are dynamically added to the I/O system by calling the internal I/O
function
.Sy iosDevAdd .
The arguments to
.Sy iosDevAdd
are the address of the device descriptor
for the new device, the device's name, and the driver number of the
driver that will service the device.
The device descriptor specified by the driver can contain any necessary
device-dependent information, so long as it begins with a device header.
The driver does not need to fill in the device header,
only the device-dependent information.
The
.Sy iosDevAdd
routine enters the specified device name and the driver number
in the device header and adds it to the system device list.

.N 3 "Example of Adding Devices"
.LP
In Figure 3, the device creation routine
.Sy xxDevCreate
of our example driver adds
devices to the I/O system by calling
.Sy iosDevAdd .
.KF
.sp 8.8i
.ce
\fBFigure 3.\fP
.KE

.N 2 "File Descriptors"
.LP
Several files may be open at once to a single device.
A device driver may have additional information associated with an
.Sy fd
beyond the I/O system's device information.
In particular, file system devices in which multiple
files may be open on the same device
have file-specific information (e.g. file offset) associated with each
.Sy fd .
One can also have several file descriptors open to a non-structured device,
e.g. a tty; typically there is no additional information, and thus writing
on any of the \fIfd\fPs would have identical results.

.N 3 "The Fd Table"
.LP
Files are opened with the I/O routine
.Sy open
(or
.Sy creat ).
The I/O system searches the device list for a device name that matches
the file name, or an initial substring, specified by the caller.
If such a match is found, the I/O system then uses the driver number
contained in the located device header to locate and call
the driver's
.Sy open
routine via the driver table.
.LP
The I/O system needs to establish an association between the file descriptor
that will be used by the caller in subsequent I/O calls,
and the driver that will service it.
Additionally, the driver needs to associate some data structure
per descriptor.
In the case of non-file system devices, this is usually just the device
descriptor that was located by the I/O system.
In the case of file system devices, the driver associates an additional
internal data structure.
.LP
The I/O system maintains these associations in a table called the
.I "fd table" .
This table contains the driver number and an additional
driver determined 4-byte value.
The driver value is the internal descriptor returned by the driver's
.Sy open
routine,
and may be any non-negative value the driver requires to identify the file.
In subsequent calls to the driver's other I/O functions
(
.Sy read ,
.Sy write ,
.Sy ioctl ,
and
.Sy close ),
this value will be supplied
to the driver in place of the
.Sy fd
in the user's I/O call.

.N 3 "Example of Opening a File"
.LP
In Figure 4, a user calls the I/O function
.Sy open
to open the file ``/xx0''.
First, the I/O system searches the device list for a device name that matches
the specified file name, or an initial substring of the file name.
In this case, a complete device name match is found.
.LP
Next the I/O system reserves a slot in the
.Sy "fd table" ,
which will be used if the open is successful.
.LP
The I/O system then looks up the address of the driver's
.Sy open
routine and calls that routine.
Note that the arguments to the driver's
.Sy open
routine are transformed
by the I/O system from the user's original arguments to
.Sy open .
The first argument to the driver's
.Sy open
routine is a pointer to the device
descriptor the I/O system located in the full file name search.
The next parameter is the
.UL remainder
of the file name specified by the user,
after removing the initial substring that matched the device name.
In this case, since the device name matched the entire file name,
the remainder passed to the driver is a null string.
The driver is free to interpret this remainder in any way it wants.
In the case of file systems,
this remainder would be the name of a file on the device.
In the case of a non-file system device like this one,
it is usually an error for the remainder to be anything
.UL but
the null string.
.KF
.sp 8.8i
.ce
\fBFigure 4.\fP
.KE
.LP
In Figure 5, the
.Sy open
process continues with the driver's
.Sy open
routine
executing and then returning a value by which it will subsequently identify the
newly opened file.
In this case, the value is just the pointer to the device descriptor.
This value will be supplied to the driver in subsequent I/O calls
that refer to the file being opened.
Note that if the driver returns just the device descriptor, the driver will
not be able to distinguish multiple files opened to the same device.
In the case of non-file system drivers this is usually appropriate.
File system drivers return, as the identifying value,
a pointer to an internal descriptor that is unique for each file.
.LP
The I/O system then enters the driver's number and the value returned by the
driver's
.Sy open
routine in the reserved slot in the
.Sy "fd table" .
Again note that the value entered in the
.Sy "fd table"
is meaningful only to the driver,
and is arbitrary as far as the I/O system is concerned.
.LP
Finally, the I/O system returns to the user the index of the slot in the
.Sy "fd table" ,
in this case 1.
This is the user's file descriptor (\fIfd\fP).
.KF
.sp 8.8i
.ce
\fBFigure 5.\fP
.KE

.N 3 "Example of Reading Data from the File"
.LP
In Figure 6, the user calls the I/O function
.Sy read
to obtain input data from the file.
The specified
.Sy fd
is the index into the
.Sy "fd table"
for this file.
The I/O system uses the driver number contained in the
.Sy "fd table"
to locate the driver's
.Sy read
routine.
The I/O system calls this routine, passing it the identifying value in the
.Sy "fd table" ,
which was specified by the driver's
.Sy open
routine.
Again, in this case, this value is just the pointer to the device descriptor.
The driver's
.Sy read
routine then does whatever is necessary
to read data from the device.
.LP
The procedure for user calls to
.Sy write
and
.Sy ioctl
proceed in a similar manner.
.KF
.sp 8.8i
.ce
\fBFigure 6.\fP
.KE

.N 3 "Example of Closing a File"
.LP
The user calls the I/O function
.Sy close
to terminate use of the file.
As in the case of the
.Sy read
function above, the I/O system uses the driver
number contained in the
.Sy "fd table"
to locate the driver's
.Sy close
routine.
In the example, no
.Sy close
routine has been specified, so no driver routines are called.
Instead, the I/O system simply marks the slot in the
.Sy "fd table"
as being available.
Any subsequent references to that
.Sy fd
would cause an error.
Subsequent calls to
.Sy open
may re-use that slot.

.N 2 "Initializing the I/O System"
.LP
Before using the I/O system, it must be initialized by calling
.Sy iosInit .
The arguments to
.Sy iosInit
are the maximum number of drivers and the maximum number
of open files that will be allowed in the system.
The I/O system will allocate space for the driver table
and the
.Sy "fd table"
large enough to accommodate the specified maximums.
.LP
The I/O system is initialized in the root task in
.Mo usrConfig ,
and no I/O functions can be called until the initialization has occurred.

.N 2 "Driver Support Libraries"
.LP
There are several subroutine libraries that may be of assistance in
writing device drivers.
Using these libraries, drivers for most devices following standard protocols
can be written with just a few pages of device-dependent code.
See the manual entries on these libraries for details.
.sp
.TS
box center;
cp11fB s
afB | afB
afI | a .
.sp .25
VxWorks Driver Support Libraries
.sp .25
_
Library	Description
_
.sp .25
errnoLib	Error status library
ftpLib	ARPA File Transfer Protocol library
ioLib	I/O interface library
iosLib	I/O system library
intLib	Interrupt support subroutine library
remLib	Remote command library
rngLib	Ring buffer subroutine library
rt11Lib	RT-11 file system subroutine library
tyLib	Serial device driver subroutine library
wdLib	Watchdog timer subroutine library
.sp .25
.TE
.TO
