.po 1.25i
.WP "Documentation" VxWorks 4.00
.TL
VxWORKS DOCUMENTATION GUIDE
.SP
.LP
VxWorks documentation is organized in two major divisions.
The first is the \f2VxWorks Programmer's Guide\fP, which describes
the components of the VxWorks system and how they interrelate.
The second is the \f2VxWorks Reference Manual\fP, which contains
UNIX-style manual page entries for all VxWorks modules and subroutines.
.N 1 "PROGRAMMER'S GUIDE"
.LP
The \f2VxWorks Programmer's Guide\fP contains the following chapters:
.RS
.IP "\fB1. Documentation Guide\fR"
.br
This guide.

.IP "\fB2. Overview\fR"
.br
Outlines all VxWorks facilities and sub-systems, and indicates where
to find additional information about each.

.IP "\fB3. Getting Started\fR"
.br
Gives step-by-step procedures for installing VxWorks,
configuring host software
and target hardware and software, booting VxWorks, and loading
and running the demo programs.

.IP "\fB4. Architecture\fR"
.br
Describes the fundamentals of the VxWorks run-time environment, including
the multi-tasking kernel, spawning and manipulation of tasks,
inter-task communication facilities, and interrupt service code.

.IP "\fB5. I/O System\fR"
.br
Describes the user view of the VxWorks I/O system in general,
the specifics of VxWorks supplied device drivers,
and internal details of the I/O system, 
including how to write device drivers.

.IP "\fB6. Network\fR"
.br
Describes the VxWorks network and remote file system.
Covers TCP/IP, Ethernet, backplane network, remote procedure calls, 
network file systems, etc.

.IP "\fB7. Shell\fR"
.br
Describes the VxWorks shell, an interactive C-expression interpreter.

.IP "\fB8. Cross-Development\fR"
.br
Discusses VxWorks cross-development facilities and procedures.
Describes the module loader and system symbol table,
how to build and load application modules,
and how to configure and build VxWorks itself.

.IP "\fB9. Debugging\fR"
.br
Describes VxWorks debugging facilities and techniques.

.IP "\fB10. Coding Conventions\fR"
.br
Describes coding conventions used by Wind River Systems in all source
modules.
.RE

.N 1 "REFERENCE MANUAL"
.LP
The \f2VxWorks Reference Manual\fP consists of UNIX-style manual page entries,
and is divided into the following sections:
.RS

.IP "\fBLIBRARY SUMMARIES (1)\fR"
.br
Contains manual entries for all VxWorks libraries.
Each manual entry lists the routines found in a given library,
including a one-line synopsis of each, along with a general description
of their use.

.IP "\fBSUBROUTINES (2)\fR"
.br
Contains manual entries for all VxWorks subroutines.

.IP "\fBDRIVERS (3)\fR"
.br
Contains manual entries for all VxWorks supplied drivers.

.IP "\fBTOOLS (4)\fR"
.br
Contains manual entries for all VxWorks tools which run under UNIX.

.IP "\fBHOST/TARGET (5)\fR"
.br
Contains manual entries for all host and target CPUs supported by VxWorks,
providing information specific to each configuration.
.RE

.N 1 "Application Notes"
.LP
Application notes on specific topics are included with all documentation.

