.de iP
.IP "\fI\\$1\fP\ \fR\\$2"
..
.WP "Debugging" VxWorks 4.00
.TL
DEBUGGING UNDER VxWORKS
.SP
.N 1 "INTRODUCTION"
.LP
VxWorks provides numerous facilities for debugging application code.
This chapter describes these debugging facilities
and discusses general techniques for debugging under VxWorks.
.LP
When debugging, you will be interacting with the VxWorks shell
and with several libraries available through it.
Therefore, the first step is to understand the shell.
This chapter includes a short synopsis of how the shell fits
into the debugging environment,
but the shell is described in much greater detail in its own chapter.
(See
.Ch "VxWORKS SHELL" ).
.LP
From the VxWorks shell, you can access the numerous utilities available
for debugging.  These utilities are simply C subroutines
designed to be called from the shell as if they were commands,
although they can also be called from any other program.
VxWorks debugging tools provide the following facilities:
.DS
\(bu Task-specific breakpoints
\(bu Task-specific single-stepping
\(bu Symbolic disassembler
\(bu Task and system information utilities
\(bu Symbolic task trace-back utility
\(bu Ability to call user routines
\(bu Ability to create and examine variables symbolically
\(bu Ability to examine and modify memory
\(bu Exception trapping
.DE
Each utility described in this chapter will also be found in the
.Ch Subroutines
section of the \f2VxWorks Reference Manual\fP
\(em each manual entry describes the calling
sequence and use of the command in detail.
Most of the utilities will be found in the subroutine libraries
.Mo usrLib ,
.Mo excLib ,
or
.Mo dbgLib .
Useful synopses of these libraries will also be found in the
.Ch Libraries
section of the reference manual.
.N 2 "On-Line Help"
.LP
An on-line help facility is available as a ``memory-jogger''.
Two commands to get help are:
.sp .5
.RS
.iP "help"
.br
Display help for user utilities.
.iP "dbgHelp"
Display help for debugging utilities.
.RE
.sp .5
.LP
You can get a list of all the help routines available by typing:
.sp .5
.RS
.Ci
-> lkup "Help"
.R
.RE

.N 1 "THE SHELL"
.LP
Since the VxWorks shell is an integral part of VxWorks' debugging
facilities, this section reviews the basics of using the shell.
For more detailed information, see the
.Ch SHELL
chapter.
.LP
The VxWorks shell provides a very powerful facility \(em the ability
to evaluate almost any C expression interactively.
This includes the ability to use data
variables and functions that are contained in the system symbol table.
Any command you type is interpreted as a C expression.  The shell
evaluates that expression and, optionally, assigns the result to a
data variable.
Some examples are:
.DS
.ta 2i
.Ci
-> 68	[1]
.Co
    value = 68 = 0x44 = 'D'
.Ci
-> (25 * 3) & 0x48	[2]
.Co
    value = 72 = 0x48 = 'H'
.Ci
-> myVar	[3]
.Co
    value = 115 = 0x73 = 's'
.Ci
-> myVar = func (12)	[4]
.Co
    value = ...
.Ci
-> newVar = 100	[5]
.Co
    new symbol newVar added to symbol table
    address = ...
    value = 100 = 0x64 = 'd'
.R
.ta
.DE
Examples [1] and [2] simply cause expressions to be evaluated and
the results displayed.  Example [3] looks up the value of
.Sy myVar
(which must be found in the system symbol table) and displays the value
contained there.
Example [4] calls the function
.Sy func
with a single parameter (12),
assigns the value returned to
.Sy myVar ,
and displays the value.
Example [5] creates a new variable
.Sy newVar ,
since it did not already exist, and assigns it the value 100.
.N 2 "What is a ``Command''?"
.LP
One way of using the shell's expression handling capability is
with simple expressions such as the following:
.DS
.Ci
-> func (x, y)
-> func x,y
.DE
These two lines are equivalent; the parentheses are optional.
In either case,
.Sy func
is called with two parameters, and the resulting
value is displayed on the console.
.LP
In fact, VxWorks provides many subroutines which are
.UL meant
to be called from the shell interactively.  These subroutines can be
thought of as ``commands'', rather than as subroutines, even though they
are, in fact, normal C subroutines.  All the ``commands'' discussed in
this chapter fall in this category.  When you see the word ``command'',
you can read ``subroutine'',
or vice versa, since their meaning here is identical.
.N 2 "Arguments to Commands"
.LP
Many of the commands described here accept one or more arguments.
These arguments, once again, can be arbitrary C expressions.  Some
examples:
.DS
.ta 1.5i
-> d (1000)	[1]
-> d 1000	[2]
-> d 0x1000	[3]
-> d dog	[4]
-> d &dog	[5]
-> d dog + 100	[6]
-> d func (dog)	[7]
-> d func	[8]
.ta
.DE
The command/subroutine
.Sy d
will display a block of memory
starting at the address which is passed to it as a parameter.
Example [1] and [2] will display starting at address 1000 decimal;
example [3] will display starting at 1000 hex.
Example [4] will start displaying at the address contained in the variable
.Sy dog ;
[5] will start at the address of
.Sy dog .
For example,  if
.Sy dog
is a data variable at location 0x1234,
and that memory location contains the value 10000,
.Sy d
would display starting at 10000 in example [4] and at 0x1234 in [5].
Example [6] will start displaying at 10100.
Example [7] will call the function
.Sy func
with the parameter 10000 and then call
.Sy d ,
passing it the value returned by
.Sy func .
Finally, example [8] will display the code of function
.Sy func
as a simple hex memory dump.
Notice that, just as in C,
symbols that refer to code (``text'' in UNIX jargon) evaluate to their
.UL address
if no parentheses are given, unlike data and
.Sy bss
variables, which evaluate to their contents.
.LP
Many of the commands described here take optional arguments.  The
shell
.UL always
passes exactly 10 arguments to any function it calls.  If there are
not that many typed on the command line, any arguments not typed are
passed as 0.  If none are typed, all 10 arguments are 0.  When
commands have optional arguments, some default is used when the
command receives 0 as an argument, which normally means that you
didn't type an argument to the shell.  For example:
.DS
.ta 1.5i
-> l func, 20	[1]
-> l func	[2]
-> l	[3]
.ta
.DE
The
.Sy l
command disassembles memory.
(The
.Sy l
command is described later in detail \(em see the
.Ch DISASSEMBLER
section.)  Example [1] will disassemble 20 instructions
in memory starting at the beginning of function
.Sy func .
Example [2] uses a default count, and will disassemble
however many instructions were specified on the previous
.Sy l
command (the default begins at a reasonable value, if you never give a count).
Example [3] uses a default address as well.  In this case, it will
disassemble starting at the instruction following the previous
.Sy l
command, or starting at the next instruction to be executed by a
task doing single-stepping, or starting at the last breakpoint or
exception trap that was hit.  It will use whichever of these is most
recent.  For example:
.DS
.ta 1.5i
.Co
    breakpoint in task 30 at 0x1234 = myFunc + 0x30
.Ci
-> l	[1]
-> l	[2]
-> l func	[3]
.ta
.R
.DE
Task 30 has hit a breakpoint.  Example [1] will disassemble
starting at 0x1234 until (let's say) 0x1250.  The next
.Sy l
[2] will begin at the following instruction (perhaps 0x1254).  Finally, [3]
will disassemble starting at the beginning of
.Sy func .
.N 2 "Aborting the Shell"
.LP
Occasionally you may find it necessary to abort the shell.
For example, if you call a routine that is not fully debugged, or with the
wrong parameters, or that waits on a semaphore that is not
forthcoming, you may hang forever.
In this case, abort the shell using \s-2CONTROL-C\s+2
(since the called routine is operating in the shell's task context).
.LP
When you abort the shell, a task trace (described in detail below)
is displayed, so you can find out
where you were when the abort key was hit.

.N 1 "TASK NAMES AND IDS, AND THE ``CURRENT'' TASK AND ADDRESS"
.LP
When a task is spawned, the user specifies a
.Sy "task name"
which is an ASCII string of arbitrary length.
The system returns a
.Sy "task ID"
which is an efficient 4-byte pointer to the task's data structures.
Task IDs are displayed with the
.Sy i
command .
.LP
Most VxWorks low-level task functions take the task ID as a parameter when
a task must be specified.
However, when invoking routines interactively,
specifying a task ID can be cumbersome since the ID is an arbitrary and
possibly lengthy number.
.LP
In general the debugging routines described in this chapter are intended
primarily for interactive use and are not speed critical.
Therefore, almost all can accept either a task
name
.I or
a task ID for a parameter that takes a task (usually described simply
as <task>).
These routines first try to interpret the value passed as a task ID, and if that
fails, then try to interpret the value as a task name.
.LP
Many commands
.Sy \f1(\fPc ,
.Sy cret ,
.Sy s ,
.Sy so ,
.Sy ti ,
.Sy tt )
have a task parameter which may be omitted.
If omitted, the ``current'' task is used.
There is also a current address that
.Sy l
and
.Sy d
use if no address is specified.
The current task and address are set when:
.RS
.IP \(bu .1i
A task hits a breakpoint or an exception trap.
The current address is
the address of the instruction that caused the break or exception.
.br
.IP \(bu .1i
A task is single-stepped.  The current address is the address of the
.UL next
instruction to be executed.
.br
.IP \(bu .1i
Any of the commands that use the
current task or address are executed with a specific task parameter.
The current address will be the address of the byte
.UL following
the last byte that was displayed or disassembled.
.RE

.N 1 "TASK AND SYSTEM INFORMATION"
.LP
The following commands are available to get information about the
state of the system and individual tasks:
.RS
.iP "i"
Info.  This command gives a snapshot of what tasks are in the system, and some
information about each of them, such as state, PC, SP, and TCB address.
.br
.iP ti [<task>]
Task info.
This command gives all the information contained in a task's TCB.  This includes
everything shown for that task by an
.Sy i
command, plus all the task's
registers, and the links in the TCB chain.  If <task> is 0 (or you
type nothing), the current task is reported on.
.br
.iP tt [<task>]
Task trace.
This command traces a task's stack, shows what routine the task is currently
executing, and how it got there.
.br
.iP checkStack [<task>]
Check stack usage.
This command displays a summary of a task's stack usage,
or of all tasks if <task> is omitted.
The summary includes the total stack size (SIZE), the current number
of stack bytes used (CUR), the maximum number of stack bytes used (HIGH), and
the number of bytes never used at the top of the stack
(MARGIN = SIZE - HIGH).
This routine is useful for determining how much stack space to allocate,
and for detecting stack overflow.
.RE
.N 2 "Task Trace"
.LP
Task trace shows the calling sequence that brought a task to its current
state.  For example:
.DS
.Ci
-> tt 30
.Co
.ta .5i 1i 2i
 1234	taskMain + 234:	routine1 (250, 10, 1234)
 2340	routine1 + 12c:	routine2 (5428, 1700, 1)
10110	routine2 +  10:	routine3 ( )
.ta
.R
.DE
This says that task 30 is currently executing
.Sy routine3,
which was called (with no parameters) by
.Sy routine2 .
The JSR (the actual machine language call) was at address 0x10110, which is
.Sy routine2\ +\ 0x10 .
.Sy Routine2
had been called by
.Sy routine1
(with three parameters) which had in turn been called by the task's main
routine.  The top of the trace
(the ``outermost'' call) will always be the task's main routine, since
when that routine returns, the task is deleted automatically.
.LP
Task trace does have some limitations.  It can only give routine names
if they are in the system symbol table.  It expects all routines to be
C compatible, and that each routine begins with a ``LINK A6''
instruction (which all routines in VxWorks do, and all routines
generated by the portable C compiler).
.LP
.Sy Tt
can also sometimes display the wrong number of arguments.  It
determines the number of arguments assuming the C compiler's standard
protocol, but the compiler occasionally does things slightly
differently for optimization purposes.
Such cases are rare.  Also, if the stack gets messed up,
.Sy tt
can become very confused.  If you suspect a stack crash,
you can check for a reasonable stack pointer with
.Sy ti
before doing a
.Sy tt .

.N 1 "BREAKPOINTS AND SINGLE-STEP"
.LP
The most versatile way to monitor and debug program execution is
to use breakpoints and single-stepping.
A breakpoint can be set at any instruction.  When that instruction is
executed by an eligible task (as specified with the
.Sy b
command), VxWorks
suspends the task that was executing and displays a message on the
console.  At this point, you can examine the task's registers, do a
task trace, etc.  The task can then be deleted, continued, or
single-stepped.  If you single-step a task, the task executes one
instruction, then VxWorks suspends the task again, and displays all the task's
registers and the
.UL next
instruction to be executed by the task.
.LP
The following commands are available for this purpose:
.sp .5
.RS
.iP b "<adr> [, <task> [, <n>]]"
Set a breakpoint for <task> at <adr>.
If <task> is not specified, the breakpoint is set for all tasks.
If <n> is specified, the break will not occur until the nth time
the breakpoint is hit by an eligible task.
.iP c "[<task>]"
Continue from a breakpoint or single-step.
The task continues execution, starting
with the instruction where the breakpoint was located.
If <task> is not specified, the current
task is continued.  If the task is not at a breakpoint, nothing
happens.
.iP cret "[<task>]"
Continue until return.
This routine places a breakpoint at the return address of the current
subroutine of the given task, then continues execution of that task.
When the breakpoint is hit, information about the task will be displayed
in the same format as in single-stepping.
The breakpoint will be
removed automatically when the breakpoint is hit, or if the task first
hits some other breakpoint.
If the task is missing or 0, the current task is assumed.
This is useful for examining return values.
.iP bd "<adr> [<task>]"
Delete a specific breakpoint.  If <task> is missing, the breakpoint will
be removed for all tasks.  If the breakpoint applies to all tasks,
removing it for just a single task will have no effect.  It must be
removed for all tasks, then set for just those tasks desired.
.iP bdall "[<task>]"
Delete all breakpoints for a task.  If <task> is missing, all
breakpoints for all tasks are removed.
.iP s "[<task>]"
Single-step a task that is suspended (at a breakpoint for instance).
The specified (or
current) task will execute one instruction, then display the task's registers
and the next instruction to be executed.
.iP so "[<task>]"
Single-step, but step over a subroutine.
This command single-steps a task that is suspended, but, if
the next instruction is a JSR or BSR, it breaks at the instruction following
the subroutine call instead.
This routine is useful to step over a subroutine,
rather than single-step all the way through it.
.RE
.N 2 "``Unbreakable'' Tasks"
.LP
A task can be set ``unbreakable'', in which case breakpoints that
otherwise would apply to that task are ignored.
Tasks are set ``breakable'' or ``unbreakable'' when they are spawned
or with the routine
.Sy vxSetTaskBreakable .
Several VxWorks tasks set themselves ``unbreakable'', including the shell,
the exception support task
.Sy \f1(\fPexcTask ),
and several network related tasks.
.N 2 "Spawning to Break"
.LP
There is an important distinction between routines that are executed
directly from the shell (by just typing their name) and routines that are
spawned as separate tasks (using
.Sy sp
or
.Sy taskSpawn ).
When executed directly from the shell, the routine operates in the shell's task
context, using the shell's stack, etc.  When a routine is spawned, it
gets its own task context, its own stack, and its own TCB.
.LP
It is not possible to place breakpoints or to single-step in the shell,
because, if you could,
all control of the system would be lost once the shell was suspended \(em
the shell is the tool that you use to execute commands.
This is important because when you execute a routine directly from the shell,
that routine executes in the shell's context.  VxWorks
.UL always
ignores breakpoints in the shell, or in routines invoked directly
from the shell.
.LP
To use breakpoints on a routine, that routine
.UL must
be spawned with its own context.  The easiest way to do this is with the
.Sy sp
command,
which spawns it with default parameters.
.LP
For example, if you have a routine called
.Sy hello
which consists solely of a call to
.Sy printf
to display ``Hello, there.'', you might enter the following sequence:
.DS
.ta 2.5i
.Ci
-> b printf	[1]
-> hello	[2]
.Co
    Hello, there.
.Ci
-> sp hello	[3]
.Co
    Break at 0x1234: _printf  Task: 250
.Ci
-> tt	[4]
.Co
     1234   hello + 1c: printf (1500)
.R
.ta
.DE
Command [1] sets a breakpoint at the beginning of the
routine
.Sy printf .
The first time
.Sy hello
is executed directly from the shell in [2],
the breakpoint is not encountered, since the routine is executing in the
shell's task context and the shell cannot be ``broken''.
When hello is spawned as a separate task with its own context in [3],
it does hit the breakpoint.
The task trace in [4] shows that the task is at the beginning of
.Sy printf ,
called from the main routine of
.Sy hello .
Note that
.Sy sp
spawns the task with an arbitrary task ID, in this case 250.

.N 1 "DISASSEMBLER"
.LP
VxWorks contains a Motorola-format symbolic disassembler.
The command to disassemble is:
.sp .5
.RS
.iP l "[<adr>[, <n>]]"
List <n> disassembled instructions, starting at <adr>.
If <n> is 0 or not given, the <n> from a previous
.Sy l
is used.
If <adr> is 0,
.Sy l
starts from where the previous
.Sy l
stopped, or from where an exception occurred,
if there has been an exception trap
or a breakpoint since the last
.Sy l
command.
.RE
.sp .5
.LP
The disassembler will use any symbols that are in the system symbol
table.  If an instruction whose address corresponds to a symbol is
disassembled (the beginning of a routine, for instance), the symbol is
shown as a label in the address field.  Symbols are also used in the
operand field.  The following is an example of disassembled code.
.DS L
.RS
.ta .5i 1i 1.5i 2i 2.7i 3.5i
.Co
				_printf:
.br
001234	4356	0000			LINK	A6,#0
.br
001238	2F39	0000	F21C		MOVE.L	_std_out, -(A7)
.br
00123E	4EB9	0000	1478		JSR	_fioFormat
.ta
.RE
.DE
This example shows the beginning of the
.Sy printf
routine (somewhat abbreviated).  The routine does a LINK, then pushes the
value of
.Sy std_out
onto the stack and calls the routine
.Sy fioFormat .
Notice that any
symbols defined in C (routine and variable names) have an ``_''
prepended by the compiler.

.N 1 "EXCEPTION TRAPS"
.LP
VxWorks traps all exceptions which can be generated by the 680x0 series CPU.
These include bus and address errors, illegal instruction traps,
divide by zero, etc.  When one of these is encountered, VxWorks displays
a message on the console terminal and simply suspends the task that was
executing when the exception occurred.  The rest of the system,
including other application tasks and the shell, goes on running as usual.
.LP
Usually, in order to find out where the task was when it bombed, the first
thing to do is a task trace.  Often, you'll find enough
information there to pinpoint the problem quickly (a routine called
with insufficient arguments, or illegal arguments, for instance).
.LP
Once a task has died in this fashion, it is usually not practical to
continue the task.
When you are through examining the task's data, registers, stack, etc.,
you can either delete the task (using
.Sy td )
or restart it (using
.Sy taskRestart ).
If you delete it, it can be restarted later by spawning, if so desired.
.LP
If the shell, or any routine which you call directly from the shell,
generates an exception, it is treated specially.
This is because you will lose control of the system
if the shell is suspended.
If this happens, a task trace of the shell is displayed automatically
and the shell is restarted.
At this point, the best course of action is
probably to spawn the offending routine as a separate task, and debug
it in a context of its own.

.N 1 "MISCELLANEOUS USEFUL UTILITIES"
.LP
In the course of debugging, there are many utilities which are useful,
even though they may not be functions that are normally considered
part of a debugger.
.N 2 "Task Control"
.LP
You can find the current state of a task with the
.Sy i
or
.Sy ti
commands.  In order to change that state, you can use one of the following:
.sp .5
.RS
.iP ts "<task>"
Suspend a task.
.iP tr "<task>"
Resume a suspended task.
.iP td "<task>"
Delete a task.
.sp .5
.RE
.LP
The normal way of starting tasks is with the following commands.
See
.Mo vxLib(1)
for details.
.sp .5
.RS
.iP "id = taskSpawn" "\ <name>, <priority>, <options>, <stack size>, <entry adrs> [, <arg1>, ... <arg10>]"
Spawn a C routine as a task.
.iP sp "<entry address> [, <arg1>, ... <arg10>]"
Spawn a C routine as a task, with default parameters.
.RE
.sp .5
.LP
Normally, <entry address> would be symbolic, as in:
.DS
.Ci
-> sp myFunc, 10
.DE
This would spawn the C routine
.Sy myFunc
as a task, and pass it the parameter 10.
.N 2 "Task Error Status Values"
.LP
Each task has an ``error status'' value, which is an integer value that
reflects any system errors that may have occurred during task execution.
To see a task's status, type
.Sy i
(for ``info'') from the shell and look in the ERRNO column for the
hexadecimal status value.
.LP
The following command is useful for translating status values to more
human-readable error messages:
.sp .5
.RS
.iP "printErrno"
Display the message for a given status value.
.RE
.sp .5
.LP
See the manual entry on
.Mo stsLib(1)
for more details.
.N 2 "Memory Information"
.LP
The following command gives information about the current state of memory usage:
.sp .5
.RS
.iP "memShow"
This routine prints to standard output
the total amount of free and allocated space
in the memory pool, the number of free and allocated fragments, the average
free and allocated fragment sizes, and the maximum free fragment size.
Current as well as cumulative values are given.
.RE
.N 2 "Display and Modify Memory"
.LP
Two commands are available to examine and modify the contents of memory:
.sp .5
.RS
.iP d "[<adr>]"
Display memory in hexadecimal and in ASCII format.  The
.Sy d
command displays a block starting from <adr>, which can be a number, variable,
routine, etc.
For example:
.DS
-> d\ &myStructure
.DE
would display memory
starting with
.Sy myStructure
(which must be in the system symbol table).
The command
.Sy d ,
with no arguments, displays the next memory block, starting from where the last
.Sy d
completed.
.iP m "<adr>"
Modify memory.
The
.Sy m
command displays successive words in memory on the terminal; you
change each word by typing a new hex value,
leave the word unchanged and continue by typing \s-2RETURN\s+2,
or return to the shell by typing a ``.''.
.RE
.N 2 "Display and Modify Registers"
.LP
Several commands are available to examine and modify register contents.
If no task ID is passed to these subroutines, then the current task ID is used.
.sp .5
.RS
.iP a\fRn "[<task ID>]"
Return the contents of address register number \fIn\fP.
The commands
.Sy a0
through
.Sy a7
are available.
.iP d\fRn "[<task ID>]"
Return the contents of data register number \fIn\fP.
The commands
.Sy d0
through
.Sy d7
are available.
.iP sr "[<task ID>]"
Return the contents of the task's status register.
.iP pc "[<task ID>]"
Return the contents of the task's program counter.
.iP mRegs "[<task ID>]"
Modify registers.
The
.Sy mRegs
command sequentially prompts the user for new values for a task's registers
starting with d0.  All numbers are entered and displayed in hex.
.RE
.N 2 "Symbol Look-up"
.sp .5
.RS
.iP lkup "<string>"
Display a list of all symbols in the system symbol
table whose names contain <string>.  For example, the command:
.DS
-> lkup "dsm"
.DE
would display a list containing
.Sy dsmData ,
.Sy dsmInst ,
.Sy dsmNbytes ,
.Sy dsmNwords ,
.Sy dsmPrint ,
.Sy dsmFind ,
and any other declared variables containing the string ``dsm''.
Case is significant, but position is not
.Sy \fR(\fPmydsm
would be shown,
.Sy myDsm
would not).
.RE
.N 2 "Repeat and Period"
.LP
Sometimes it is useful to set up a routine to run repetitively.
Two commands are available to do this:
.sp .5
.RS
.iP repeat "<n>, <func>, [<arg1>, ..., <arg8>]"
Spawn a task that calls function <func>, <n> times, with the specified
arguments.  There will be no delay between calls.
.iP period "<secs>, <func>, [<arg1>, ..., <arg8>]"
Spawn a task that calls function <func>, with the specified arguments,
every <secs> seconds.
.RE
.sp .5
.LP
These commands spawn tasks \(em called
.Sy "repeatRun"
and
.Sy "periodRun"
\(em that you can see with the
.Sy i
command.  The tasks may be controlled or stopped as described previously under
.Ch "Task Control" .

.N 1 "TIPS"
.LP
Debugging with an environment as rich as VxWorks is difficult to
describe in a cut-and-dried fashion.  Inevitably, each user will come
up with his or her own way of doing things.  The following are simply
some useful tips, for starters.
.N 2 "The ``i'' Command"
.LP
The
.Sy i
command is perhaps the most commonly used command to get a quick idea
of what's going on.  By spawning it as a task that runs periodically
(using
.Sy period ),
you can set up the shell's terminal to show status
every few seconds.  If nothing seems to be happening,
.Sy i
is usually the best place to start.
.N 2 "Where to Set Breakpoints"
.LP
Although breakpoints can be set anywhere, the most common place to
start is generally at the beginning of a subroutine.
For example, if you want to check quickly whether a particular
routine,
.Sy square ,
is working properly, you might execute the following sequence of commands:
.sp .5
.DS
.ta 3i
.Ci
-> b square	[1]
.Co
    value = 0

    break at 0x1234: _square  Task: 252
.DE
.DS
.ta 3i
.Ci
-> tt	[2]
.Co
    1010: spnTsta + 0x10    myTask ()
    2468: myTask + 0x3f0   square (0c)
    value = 0
.Ci
.DE
.DS
.ta 3i
-> cret	[3]
.Co
    value = 0

    break at 0x246c: myTask+0x3f0  Task: 252
.ta .8i 1.3i 1.8i 3i
    D0=90	D1=...	D2=...	D3=...
    ...
    A5=...	A6=...	A7=...	A8=...
    SR=4	PC=1000	Task: 252
    ...		ADDA.L	#$002C, A7
.ta 3i
.Ci
.DE
.DS
.ta 3i
-> 0x90	[4]
.Co
    value = 144 = 0x90
.Ci
.DE
.DS
.ta 3i
-> c	[5]
.Co
    value = 0

    break at 0x1234: _square  Task: 252
.Ci
.DE
.DS
.ta 3i
-> bdall	[6]
.Co
    value = 0
.Ci
.DE
.DS
.ta 3i
-> c	[7]
.Co
    value = 0
.ta
.R
.DE
.LP
Step [1] sets a breakpoint at the beginning of routine
.Sy square .
If there is some task running that will call
.Sy square ,
the breakpoint will be hit.
An immediate task trace [2] shows how
.Sy square
was called: with a parameter of 12 (0x0c).
Step [3] is a return of
.Sy square
which hits a breakpoint, and displays the
registers exactly as if it had been a single-stepped task.
Since the C calling convention on the 680x0 series is to return a function
value in D0, you can see that
.Sy square
returned a value of 0x90.
Since you really want a decimal value,
you convert using the shell as in step [4].
Since 12**2 = 144,
.Sy square
seems to work properly.
Continuing the task,
you call
.Sy square
again in step [5], causing a breakpoint.
Since presumably you're now satisfied that
.Sy square
is working properly,
you delete the breakpoint in step [6] and continue again in [7].
.N 2 "Stack Crashes"
.LP
VxWorks provides no protection against stack crashes.
Such crashes occur
when a task uses more stack than has been allocated for it, thus
running into and writing over some other task or data.
It generally manifests
itself as a crash of some task other than the offending one,
or other inexplicable behavior.
.LP
Before VxWorks starts a task (via
.Sy sp
or
.Sy taskSpawn ),
it writes 0xeeee
over the entire stack allocated to that task.  You can tell whether a
task has ever overrun its stack (or how much stack the task has ever
used) by calling
.Sy checkStack .
If the stack has overflowed or come close to it, spawn the task again
with a bigger task size.
.N 2 "System Crashes, or ``Power Corrupts''"
.LP
The VxWorks system does little to restrain tasks from global
damage to the system or other tasks.
This offers the advantage of speed, simplicity,
and ability to run on low-level hardware.
However, any task can crash the entire system, quickly and totally.
A few of the possible ways to do this are:
.RS
.IP \(bu .1i
Overwriting the code, data, or stack of some other task
(or even of the system or shell).
.IP \(bu .1i
Overwriting interrupt vectors in low memory.
.IP \(bu .1i
Taking an important semaphore and never returning it.
.IP \(bu .1i
Operating at a high priority (or with interrupts locked out) and never
relinquishing the CPU.
.RE
.LP
If the system is crashing in such a way that you are losing control of
it (no response from the shell, I/O messed up, etc.),
the best plan of attack is to reboot the system and work ``forwards'',
setting some breakpoints and trying to localize the problem that way.
.LP
Alternatively, even after VxWorks dies, you may still be able to get
to the ROM monitor (depending on your hardware system) by typing
\s-2CONTROL-X\s+2.  Debugging from there is primitive,
but possible.  If this doesn't work, it means either
that interrupts are locked out, the console's interrupt vector has been
overwritten, or the serial driver's code has been overwritten.
.N 2 "Source Language Debugging"
.LP
It is possible to debug VxWorks target processes using a C source language
debugger running on the UNIX host.  Packages are available for using a
special version of
.Sy dbxtool
from Sun or
.Sy cdb
from Third Eye Software.
For more information, see the relevant application notes, or contact
Wind River directly.
.TO
