.WP "Cross-Development" VxWorks 4.00
.TL
VxWORKS CROSS-DEVELOPMENT
.N 1 "INTRODUCTION"
.LP
VxWorks provides a highly integrated cross-development environment.
In VxWorks,
UNIX-based development systems support the development and maintenance
of real-time applications that run on target systems under the
VxWorks operating system.
This chapter describes in detail the cross-development procedures
used to create and run VxWorks systems and applications.
It covers the following topics:
.RS
.IP \\(bu .15i
The nature of the VxWorks cross-development environment.
.IP \\(bu
How to build, load, and run applications under VxWorks.
.IP \\(bu
How to build VxWorks system images.
.IP \\(bu
VxWorks configuration options and parameters.
.RE
.LP
VxWorks has been ported to numerous development and target systems,
and can support many different hardware configurations.
Some of the cross-development procedures discussed in this chapter
depend somewhat on the exact system and configuration you are running.
The procedures in this chapter are presented in generic form,
and may differ slightly on your particular system.

.N 1 "THE VxWORKS CROSS-DEVELOPMENT ENVIRONMENT"
.LP
All VxWorks facilities are based on a single simple construct:
the C subroutine (or C compatible subroutine).
.RS
.IP \\(bu .15i
All VxWorks facilities are provided by libraries of C subroutines.
.IP \\(bu
Any C subroutine can be invoked interactively, using the VxWorks shell.
.IP \\(bu
Any C subroutine can be spawned as a VxWorks task.
.IP \\(bu
Any C subroutine can be connected to an interrupt, a watchdog timer,
or an auxiliary timer.
.RE
.LP
This uniformity makes VxWorks a very efficient development system.
No special code must be written to interface to ``system traps''.
No special processing is required to ``build'' a task.
No special user interface programs or interactive test-bed programs
must be written to test new code.
.LP
Instead, you simply write subroutines.
As usual, of course, they can be called from other
program modules to perform their function.
But they can also be called interactively, from the shell,
to perform their function spontaneously as needed, for testing or debugging.
They can be spawned with their own task context,
either from another program module or interactively from the shell.
They can be connected to interrupts or timers,
again either from another program module or interactively from the shell.
.LP
To provide this elegant environment, VxWorks has a key set of facilities
that set up the appropriate program environment to call subroutines
in particular contexts: the
.Sy taskSpawn
routine establishes the environment necessary for a routine to be executed
as a task;
and the routines
.Sy intConnect ,
.Sy sysAuxClkConnect ,
and
.Sy wdStart
establish the environment necessary for routines to be executed as the result
of hardware interrupts, an auxiliary timer, and watch-dog timer expirations,
respectively.
Perhaps the most significant facility for the development environment
is the VxWorks shell, from which users can interactively call any routine.
This is made possible by the
.I "system symbol table"
which is maintained by the VxWorks module loader.

.N 1 "THE MODULE LOADER AND THE SYSTEM SYMBOL TABLE"
.LP
VxWorks includes a module loader which loads object modules from
the host over a network or from a local disk into memory.
These object modules are in UNIX standard object module format
(``a.out''),
which includes the code, data, relocation directives, and a symbol table
containing all of the module's subroutine and variable names and addresses.
When loading an object module, the VxWorks loader performs the following
functions:
.RS
.IP \(bu .15i
Loads the module's code and data segments into memory.
.IP \(bu
Relocates the module according to the relocation directives
in the object module.
.IP \(bu
Resolves external references from the memory-resident system symbol table.
.IP \(bu
Optionally, adds the module's symbols to the system symbol table.
.RE
.LP
The system symbol table thus contains the subroutine and variable names,
and their addresses, from all loaded program modules,
including VxWorks modules themselves.
The system symbol table then gives run-time access to subroutine
and variable addresses by name.
.sp .5
.N 2 "Run-Time Linking"
.LP
VxWorks makes heavy use of the system symbol table.
First, the module loader uses it to resolve undefined symbols
in modules being loaded.
This
.UL "run-time linking"
allows applications to be built and maintained
in conveniently sized pieces, rather than requiring the entire
application to be linked together into a single module.
Furthermore, run-time linking makes it easy to have genuinely
.UL shared
subroutine libraries, in which a single copy of a set of subroutines
may be used by several tasks, rather than requiring each task to be
linked with separate copies of needed subroutines.
.LP
However, there is the following limitation:\ \ the loader can only resolve
names that have
.UL already
been loaded in previous modules.
Thus, modules must be loaded in order, according to their hierarchy of
routine and variable references.
.LP
Of course, you may link some modules together on your host system,
rather than have them linked by the VxWorks loader.
This may be necessary if two modules cross-reference each other,
prohibiting the hierarchical loading order mentioned above.
In some cases, it may also prove more convenient to link some modules together,
rather than loading each module separately under VxWorks.
Linking modules together on the host does not sacrifice their
accessibility under VxWorks in any way, since the UNIX linker retains all the
symbols of each module in the resulting composite symbol table.
.sp .5
.N 2 "Symbolic Debugging"
.LP
The other important use of the system symbol table is to provide interactive
run-time access to routine and variable names.
In particular, the VxWorks shell allows you to interactively call any
subroutines and access any variables entered in the system symbol table.
This is particularly useful during symbolic and source-level debugging.
For example, VxWorks offers symbolic disassembly of any loaded modules
and symbolic trace-back of the current sequence of subroutine calls of any task.
You can also debug tasks from a source-level debugger running remotely on
a UNIX machine.

.N 1 "BUILDING AND LOADING APPLICATION MODULES"
.LP
In the VxWorks development environment,
application modules for the target system are created and maintained
on a UNIX host system.
First, the source code, generally in C (or in a C-compatible language),
is edited and compiled in the usual way.
The resulting object modules can then be loaded and dynamically linked
by a running VxWorks system via the network.
The following sections describe these cross-development procedures in detail.
.sp .5
.N 2 "Compiling Application Modules"
.LP
On a 680x0 based UNIX host, application modules are compiled using
the native C compiler.
(On non-680x0 based hosts, a cross-compiler is used in a similar way.)
\ The following is a typical command for compiling an application module for
a VxWorks system:
.DS
.Ci
cc -c -I/usr/vw/h -O applic.c
.DE
This will compile the module
.Mo applic.c .
The ``-c'' flag specifies that the module is to be compiled only, and not linked
for execution under UNIX.
The output is an unlinked object module with a ``.o'' suffix,
in this case
.Mo applic.o .
The ``-I/usr/vw/h'' flag gives access to the VxWorks include files.
The ``-O'' flag tells the compiler to perform various optimizations.
.sp .5
.N 2 "Using VxWorks Include Files"
.LP
Many application modules will make use of VxWorks' operating system facilities
or utility libraries.
This may require that the source module include various VxWorks include files.
The following sections discuss the use of VxWorks include files.
.N 3 "vxWorks.h"
.LP
The include file
.Mo /usr/vw/h/vxWorks.h
contains many basic definitions and
types that are used extensively by other VxWorks modules.
Many other VxWorks include files require these definitions,
so this file should be included first by every application module that will
use VxWorks facilities.
The
.Mo vxWorks.h
file is included in a source module with the following line:
.DS
.Ci
#include "vxWorks.h"
.DE
.N 3 "Other VxWorks Include Files"
.LP
Application modules may include other VxWorks include files as needed to
access VxWorks facilities.
For example, an application module that used VxWorks linked-list subroutine
library would need to include the
.Mo lstLib.h
file with the following line:
.DS
.Ci
#include "lstLib.h"
.DE
Each library manual entry lists any include files that are necessary to
use that library module.
.N 3 "UNIX Include Files"
.LP
Application modules should
.UL not
include certain UNIX include files for which there are VxWorks equivalents.
The following table shows the correspondence between UNIX and VxWorks
include files.
.sp .5
.TS
center,box;
cp11fB s
afB    afB
a      a .
.sp .25
Include File Equivalents
.sp .25
_
VxWorks	UNIX
_
.sp .25
a_out.h	a.out.h
ctype.h	ctype.h
errno.h	errno.h
in.h	in.h
ioctl.h	ioctl.h
memLib.h	malloc.h
setjmp.h	setjmp.h
socket.h	socket.h
stdioLib.h	stdio.h
strLib.h	string.h
types.h	types.h
.sp .25
.TE
.N 3 "The -I Compiler Flag"
.LP
By default, the compiler will search for include files first in the directory
of the source module and then in the
.Mo /usr/include
directory.  In order to access the VxWorks include files, the
compiler must be directed to also search
.Mo /usr/vw/h
for include files.  This is done by specifying the ``-I/usr/vw/h'' flag
to the compiler.
.N 3 "VxWorks Nested Include Files"
.LP
Some VxWorks facilities make use of other, lower-level VxWorks facilities.
For example, the watchdog timer facility uses the linked-list
subroutine library.
The watchdog timer include file
.Mo wdLib.h
uses definitions that are supplied by the linked-list include file
.Mo lstLib.h .
Thus
.Mo lstLib.h
must be included before
.Mo wdLib.h .
.LP
It would be undesirable to require that the application programmer know of
such include file interdependencies and orderings.
Instead, all VxWorks include files explicitly include any other
prerequisite include files.
Thus
.Mo wdLib.h
itself contains an include of
.Mo lstLib.h .
(The exception to this is the basic VxWorks include file
.Mo vxWorks.h
which all other include files assume is already included.)
.LP
This, in turn leads to the problem that an include file could get included
more than once, if one were included by several other include
files, or was also included directly by the application module.
Normally, including an include file more than once will generate fatal
compilation errors, because definitions get made more than once.
To solve this problem, all VxWorks include files contain conditional
compilation statements and definitions that ensure that their text only
gets included once, no matter how many times they are included
by include statements.
.LP
The net result of all this is that an application module can include
just those include files it actually needs,
without regard to interdependencies or ordering,
and no conflicts will arise.
.N 3 "Network Include Files"
.LP
In addition to the general include files in \fB/usr/vw/h\fP, the VxWorks
network modules use a set of internal include files in \fB/usr/vw/h/net\fP.
These include files should
.UL not
be required by any application programs.
Other than the VxWorks network modules themselves, the only modules that
should include headers from \fB/usr/vw/h/net\fP are the network drivers
for specific network controllers.  \fB/usr/vw/h\fP also contains a
subdirectory called \fBrpc\fP, which contains header files that
must be included by applications using the remote procedure call library.
.N 3 "``Hidden'' Parts of VxWorks Include Files"
.LP
VxWorks modules are designed so that users never need to
know or reference the modules' internal data structures.
In general, all legitimate access to a facility is provided by
the module's subroutine interfaces.
The internal details should be thought of as ``hidden'' from the user.
This means, in fact, that the internal implementations can change without
affecting the users of the facilities.
.LP
Unfortunately, the C language provides no mechanisms to ``export' only
the ``visible'' portions of a module's interface, while keeping
the internal details ``hidden''.
As a compromise, however,
VxWorks include files designate with comments those definitions
and declarations that are supposed to be hidden.
The hidden portions of include files are bracketed by
comment lines of the form:
.DS
.Ci
/* HIDDEN */

 ...

/* END_HIDDEN */
.DE
.LP
Users should never make any references to any of the definitions in these
``hidden'' sections,
nor should any assumptions be made based on those definitions.
The only acceptable use of a module's facilities
is through the ``visible'' definitions in the include file
and the module's subroutine interfaces.
.LP
Although this rule is not currently enforced in any way,
adherence will ensure that your application code will not
be affected by ``internal'' changes in the implementation of a VxWorks module.
.sp .5
.N 2 "Linking an Application Module"
.LP
After an application module has been compiled, it can be loaded directly
by the VxWorks linking loader.
In general, application modules do not need to be linked with the UNIX linker,
.To ld .
However, using
.To ld
may be necessary if several application modules cross reference
each other such that the VxWorks loader cannot resolve all the external
references as each is loaded.
The following is a typical UNIX command to link several cross-referencing
application modules:
.DS
.Ci
% ld -o applic.o -r applic1.o applic2.o applic3.o
.DE
This will create another object module,
.Mo applic.o ,
from the object modules
.Mo applic1.o ,
.Mo applic2.o ,
and
.Mo applic3.o .
The ``-r'' flag causes the resulting object module to be left in
relocatable form.
.LP
Note that any VxWorks facilities called by
the application modules will be reported by
.To ld
as unresolved externals.
These will be resolved by the VxWorks loader when the module is loaded into
VxWorks memory.
Do
.UL not
link each of the application modules with the VxWorks libraries.
That would defeat the load-time linking feature of VxWorks, causing there
to be multiple copies of VxWorks system modules.
.sp .5
.N 2 "Loading an Application Module"
.LP
Once application object modules have been compiled
(and possibly linked by
.To ld ),
they can be loaded by a running VxWorks system via the network.
This involves invoking the VxWorks module loader with the command
.Sy ld
from the VxWorks shell.
(This is \fInot\fP the same as the UNIX
.To ld
command discussed above.)
.LP
The following is a typical VxWorks ``load'' command to the VxWorks shell:
.DS
.Ci
-> ld < host:/usr/fred/applic.o
.DE
This will cause the object module
.Mo /usr/fred/applic.o
on the system ``host'',
to be loaded into memory, relocated, and linked to previously loaded modules.
It is common to set the current default I/O device to be the host file system
and directory containing your application modules, as follows:
.DS
.Ci
-> cd "host:/usr/fred"
.DE
Then the load command becomes just:
.DS
.Ci
-> ld <applic.o
.DE
.LP
Once application modules have been loaded into memory, any subroutine
in the module can be invoked directly from the shell,
spawned as a task, connected to an interrupt, etc.

.N 1 "BUILDING A VxWORKS SYSTEM IMAGE"
.LP
A VxWorks system image is a binary module that can be booted and run on a
target system.
A system image consists of all the desired system object modules
linked together into a single non-relocatable object module
with no unresolved external references.
.LP
The VxWorks distribution files include a linked, bootable system object module.
Initially, you will probably find this system entirely adequate for development.
Eventually you will probably want to tailor the configuration of the
bootable system for your own needs.
.sp .5
.N 2 "Rebuilding VxWorks with \fImake\fP"
.LP
The configuration of VxWorks is determined by several source files described in
the section ``Configuring VxWorks'' below.
If any of these files are modified to alter the configuration,
VxWorks must be rebuilt.
This includes re-compiling certain modules and re-linking the system image.
VxWorks uses to the UNIX
.Sy make
facility to re-compile and re-link modules.
A
.Mo Makefile
is provided in each VxWorks target directory
that contains the directives for rebuilding VxWorks for that target.
(See the UNIX manual entry for
.Sy make
for more information on Makefiles.)
.LP
To rebuild VxWorks using
.Sy make ,
first change directory to the VxWorks target directory for the desired target,
and invoke
.Sy make :
.DS
.Ci
% cd vw/config/<target>
% make
.DE
.LP
.Sy make
will re-compile and re-link modules as necessary,
as determined by the directives in
.Mo Makefile
in that target directory.
.sp .5
.N 2 "Linking the System Modules"
.LP
The UNIX commands to link a VxWorks system image are somewhat complicated.
Fortunately, it is not necessary to understand those commands in detail
since the
.Mo Makefile
in each VxWorks target directory includes the necessary commands.
However, for completeness,
this section gives an explanation of the flags and parameters used by VxWorks.
.LP
Most of the VxWorks operating system modules are distributed in the form of
UNIX archive libraries including
.Mo vxWorks.a ,
.Mo network.a ,
.Mo vxConfig.a ,
etc.
There is a complete set of these libraries for each different type of
target CPU supported by VxWorks, in the VxWorks directory
.Mo vw/lib/<target> .
.LP
These modules are combined with the configuration module
.Mo usrConfig.o
by the UNIX linker
.To ld .
(The
.Mo usrConfig
module is described in a subsequent section.)
\ The following is a typical command for linking a VxWorks system:
.DS
.Ci
ld -o vxWorks -X -N -T 1000 -u _ls -e _sysInit
       sysALib.o sysLib.o tyCoDrv.o usrConfig.o version.o
       /usr/vw/lib/68020/vxWorks.a /usr/vw/lib/68020/vxConfig.a
       /usr/vw/lib/68020/network.a /usr/vw/lib/68020/rpclib.a
       /usr/vw/lib/68020/wind.a /lib/libc.a
.DE
The meanings of the flags on this command are as follows:

.IP "-o vxWorks"
.br
This causes the resulting object module to be named ``vxWorks''.

.IP "-X"
.br
This flag causes certain compiler generated symbols to be
eliminated from the symbol table.

.IP "-N"
.br
This flag causes the resulting object module not to be configured for a virtual
memory system.

.IP "-T 1000"
.br
This flag specifies the relocation address, in this example 1000 hex.
This is the address at which the system must be loaded in the target,
and is also the address at which execution will start.
Some target systems may have limitations on where this relocation
address can be.

.IP "-u _ls"
.br
This flag forces the loader to make the symbol ``_ls'' undefined.
This mechanism is used to include the
.Mo usrLib
module in the
.Mo vxWorks
object module, and can
be used to force the loader to include user application modules.
This may be desirable, for example, to include routines that will be invoked
interactively from the VxWorks shell, or that will be required by application
modules that will be loaded after booting VxWorks.
The linker will treat a symbol named in a ``-u'' option as an undefined
external reference, and will try to resolve it during the library searches.

.IP "-e _sysInit"
This flag defines the entry point to
.Mo vxWorks .
Note that
.To sysInit
is the first routine in
.Mo sysALib.o ,
which is the first module loaded by
.To ld .

.IP "sysALib.o and sysLib.o"
.br
These are modules with CPU-dependent initialization and support routines.
The module
.Mo sysALib.o
.UL must
be the first module specified in the
.To ld
command.

.IP "tyCoDrv.o"
.br
This is the CPU-specific console I/O driver.

.IP "usrConfig.o"
.br
This is the configuration module described in detail in a section below.
If you have several different system configurations,
you may have several different configuration modules, either in
.Mo /usr/vw
or in your own directory.

.IP "version.o"
.br
This module contains data structures which define the creation date
and version number of this vxWorks object module.
It is created by compiling the output of
.To makeVersion.

.IP "/usr/vw/lib/68020/vxWorks.a"
.br
This is the archive format library that contains all the system independent
VxWorks modules, in this case for 68020 based target systems.
This library will be searched, and the necessary VxWorks modules included,
to satisfy the external references of the
.Mo usrConfig
module.

.IP "/usr/vw/lib/68020/vxConfig.a"
.br
This is the archive format library that contains all the I/O drivers
and user-alterable VxWorks modules.
This library will be searched, and the necessary VxWorks modules included,
to satisfy external references.

.IP "/usr/vw/lib/68020/network.a"
.br
This archive contains all of the vxWorks network support code.

.IP "/usr/vw/lib/68020/rpclib.a"
.br
This archive contains the Remote Procedure Call library.

.IP "/usr/vw/lib/68020/wind.a"
.br
This archive contains the VxWorks kernel.
.sp .5
.IP "/lib/libc.a"
.br
This is the C run-time library.
This library will be searched, and necessary routines included, to satisfy
remaining unresolved references.
Typically, this will include some C arithmetic support routines
(i.e. for floating point arithmetic).
The
.Mo /lib/libc.a
.UL must
come after the VxWorks libraries.
Otherwise, some UNIX routines will be linked in instead of VxWorks routines with
identical names (the I/O library, for instance).
.sp .5
.IP "Additional object modules:"
.br
Additional object modules (with ``.o'' suffix) can be linked in with the
VxWorks system simply by naming them on the
.To ld
command.
Note that during development, application object modules are generally
.UL not
linked with the system unless they are needed by the
.Mo usrConfig
module since they may be incrementally loaded after VxWorks is booted.
See the section
.Ch "Alternative Configurations"
for more detail
on linking application modules in a bootable system.
.sp .5
.N 2 "Creating the System Symbol Table Module"
.LP
In a standard VxWorks configuration, part of the initialization
procedure is for VxWorks to read its own symbol table, so system
symbols will be available to applications loaded later, and from the
shell.  The symbol table file is created by a program called
.To xsym
that is supplied with VxWorks.
Processing an object module with
.To xsym
creates a new object module that contains all the symbols of the
original file, but with no code or data.
The line in
.Mo Makefile
that creates this file is:
.DS
.Ci
xsym < vxWorks > vxWorks.sym
.DE
The new file
.Mo vxWorks.sym
will be the symbol table loaded during VxWorks initialization.

.N 1 "CONFIGURING VxWORKS"
.LP
VxWorks has many options and parameters that
can be specified to tailor the system to particular hardware and software
requirements.
The configuration of VxWorks is almost completely determined by a
single C language module,
.Mo usrConfig.c ,
which contains the VxWorks start-up routines,
and by the configuration headers
.Mo configAll.h
and
.Mo config.h
which contain definitions of selected options and parameters.
.LP
The VxWorks distribution includes the configuration files for the default
development configuration.
Application builders can alter these files, or create their own versions,
to better suit their particular configurations.
VxWorks can then be rebuilt using the procedures described in the
section above
.Ch Building a VxWorks System Image .
This section describes the VxWorks configuration files in detail.
.sp .5
.N 2 "The Configuration Headers"
.LP
Many of the most common VxWorks configuration options and parameters are
controllable by definitions in the global configuration header
.Mo vw/config/all/configAll.h
and in the target-specific configuration header
.Mo vw/config/<target>/config.h .
.N 3 "The Global Configuration Header: \fIconfigAll.h\fP"
.LP
The
.Mo configAll.h
header, in the directory
.Mo vw/config/all ,
contains default definitions that apply to all targets, unless redefined
in the target-specific header
.Mo config.h .
The following options and parameters are defined in
.Mo configAll.h :
.DS
\\(bu kernel configuration parameters
\\(bu I/O system parameters
\\(bu NFS parameters
\\(bu selection of optional software modules
\\(bu selection of optional device controllers
\\(bu device controller I/O addresses, interrupt vectors, and interrupt levels
\\(bu trap numbers to be used by VxWorks
\\(bu miscellaneous addresses and constants
.DE
.N 3 "The Target-Specific Configuration Header: \fIconfig.h\fP"
.LP
There is also a target-specific header,
.Mo config.h ,
in the target-specific VxWorks directory
.Mo vw/config/<target> .
This header contains definitions that apply just to that specific target.
This header may also re-define default definitions in
.Mo configAll.h
that are inappropriate for the particular target.
For example, if a particular target cannot access a device controller at
the default I/O address defined in
.Mo configAll.h
because of addressing limitations, the I/O address may be re-defined in
.Mo config.h .
.LP
The
.Mo config.h
header includes definitions for the following parameters:
.DS
\\(bu default boot parameter string for boot ROMs
\\(bu interrupt vectors for system clock and parity errors
\\(bu target-specific device controller I/O addresses, interrupt vectors, interrupt levels
\\(bu backplane network parameters
\\(bu miscellaneous memory addresses and constants
.DE
.N 3 "Selection of Optional Features"
.LP
VxWorks includes optional features and optional device drivers
that can be included or omitted from a VxWorks system.
These are controlled by special symbols that can be defined
in the configuration headers, that cause conditional compilation in the
.Mo usrConfig
module.
These symbols all start with the prefix ``INCLUDE_''.
The following table lists the optional modules and their control symbols.
.sp .5
.TS
center,box;
cp11fB s
afB    afB
a      a .
.sp .25
Selectable Modules
.sp .25
_
Symbol	Module
_
.sp .25
INCLUDE_ADA	Ada support
INCLUDE_DBX	dbx source-language debugger support
INCLUDE_DEBUG	native debugging
INCLUDE_FLOATING_POINT	floating point I/O
INCLUDE_MC68881	MC68881/2 floating point coprocessor support
INCLUDE_NFS	Network File System
INCLUDE_RAMDRV	ram disk driver
INCLUDE_RLOGIN	remote login with \fIrlogin\fP
INCLUDE_RPC	Remote Procedure Calls
INCLUDE_RT11	RT-11 file system
INCLUDE_SPY	task activity monitor
INCLUDE_STDIO	standard I/O package
INCLUDE_TELNET	remote login with \fItelnet\fP
INCLUDE_TIMEX	function exececution timer
.sp .25
_
.sp .25
INCLUDE_BP	backplane network interface
INCLUDE_ENP	CMC Ethernet interface
INCLUDE_EX	Excelan Ethernet interface
INCLUDE_IE	Sun Ethernet interface
INCLUDE_NW	ISI Ethernet interface
INCLUDE_PN	Proteon network interface
.sp .25
.TE
.LP
For example, to include the network driver for the ENP-10 ethernet controller
from CMC, the symbol
.Sy INCLUDE_ENP
should be defined in
.Mo config.h .
To include the Network File System (NFS) facility,
.Sy INCLUDE_NFS
should be defined.
.LP
The distributed version of
.Mo configAll.h
includes all the available software options except NFS,
and includes several network device drivers.
.sp .5
.N 2 "The Configuration Module: \fIusrConfig.c\fP"
.LP
Many VxWorks options and parameters can be set simply by modifying definitions
in the configuration headers described in the previous section.
However, VxWorks is a very flexible and configurable system, and for some
applications it may be desirable to configure VxWorks in ways not provided
for by the configuration headers.
In such cases, application builders can modify the code in the
configuration module
.Mo usrConfig.c ,
to suit their needs.
.LP
The
.Mo usrConfig
module consists of four main pieces:
.DS
\\(bu \fIusrInit\fP \(em an initialization routine that runs before multi-tasking is enabled,
\\(bu \fIusrRoot\fP \(em the initial task to be executed,
\\(bu \fIusrClock\fP \(em the routine that will be called on every interrupt of the system clock,
\\(bu \fIusrNetInit\fP \(em the routine that initializes the network (called by \fIusrRoot\fP).
.DE
.LP
The elements of
.Mo usrConfig
are best understood by going through each step of the system start-up sequence.
The next sections trace the flow of control during the booting and
initialization of a VxWorks system.
.sp .5
.N 2 "The Initial Entry Point: \fIsysInit\fP"
.LP
The first step in bringing up a VxWorks system is to get an image of a
VxWorks system into main memory.
This is usually done via the VxWorks boot ROM.
Once a VxWorks system image has been loaded into the proper position in main
memory,
the boot ROM will transfer control to the VxWorks start-up entry point,
.Sy sysInit .
.LP
This entry point is in the system dependent assembly language module,
.Mo sysALib.s .
It locks out all interrupts,
sets up the initial C stack pointer,
and jumps to
.Sy usrInit ,
a C subroutine in the
.Mo usrConfig
module.
For some targets,
.Sy sysInit
also performs some minimal system-dependent hardware
initialization, just enough to execute the remaining initialization in
.Sy usrInit .
The initial stack pointer, which will be used only by the
.Sy usrInit
routine, is set to the entry point
.Sy sysInit
itself, so that this initial (minimal) stack will grow down
from the VxWorks load address.
.sp .5
.N 2 "The Initial Routine: \fIusrInit\fP"
.LP
The
.Sy usrInit
routine, in the
.Mo usrConfig
module,
first does all the initialization that must be performed before the
multi-tasking kernel is actually started,
and then starts the kernel execution.
It is the first C code to run in VxWorks.
It is invoked in supervisor mode with all hardware interrupts locked out.
.LP
There are many VxWorks facilities that \fIcannot\fP
be invoked from this routine.
In general, since there is no task context as yet
(e.g. no TCB and no task stack),
facilities that require a task context cannot be invoked.
This includes any facility that might cause the caller to be suspended,
such as semaphores or any facility that uses them.
Instead, the
.Sy usrInit
routine does only what is necessary to create an initial task,
.Sy usrRoot ,
that will then complete the start-up.
.LP
The initialization in
.Sy usrInit
includes the following:
.sp
.IP "Zero out the system \f2bss\fP segment:"
.br
The C language specifies that all uninitialized variables will have initial
values of 0.
These uninitialized variables are put together in a segment called ``bss''.
This segment is not actually loaded during the bootstrap, since it is known
to be all 0.  Since the
.Sy usrInit
routine is the first C code to be executed,
it clears the section of memory containing ``bss''
as its very first action.
.IP "Initialize the system trap and interrupt vectors:"
.br
Before enabling interrupts and starting the kernel, the exception
vectors of the 680x0 must be set up.
First, the routine
.Sy intVecBaseSet
is called to establish the vector table base address (except on 68000s
on which the vector table must begin at address 0).
Then, the routine
.Sy excVecInit
is called to initialize all exception vectors to default handlers that
will safely trap and report exceptions caused by program errors or
unexpected hardware interrupts.
Then the VxWorks trap vector
.Sy TRAP_VXWORKS ,
used by VxWorks to supply some VxWorks system mode facilities,
is set to vector to
.Sy sysVwTrapRtn .
Actual trap numbers are defined in
.Mo config.h .

.IP "Initialize system hardware to a quiescent state:"
.br
System hardware is initialized by calling the system dependent routine
.Sy sysInit .
This mainly consists of resetting and disabling hardware devices
that may cause interrupts once interrupts are enabled when the
kernel is started.
This is important because the VxWorks interrupt handlers for I/O devices,
system clocks, etc, will not be connected to their interrupt vectors until
the system initialization is completed in the
.Sy usrRoot
task.

.IP "Initialize the multi-tasking kernel:"
.br
The last act of
.Sy usrInit
is to initialize the multi-tasking kernel by calling the routine
.Sy kernelInit .
This call specifies:
.DS
\\(bu the trap vector used by the kernel, \fITRAP_KERNEL\fP,
\\(bu the entry point and stack size of the root task,
\\(bu the starting and ending address of the initial memory pool,
\\(bu the interrupt stack size and lock level.
.DE
The call actually initiates the multi-tasking environment and never returns.
The
.Sy usrInit
thread of execution is terminated and
control will be transferred to the root task,
.Sy usrRoot .
.N 3 "Initializing the Memory Pool"
.LP
VxWorks includes a memory allocation facility, in the module
.Mo memLib ,
that manages a pool of available memory.
The
.Sy malloc
routine allows callers to obtain variable size blocks of memory from the pool.
Internally, VxWorks uses
.Sy malloc
for all dynamic allocation of memory.
In particular, many VxWorks facilities allocate data structures
upon initialization.
Therefore, the memory pool must be initialized before any other
VxWorks facilities are initialized.
.LP
VxWorks makes heavy use of
.Sy malloc ,
including allocation of space for loaded modules,
allocation of stacks for spawned tasks,
and allocation of data structures upon initialization.
Application programmers are also encouraged to use
.Sy malloc
to allocate memory as needed.
Therefore, it is recommended that you assign to the VxWorks memory pool
all unused memory,
unless you specifically must reserve some fixed absolute memory area for
a particular application use.
.LP
The memory pool is initialized in the routine
.Sy kernelInit .
The parameters to
.Sy kernelInit
specify the start and end address of the initial memory pool.
In the default
.Sy usrInit
distributed with VxWorks,
the pool is set to start immediately following the end of the booted system,
and to contain all the rest of available memory.
.LP
The extent of available memory is determined by the routine
.Sy sysMemTop
which is a system-dependent routine that determines the size of
available memory by probing specific addresses.
If your system has other non-contiguous memory areas that you would like
to make available in the general memory pool, they can be added to the pool
by calling the routine
.Sy memAddToPool
later in the
.Sy usrRoot
task.
.sp .5
.N 2 "The Initial Task: \fIusrRoot\fP"
.LP
Once the multi-tasking kernel is executing and control is transferred to the
.Sy usrRoot
task, all VxWorks multi-tasking facilities are available,
and the initialization of the system can be completed.
In the standard
.Sy usrRoot
task distributed with VxWorks, the following initializations are performed:
.DS
\\(bu system clock
\\(bu I/O system and drivers
\\(bu network
\\(bu optional facilities
\\(bu creation and loading the system symbol table
\\(bu spawning of the shell
.DE
You are free to modify these initializations to suit your particular
configuration.
The meaning of each step and the significance of the various parameters
are explained in the following sections.
.N 3 "Initializing the System Clock"
.LP
The first action in the
.Sy usrRoot
task is to initialize the VxWorks clock and timer facilities.
.LP
First the watchdog timer facility is initialized by calling
.Sy wdLibInit .
After this call, watchdog timers may be created, started, and stopped
using other routines in
.Mo wdLib .
This is used by many I/O drivers to detect device timeouts.
.LP
Next, the system clock interrupt vector is connected to the system clock
service routine
.Sy usrClock
(described in a later section), by calling the routine
.Sy sysClkConnect .
.LP
Finally, the system clock rate is set to 60 ticks per second by calling
the routine
.Sy sysClkRateSet .
.N 3 "Initializing the I/O System"
.LP
The VxWorks I/O system is initialized by calling the routine
.Sy iosInit .
The arguments specify the maximum number of drivers that may be
subsequently installed, the maximum number of files that may be
open in the system simultaneously, and the desired name of the
``null'' device which is built-in to the VxWorks I/O system.
This ``null'' device is a ``bit-bucket'' on output and always returns
end-of-file for input.
.N 3 "Creating the Console Devices"
.LP
Next, the driver for the primary or ``console'' serial ports is installed
by calling the driver's initialization routine, which is typically called
.Sy tyCoDrv .
The actual devices are then created and named by calling the driver's device
creation routine, typically
.Sy tyCoDevCreate .
The arguments to this routine include the device name,
a channel number if the driver supports multiple ports,
and input and output buffer size.
.N 3 "Setting Standard In and Standard Out"
.LP
Next, the system-wide ``standard in'', ``standard out'', and ``standard error''
assignments are established by opening the desired devices
and calling
.Sy ioGlobalStdSet .
These are used throughout VxWorks as the default device
for communicating with the user.
The devices are set to have the options usual for interactive terminals
by calling
.Sy ioctl
to set the device options to
.Sy OPT_TERMINAL .
.N 3 "Installing the Pipe Driver, Exception Handling, Debugging, and Logging"
.LP
It is desirable to initialize the VxWorks exception handling facilities
(supplied by the module
.Mo excLib ),
debugging facilities
(supplied by the module
.Mo dbgLib ),
and logging facilities (supplied by
.Mo logLib ),
as soon as possible in the root task.
This facilitates detection and debugging of program errors in the root task
itself or in the initialization of the various facilities.
However, initializing these facilities requires
that the ``pipe'' driver be initialized.
.LP
``Pipes'' are virtual devices by which tasks can communicate with other tasks
in the same way that they communicate with I/O devices.
The pipe driver is initialized by calling
.Sy pipeDrv .
.LP
The exception handling facilities can now be initialized by calling
.Sy excInit .
This will spawn the exception support task,
.Sy excTask .
Following this initialization, program errors causing hardware exceptions will
be safely trapped and reported, and hardware interrupts to uninitialized
vectors will be reported and dismissed.
The VxWorks
.I signal
facility, used for task-specific exception handling, is initialized by calling
.Sy sigInit .
.LP
The logging facilities are initialized by calling
.Sy logInit .
The arguments specify the
.Sy fd
of the device to which logging messages are to be written,
and the number of log message buffers to allocate.
The logging initialization also includes spawning the logging task,
.Sy logTask.
.LP
The debugging facilities are initialized, if they have been selected
by defining
.Sy INCLUDE_DEBUG ,
by calling
.Sy dbgInit .
The debug initialization includes taking over the specified trap vector
(
.Sy TRAP_DEBUG
in
.Mo configAll.h )
for breakpoints and single-stepping.
.N 3 "Initializing Standard I/O"
.LP
VxWorks includes an optional ``standard I/O'' package that provides the
functionality of the UNIX buffered I/O facility.
This can be included by defining the symbol
.Sy INCLUDE_STDIO
in the header
.Mo configAll.h .
.N 3 "Creating RT-11 Disk Devices"
.LP
Many VxWorks configurations include at least one disk device on
which an RT-11 file system is maintained.
Also, the VxWorks RAM-disk driver is based on the RT-11 file system.
Before any disk drivers, or the RAM-disk driver, are initialized,
the RT-11 file system module must be initialized by calling the routine
.Sy rt11Init .
The argument specifies the maximum number of streams to RT-11 files
that may be open in the system simultaneously.
.LP
Next, any disk drivers are installed by calling the drivers'
initialization routines,
such as
.Sy fdDrv
for a floppy disk device, or
.Sy ramDrv
for the RAM-disk.
The actual devices can then created and named by calling the driver's device
creation routine, e.g.\&
.Sy fdDevCreate
or
.Sy ramDevCreate .
The arguments to these routines depend on the particular driver, but typically
include the device name, a drive number if the driver supports multiple drives,
and possibly some media specifications (single/double density/sided, etc.).
.N 3 "Initializing Floating Point Support"
.LP
Support for floating point I/O is initialized by calling the routine
.Sy floatInit .
Support for the MC68881 floating point co-processor
is initialized by calling the routines
.Sy fppInit
and
.Sy mathInit .
These facilities are included by defining the symbols
.Sy INCLUDE_FLOATING_POINT
and
.Sy INCLUDE_MC68881 ,
respectively, in
.Mo configAll.h .
.N 3 "Including Performance Monitoring Tools"
.LP
VxWorks has two performance monitoring tools.
A task activity histogrammer is provided by
.Mo spyLib ,
and a subroutine execution timer is provided by
.Mo timexLib .
These facilities are included by defining the symbols
.Sy INCLUDE_SPY
and
.Sy INCLUDE_TIMEX ,
respectively in
.Mo configAll.h .
.N 3 "Initializing the Network"
.LP
Before the network can be used, it must be initialized.
This is handled by the routine
.Sy usrNetInit ,
which is called by
.Sy usrRoot.
The routine
.Sy usrNetInit
takes a configuration string as an argument.
This configuration string is usually the ``boot line'' that was
specified to the VxWorks boot ROMs to boot the system.
Based on this configuration string,
.Sy usrNetInit
does the following network initialization:
.RS
.IP \\(bu .15i
Initializes network subsystem by calling the routine
.Sy netLibInit .
.IP \\(bu
Attaches and configures appropriate network drivers.
.IP \\(bu
Adds gateway routes.
.IP \\(bu
Initializes remote file access driver
.Sy netDrv
and adds remote file access device.
.IP \\(bu
Initializes the
.Sy rlogin
or
.Sy telnet
remote login facilities.
.IP \\(bu
Optionally initializes the remote procedure calls (RPC) facility.
.IP \\(bu
Optionally initializes the remote source debugging (DbxWorks) facility.
.IP \\(bu
Optionally initializes the Network File System (NFS) facility.
As noted above,
the inclusion of some of these network facilities are controlled by definitions
in the
.Mo configAll.h
header file.
.RE
.LP
The network initializations are described in detail in the
.Ch NETWORK
chapter.
.LP
.N 3 "Creating and Loading the System Symbol Table"
.LP
The VxWorks interactive development environment relies heavily on its memory
resident
.I "system symbol table"
which contains the names and addresses of
variables and functions that have been loaded into memory.
This symbol table is generally obtained from the host system from which
VxWorks was booted.
In ``stand-alone'' configurations
(described below, under ``Alternate Configurations'')
the system symbol table is not read by
.Sy usrRoot
at all.
In those cases, the remainder of this section does not apply.
.LP
First the system symbol table must be created by calling
.Sy symTblCreate ,
specifying the maximum number of symbols in the system symbol table.
For convenience during debugging, it is most useful to have room for
all symbols in the system.
On the other hand,
a production version of a system can be built that does not require
any system symbol table at all, if memory use is a factor.
.LP
The call to
.Sy symTblCreate
creates an empty system symbol table.
VxWorks system facilities are not accessible interactively via the shell
until the symbol definitions for the booted VxWorks system are entered
into the system symbol table.
This is done by reading the system's symbol table from a file called
.Mo vxWorks.sym
in the same directory from which
.Mo vxWorks
was loaded.
This file contains an object module that consists only of a symbol table section
containing the symbol definitions for all the variables and functions
in the booted system module.
It has zero-length (empty) code, data, and relocation sections.
Nonetheless, it is a legitimate object module in the standard object module
format.
.LP
The symbols in
.Mo vxWorks.sym
are entered in the system symbol table by calling the routine
.Sy loadSymTbl
(whose source code is in
.Mo usrConfig.c ).
This routine simply uses the VxWorks loader
to load the symbols from
.Mo vxWorks.sym
into the system symbol table.
.N 3 "Spawning the Shell"
.LP
In a typical development configuration, the
.Sy usrRoot
task spawns the VxWorks shell task by calling
.Sy shellInit .
The first argument to
.Sy shellInit
specifies the shell's stack size which must be large enough to accommodate any
routines you will call from the shell.
The second argument is a boolean that specifies whether
the shell's input is from an ``interactive'' source (TRUE), or a non-interactive
source (FALSE) such as a script file.
If the source is interactive, then shell prompts for commands but does not
echo them to standard out, and vice-versa if the source is non-interactive.
.sp .5
.N 2 "The System Clock Routine: \fIusrClock\fP"
.LP
The final element in the
.Mo usrConfig
module is the system clock interrupt routine
.Sy usrClock .
This interrupt level routine is attached to the system clock timer
interrupt by the
.Sy usrRoot
task described above.
The routine must call the kernel clock tick routine
.Sy tickAnnounce ,
and the watchdog clock tick routine
.Sy wdTick .
Application developers may also
add any application-specific processing to this routine.

.N 1 "ALTERNATIVE KERNELS"
.LP
In addition to the native VxWorks kernel,
VxWorks also supports the use of several alternative kernels:
.I pSos
from Software Components Group and
.I VRTX
from Ready Systems.
If VxWorks is ordered with one of these kernels,
the supplied distribution files are configured appropriately,
including the libraries, makefiles, and system images for that kernel.
VxWorks is built with the ordered kernel by using the default makefile
as described previously.
.LP
However, even if another kernel is ordered,
the VxWorks native kernel is always supplied as well.
VxWorks can be built with the native kernel by using the alternative makefile
.Mo Makefile.wind
with the following UNIX command:
.DS
% make -f Makefile.wind
.DE
.N 2 "Configuring the pSos Kernel"
.LP
The pSos kernel is configured by parameters in a table called the
pSos Configuration Table.
In VxWorks, this table is a data structure called
.Sy usrCftbl
in a separate module
.Mo vw/config/all/configPsos.c .
.LP
The pSos documentation describes each of the parameters in the configuration
table.
The following items should be noted when configuring pSos in the VxWorks
environment:
.IP "pSos workspace:"
.br
pSos requires a block of workspace memory.
The pSos documentation contains formulas for determining the size
of the workspace pSos will require.
.IP "Clock frequency:"
.br
The frequency of the system clock must be entered in the configuration table.
In pSos, this is not dynamically alterable.
The value in the configuration table must correspond to the frequency at
which the system clock is set in
.Mo usrConfig .
.IP "Task-switch callout:"
.br
VxWorks makes use of the pSos supplied task-switch callout facility
to extend the pSos notion of a task context.
The routine
.Sy psosTswitchHook
must be specified for the task-switch callout routine.
.sp .5
.N 2 "Configuring the VRTX Kernel"
.LP
The VRTX kernel is configured by parameters in a table called the
VRTX Configuration Table.
In VxWorks, this table is a data structure called
.Sy usrCftbl
in a separate module
.Mo vw/config/all/configVrtx.c .
.LP
The VRTX documentation describes each of the parameters in the configuration
table.
The following items should be noted when configuring VRTX in the VxWorks
environment.
.IP "VRTX workspace:"
.br
VRTX requires a block of workspace memory.
The VRTX documentation contains formulas for determining the size
of the workspace VRTX will require.
.IP "Task stack size:"
.br
The normal VRTX mechanism for assigning stacks to new tasks
requires that all task stacks be the same size.
VxWorks supports variable size task stacks by allocating
the stacks from the memory pool (in the routine
.Sy taskSpawn ).
In order to defeat the normal VRTX mechanism, however, the two task
stack size parameters in the configuration table
.Sy sys-stack-size
and
.Sy user-stack-size
must be 0.
.IP "Task-create and task-switch hooks:"
.br
VxWorks makes use of the VRTX supplied task-create and task-switch hooks
to extend the VRTX notion of a task context.
The routines
.Sy vrtxTcreateHook
and
.Sy vrtxTswitchHook
must be specified for the task-create and task-switch callout routines.

.N 1 "ALTERNATIVE CONFIGURATIONS"
.LP
The preceding discussion of the
.Mo usrConfig
module outlined a ``typical'' configuration for a development environment.
In this configuration,
the VxWorks system image contains all of the VxWorks modules
that are necessary to allow you to interact with the system
through the shell.
Once the system is up, you can interactively load, execute,
and debug other VxWorks and application modules, via the VxWorks shell.
The following sections discuss some alternatives to this typical
development configuration.
.sp .5
.N 2 "Adding Application Modules (Bootable Applications)"
.LP
In general, during development it is preferable \fInot\fP
to include any extraneous modules in the VxWorks bootable system,
since any changes to those modules would then require
recreating the VxWorks system.
However, as you approach a debugged ``production'' version of your system,
you may want to add application modules to the bootable system image,
and to add start-up of your applications to the system initialization
routines.
.LP
To include application modules in the bootable system image, simply
add the names of the application object modules (with a ``.o'' suffix)
to the list of modules to be linked with the UNIX
.To ld
command (discussed previously).
.LP
To add start-up of your applications to the system initialization,
just add the necessary code to the
.Sy usrRoot
routine in the
.Mo usrConfig
module.
This code can call application initialization routines, create additional
I/O devices, spawn application tasks, etc., just as you might do from
the shell in a development configuration.
.LP
It is possible, in this way, to make a ``bootable'' application, in which
the application is completely initialized and functional after booting
without any interaction with the VxWorks shell.
.sp .5
.N 2 "Removing VxWorks Development Facilities"
.LP
In a production configuration,
it may be desirable to remove some of VxWorks development facilities
to reduce the memory requirements of the system, to reduce the boot time,
or for security purposes.
.LP
If the application start-up has been made a part of the system initialization
as described above,
then there may be no need to interact with the system through the VxWorks
shell.
In this case, the shell initialization (a call to
.Sy shellInit )
can be omitted from the
.Sy usrRoot
routine.
Also, the creation and initialization of the system symbol table
can be omitted from
.Sy usrRoot ,
since there will be no need to look up symbol names.
.LP
Other optional VxWorks facilities can easily be omitted from VxWorks by
removing the definition of their corresponding control symbols
in the header
.Mo configAll.h .
For example, debugging facilities can be omitted by deleting the definition of
.Sy INCLUDE_DEBUG .
RT-11 file support and the RAM-disk driver can be omitted by deleting the
definitions of
.Sy INCLUDE_RT11
and
.Sy INCLUDE_RAMDRV ,
respectively.
Many more facilities can be omitted in this same way.
.sp .5
.N 2 "Removing VxWorks Network Facilities"
.LP
In some applications it may be desirable to eliminate
the VxWorks network facilities altogether.
For example in ROM based systems or in ``standalone'' configurations
described below, there may be no need for the network facilities.
In this case the routine
.Sy usrNetInit ,
and all references to it in
.Mo usrConfig.c ,
should be deleted (or commented out).
Otherwise the UNIX linker will include the network code,
even if it is never invoked.
The Remote Procedure Call library may be omitted by removing the definition
of
.Sy INCLUDE_RPC
in the header
.Mo config.h .
.sp .5
.N 2 "Creating a VxWorks System In ROM"
.LP
It is possible to put VxWorks or a VxWorks-based application into ROM.
The user must modify the command to the UNIX loader such that the module
.Mo romInit.o
is loaded before
.Mo sysALib.o .
The entry point option must then
be changed to ``-e romInit''.  The
.Sy romInit
code clears memory and copies the
vxWorks text and data segments into the proper location in RAM.
The stack is initialized to point directly below the text segment,
and control is passed to the
.Sy usrInit
routine.
.LP
A good example of a ROM-based VxWorks application is the VxWorks boot ROM
program itself.
The file
.Mo vw/config/all/bootConfig.c
is the configuration module for the boot ROM (instead of the file
.Mo usrConfig.c
provided for the default VxWorks development system).
The
.Mo Makefiles
in the target-specific directories (\fBvw/config/<target>\fP) contain
directives for building the boot ROMs,
including an S-record format file suitable for downloading
to a PROM programmer.
This is done by invoking the UNIX
.To make
command as follows:
.DS
% make bootrom.hex
.DE
.N 2 "Creating a Stand-Alone VxWorks System with a Built-In Symbol Table"
.LP
It is sometimes necessary to create a VxWorks system that does not
read its own symbol table during initialization.  This might be
necessary, for instance, if the system will not have access to a device
from which it can read the symbol table.  The procedure for building
such a system is somewhat different from the normal procedure described
above.  No change is necessary in the application code or in
.Mo usrConfig.c .
Only the
.To make
procedure must be changed.  In the
.Mo Makefile
in the target directory,
one of the versions of VxWorks that can be built is called
.Mo vxWorks.st .
This is a version with a built-in symbol table.
.LP
Here is a copy of a typical
.Mo Makefile
entry for creating
.Mo vxWorks.st :
.DS
.Ci
vxWorks.st : usrConfig_st.o $(MACH_DEP) $(LIBS)
	rm -f vxWorks.st version.c version.o symTbl.c symTbl.o
	makeVersion >version.c
	cc $(CFLAGS) -c version.c
	ld -o tmp.o -X -r $(MACH_DEP) usrConfig_st.o version.o $(LIBS)
	makeSymTbl tmp.o >symTbl.c
	cc -c $(CFLAGS) symTbl.c
	ld -o vxWorks.st -N -X -T $(RAM_START_ADRS) -e _sysInit tmp.o symTbl.o
.DE
The module
.Mo usrConfig_st.o
is simply the
.Mo usrConfig.c
module compiled with
the
.Sy STANDALONE
flag defined.  $(MACH_DEP) are the machine dependent modules
.Mo sysALib.o ,
.Mo sysLib.o
and
.Mo tyCoDrv.o .
$(LIBS) are the archives in
.Mo /usr/vw/lib .
VxWorks is linked as described previously, except that the first pass through
the loader does not specify the final load address \(em the output from this
stage is still relocatable.
.To makeSymTbl
is invoked on the output of the loader \(em
this tool constructs a data structure which contains all the symbols
in VxWorks.
This structure is then compiled and linked with VxWorks itself
to produce the final bootable VxWorks object module.
.LP
The
.Sy STANDALONE
flag causes the
.Mo usrConfig.c
module to be compiled with the
built-in system symbol table.
The flag also suppresses the initialization of the network,
since the network is not now needed to download the system symbol table.
If you want the network initialized, you may either call
.Sy usrNetInit
from the shell, or you can modify
.Sy usrRoot
to call
.Sy usrNetInit .
.LP
VxWorks systems with a built-in symbol table are extensively discussed
in the application note
.Ch ``VxWorks\ Development\ on\ a\ Standalone\ System'' .
.TO
