.WP "Coding Conventions" VxWorks 3.20
.\" This document should be troffed with the special Times-Courier font.
.lg 0	\" No ligatures, since some of this is done in courier.
.TL
WIND RIVER SYSTEMS CODING CONVENTIONS
.SP
.N 1 "INTRODUCTION"
.LP
The conventions specified here define the Wind River Systems standard
for all C code and accompanying documentation included in the source.
The conventions are intended, in part, to encourage higher quality code:
every source module is required to have certain essential documentation,
and the code and documentation is required to be in a format that has 
been found to be readable and accessible.
However the conventions are also intended to provide a level of uniformity
in the code produced by different programmers.
Besides making the code look more professional, uniformity allows 
programmers to work on code written by others with less overhead in
adjusting to stylistic differences.
Also it allows automated processing of the source: tools can be
written to generate manual entries, module summaries, change reports, etc.
.LP
The conventions are divided into the following categories:
.DS
(1) Module Layout
(2) Subroutine Layout
(3) Code Layout
(4) Naming Conventions
(5) Style
.DE
.SP
.N 1 "MODULE LAYOUT"
.LP
A module is any unit of code that resides in a single source file.
Thus a module may be a Unix tool, a library of routines, or an
applications task.
The conventions in this section define the standard for the header 
that must come at the beginning of every source module.
.LP
The module header consists of the blocks described below.
The blocks are separated by one or more blank lines and should contain
no blank lines within the block.
This facilitates automated processing of the header.
.IP (1)
Title - one line containing the module name followed by a short description.
The module name
.B must
be the same as the module file name.
This line will become the title of automatically generated manual entries
and indexes.
.IP (2)
Modification history - each entry consists of the version number,
date of modification, initials of the programmer who made the change,
and a complete description of the change.
The version number is a two digit number and a letter (i.e. "03c").
The letter is incremented on small changes and the number is incremented
on major changes, especially those that materially affect the module's
external interface.
.IP (3)
General module documentation - consists of a complete description
of overall module purpose, and functioning, and especially the
external interface.
.IP (4)
Includes - consists of the includes required by the module.
.LP
The exact format of these blocks is elaborated in the following example of
a standard module header:
.DS
.ft 2
.cs I 22
.ss 22
/* fooLib.c - foo subroutine library */

/*
modification history
--------------------
01b,15feb86,dnw  added routines fooGet and fooPut.
                 added check for invalid index in 
                   fooFind.
01a,10feb86,dnw  written.
*/

/*
DESCRIPTION
This module is an example of the Wind River Systems 
C coding conventions.
 ...
*/

#include <vxWorks.h>
#include "fooLib.h"

.ft 1
.cs I
.ss 12
.DE
.SP
.N 1 "SUBROUTINE LAYOUT"
.LP
The following conventions define the standard layout for every subroutine
in a module.
.LP
Each subroutine is preceded by a header of documentation that consists
of the following blocks.
There should be no blank lines in the header but each block should
be separated with a line containing a single "*" in the first column.
.IP (1)
Banner - a slash followed by asterisks across the page.
.IP (2)
Title - one line containing the routine name followed by a short description.
The routine name in the title
.B must
match the declared routine name.
This line will become the title of automatically generated manual entries
and indexes.
.IP (3)
Description - complete description of what the subroutine does and how
to use it.
.IP (4)
RETURNS - the word "RETURNS:" followed by a description of the possible 
result values of the subroutine.
.LP
Immediately following the subroutine header should come the subroutine
declaration itself.
Each argument to the routine
.B must
be described with a comment.
This declaration will become the synopsis of automatically generated
manual entries.
.LP
The exact format of the subroutine header and declaration is elaborated
in the following example of a standard subroutine layout.
.DS
.ft 2
.cs I 22
.ss 22
/*********************************************
*
* fooGet - get an element from a foo
*
* This routine finds the element of the specified
* index in the specified foo.
*
* RETURNS:
*   OK if element found, otherwise ERROR.
*   The value of the element found is returned 
*   in *pValue.
*/

STATUS fooGet (foo, index, pValue)
    FOO foo;     /* foo in which to find element */
    int index;   /* element to be found in foo */
    int *pValue; /* where to return value */

    {
    ...
    }

.ft 1
.cs I
.ss 12
.DE
.SP
.N 1 "CODE LAYOUT"
.LP
The following conventions define the standard for the graphic layout
of C code.
.N 2 "Vertical Spacing"
.IP (1)
Use blank lines to make code more readable and to group logically
related sections of code together.
Put a blank line before and after comment lines.
.IP (2)
Do not put more than one statement on a line.
The only exception is the 'for' statement where the initial, conditional,
and loop statements may be written on a single line:
.DS
.ft 2
for (i = 0; i < count; i++)
.ft 1
.DE
The 'if' statement is
.B not
an exception: the executed statement always goes on a separate line
from the conditional expression:
.DS
.cs I 22
.ss 22
.ft 2
if (i > count)
    i = count;
.ft 1
.cs I
.ss 12
.DE
.IP (3)
Section braces '{' and '}' and 'case' labels always get their own line.
.N 2 "Horizontal Spacing"
.LP
.IP (1)
Put spaces around binary operators, after commas, and before
open parenthesis.
Do not put spaces around structure member and pointer operators.
Put a space before array subscript open bracket.
(If the subscript is only one or two characters long, the space before
the bracket may be omitted.)
.DS
.ft 2
status = fooGet (foo, i + 3, &value);
foo.index
pFoo->index
fooArray [(max + min) / 2]
string[0]
.ft 1
.DE
.IP (2)
Continuation lines should line up with the part of the preceding line
they continue:
.DS
.ft 2
.cs I 22
.ss 22
a = (b + c) *
    (d + e);

status = fooList (foo, a, b, c,
                  d, e);

if ((a == b) &&
    (c == d))
    ...

.ft 1
.cs I
.ss 12
.DE
.N 2 "Indentation"
.IP (1)
Tab stops are every four characters (i.e. 1, 5, 9, ...).
.IP (2)
The module and subroutine headers and the subroutine declarations
start in column 1.
.IP (3)
Indent one tab stop after:
.DS
a) subroutine declarations,
b) conditionals (see below),
c) looping constructs,
d) switch statements,
e) case labels,
f) structure definitions in a typedef
.DE
.IP (4)
The 'else' of a conditional has the same indentation as the 'if'.
Thus the form of the conditional is:
.DS
.ft 2
.cs I 22
.ss 22
if (<condition>)
    {
    <statements>
    }
else
    {
    <statements>
    }
.ft 1
.cs I
.ss 22
.DE
.IP (5)
The general form of the switch statement is:
.DS
.ft 2
.cs I 22
.ss 22
switch (input)
    {
    case 'a':
        ...
        break;

    case 'b':
        ...
        break;

    default:
        ...
        break;
    }
.ft 1
.cs I
.ss 22
.DE
If the actions are very short and nearly identical in all cases,
an alternate form of the switch statement may be acceptable:
.DS
.ft 2
.cs I 22
.ss 22
switch (input)
    {
    case 'a': x = aVar; break;
    case 'b': x = bVar; break;
    case 'c': x = cVar; break;
    }
.ft 1
.cs I
.ss 12
.DE
.IP (6)
Comments have the same indentation as the section of code to which
they refer.
.IP (7)
Section braces '{' and '}' have the same indentation as the code they
enclose.
.SP
.N 1 "NAMING CONVENTIONS"
.LP
The following conventions define the standards for naming modules,
routines, variables, constants, macros, types, and structure and union
members.
The object of the conventions is the uniformity and readability of the code.
.IP (1)
When making up names, keep the following in mind: the code will be
written once but read many times.
Make names meaningful and readable.
Avoid obscure abbreviations.
.IP (2)
Names of routines, variables, structure and union members are written
with upper and lower case and without underlines.
Every "word" in the name except the first is capitalized:
.DS
.ft 2
aVariableName
.ft 1
.DE
.IP (3)
Names of defined types (via typedefs), and constants and macros
(via #defines), are all upper-case with underlines separating the
"words" in the name:
.DS
.ft 2
A_CONSTANT_VALUE
.ft 1
.DE
.IP (4)
Every module has a short (2-5 character) prefix.
This prefix is attached to the module name, and all externally available
routines, variables, constants, macros, and typedefs.
(Names that are not available externally are not restricted to this
convention.)
.DS
.ta 2i
\f2fooLib.c\f1	- module name
\f2fooFind\f1		- subroutine name
\f2fooCount\f1	- variable name
\f2FOO_MAX_COUNT\f1	- constant
\f2FOO_NODE\f1	- type
.ta
.DE
.IP (5)
Pointer variable names have a "p" prefix for each level of indirection:
.DS
.ft 2
FOO_NODE *pFooNode;
FOO_NODE **ppFooNode;
.ft 1
.DE
.SP
.N 1 "STYLE"
.LP
The following conventions define additional standards of programming style.
.IP (1)
Comments - 
Insufficiently commented code is unacceptable code.
Serious or repeated violations are grounds for public derision
of the perpetrator.
.IP (2)
Lint -
Lint is run with every installation to check for possible errors that
would not be caught by the compiler.
All modules must be coded so as to eliminate all avoidable lint complaints.
This frequently involves explicit type coercions and use of lint directives
(\f2VARARGS, ARGSUSED\f1, etc.).
.IP (3)
MANGEN -
The mangen tool is used to automatically generate manual entries for
every module.
All modules must generate valid manual entries by the mangen tool.
The layout requirements and options of mangen are documented in more
detail in another document.
.IP (4)
Numeric constants -
Use #define to define meaningful names for all constants.
Never use numeric constants in code or declarations
(except for obvious uses of 0, 1, etc.).  
.IP (5)
Structure definitions -
Always define structures and unions by a typedef declaration.
Never use a structure or union definition to declare a variable directly.
.IP (6)
Passing and returning structures -
Always pass and return pointers to structures.
Never pass or return structures directly.
.IP (7)
Routines that return status values should return either
\f2OK\f1 or \f2ERROR\f1 (defined in vxWorks.h).
The specific type of error is identified by setting
the task status value with the routine errnoSet.
.IP (8)
Use the names defined in vxWorks.h wherever possible.
In particular, note the following definitions:
.DS
- use \f2TRUE\f1 and \f2FALSE\f1 for boolean compares,
- use \f2EOS\f1 for end-of-string tests,
- use \f2NULL\f1 for zero pointer tests,
- use \f2FAST\f1 for "register" variables,
- use \f2IMPORT\f1 for "extern" variables,
- use \f2LOCAL\f1 for "static" variables,
- use \f2VOID\f1 for routines that return no value,
- use \f2FUNCPTR\f1 for "pointer to function" types
.DE
.TO
