.WP "Architecture" VxWorks 4.00
.TL
VxWORKS ARCHITECTURE
.SP
.N 1 "INTRODUCTION"
.LP
Modern real-time systems are based on the complementary concepts of
multi-tasking and inter-task communications.
A multi-tasking environment allows a real-time application to be constructed
as a set of independent tasks, each with its own thread of execution
and set of system resources.
The inter-task communication facilities allow these tasks to synchronize
and communicate in order to coordinate their activity.
In VxWorks, the inter-task communication facilities range from extremely
fast semaphores to UNIX-like pipes and network-transparent sockets.
.LP
Another key facility in real-time systems is hardware interrupt handling,
since interrupts are the usual mechanism used to inform a system of
external events.
In order to get the fastest possible response to interrupts,
interrupt handling code in VxWorks runs in a special context of its own,
outside of the context of any task.
.LP
This chapter discusses the multi-tasking kernel, tasking facilities,
inter-task communication, and interrupt handling facilities that are at
the heart of the VxWorks run-time environment.

.N 1 "TASKS"
.N 2 "Multi-Tasking"
.LP
The basic multi-tasking environment is provided by the VxWorks real-time kernel.
Multi-tasking creates the appearance of many programs executing
simultaneously when, in fact, the kernel interleaves their execution.
Each apparently independent program is called a
.I task .
Each task has its own context, which is the CPU environment and system resources
the task sees each time it is scheduled to run by the kernel.
A task's context includes:
.LP
.RS
.IP \\(bu .15i
a thread of execution, i.e. the task's program counter
.IP \\(bu
the CPU registers and optionally floating point registers
.IP \\(bu
a stack for dynamic variables and function calls
.IP \\(bu
I/O assignments for standard input, output, and error
.IP \\(bu
a delay timer
.IP \\(bu
signal handlers
.IP \\(bu
debugging and performance monitoring values
.RE
.sp .5
.LP
In VxWorks, one important resource that is
.UL not
a part of a task's context is memory address space.
Under VxWorks, all code executes in a single common address space.
Giving each task its own memory space would require virtual-to-physical
memory mapping, which runs counter to VxWorks high-performance real-time
philosophy.

.N 2 "Preemptive Priority Scheduling"
.LP
Tasks in VxWorks are either ready to run or blocked.
A blocked task is waiting for some event, such as a delay timeout or a
semaphore to be available, and is not competing for CPU time.
The system scheduler decides which of the ready-to-run tasks will execute.
.LP
The VxWorks kernel uses a preemptive priority based scheduler.
Each task is assigned a priority and the kernel ensures that
the highest priority task runs that is ready to run.
The scheduling is
.I preemptive
in that if a task becomes ready to run that has higher priority than
the current task, the kernel will immediately interrupt the
current task and switch to the higher priority task.

.N 2 "Basic Tasking Functions"
.LP
The following sections give an overview of VxWorks' basic tasking functions.
These functions are in the VxWorks library
.Mo taskLib(1) .
Detailed descriptions of each routine can be found in Chapter 2 of the
reference section.
.LP
Note that there are also many routines in
.Mo usrLib(1)
that provide a more interactive interface to the tasking functions
described here.

.N 2 "Task Creation and Activation"
.LP
The following routines are used to create and delete tasks:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Create and Delete Routines
.sp .25
_
Call	Description
_
.sp .25
taskSpawn	Spawn (create and activate) a new task.
taskCreate	Create a new task.
taskActivate	Activate a created task.
taskDelete	Delete a task.
exit	Exit a task.
.sp .25
.TE
.LP
The arguments to
.Sy taskSpawn
are the new task's name (an ASCII string), priority, an ``options'' word,
stack size, main routine address,
and up to 10 arguments to be passed to the main
routine as start-up parameters:
.DS C
id = taskSpawn (<name>, <priority>, <options>, <stacksize>, <main>, <arg1>, ... <arg10>);
.DE
The
.Sy taskSpawn
subroutine creates the new task context, including allocating the stack
and setting up the task environment to call the main routine
(a normal C routine) with the specified arguments.
When the new task begins execution, it will begin at the
entry to the specified routine.
.LP
The main routine's return address is set to a task clean-up and
exit routine.
Thus if the main routine simply returns, the task will be gracefully deleted.
Alternatively, a task can call
.Sy exit
at any point to kill itself.
A task can kill another task by calling
.Sy taskDelete.
.LP
Spawning a task actually involves two lower-level steps.
First, a task is
.I created
in an inactive state, at which time all of its task context is allocated,
but it is not eligible to run.
The task is then
.I activated ,
at which point it becomes ready to run.
The create and activate functions are supplied by the routines
.Sy taskCreate
and
.Sy taskActivate ;
however, these routines are rarely called directly, since
.Sy taskSpawn
embodies both these functions.

.N 2 "Task Names and IDs"
.LP
When a task is spawned, the user specifies a
.I "task name"
which is an ASCII string of arbitrary length.  The system returns a
.I "task ID"
which is an efficient 4-byte pointer to the task's data structures.
Almost all VxWorks functions take the task ID as an argument when
a task must be specified.
Specifying a task ID of 0 to such a function always implies ``self'',
i.e. the calling task.
.LP
Many users don't care about naming some or any of their tasks.
If a NULL pointer is supplied for the
.Sy name
argument of the
.Sy taskSpawn
call, then VxWorks will make up a name.
This name will be an ASCII string of a small integer that gets
incremented as tasks are spawned.
.LP
Note that for convenience, the routines in
.Mo usrLib
and
.Mo dbgLib ,
which are oriented more towards interactive use,
will accept either task IDs or task names to specify tasks.
.LP
The following routines in
.Mo taskLib
get information about task IDs and names:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Name and ID Routines
.sp .25
_
Call	Description
_
.sp .25
taskName	Get name associated with a task ID.
taskNameToId	Lookup task ID associated with a name.
taskIdSelf	Get the calling task's ID.
taskIdListGet	Fill an array with IDs of all active tasks.
taskIdVerify	Verify the existence of a specified task.
.sp .25
.TE

.N 2 "Task Options"
.LP
When a task is spawned, the user specifies an option parameter that selects
the options in the following table.  The value of the option parameter
is specified by ``or''ing together the desired options.
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a0w(1.4i)fI aw(3i).
.sp .25
Task Routine Option Parameters
.sp .25
_
Name	Description
_
.sp .25
VX_UNBREAKABLE	Disable breakpoints for task.
VX_FP_TASK	Execute with floating point co-processor support.
VX_STDIO	Execute with \fIstdio\fR buffered I/O support.
VX_DEALLOC_STACK	Deallocate stack on termination.
.sp .25
.TE
.LP
Note that
.Sy VX_FP_TASK
must be specified if the task does any floating point operations.
Similarly,
.Sy VX_STDIO
must be specified if the task uses any
.Sy stdio
functions other than
.Sy printf
and
.Sy sscanf .
.LP
Task options can also be examined and altered after a task is spawned,
using the subroutines
.Sy taskOptionsGet
and
.Sy taskOptionsSet .

.N 2 "Task Control and Information"
.LP
The following routines provide direct control over a task's execution:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Execution Control Routines
.sp .25
_
Call	Description
_
.sp .25
taskSuspend	Suspend a task.
taskResume	Resume a task.
taskRestart	Restart a task.
taskDelay	Delay a task for a number of ticks.
.sp .25
.TE
.LP
The following routines allow examining and altering a task's context:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Context Routines
.sp .25
_
Call	Description
_
.sp .25
taskOptionsGet	Examine task options.
taskOptionsSet	Set task options.
taskPriorityGet	Examine priority of a task.
taskPrioritySet	Change priority of a task.
taskRegsGet	Examine a task's registers.
taskRegsSet	Set a task's registers.
.sp .25
.TE
.LP
The following routines get information about a task:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Information Routines
.sp .25
_
Call	Description
_
.sp .25
taskInfoGet	Get info about task.
taskStatusString	Get the task's status as a string.
taskIsSuspended	Check if a task is suspended.
taskIsReady	Check if a task is ready to run.
taskTcb	Get pointer to task's control block.
.sp .25
.TE

.N 2 "Task Error Status"
.LP
Most VxWorks subroutines indicate the success or failure of their
function by the value they return.
Many routines simply return the values OK (0) or ERROR (-1).
Some routines which are expected to return a non-negative number
(e.g.
.Sy open
which returns a file descriptor, and
.Sy read
which returns a byte count)
also return ERROR to indicate an error.
Routines which are expected to return a pointer
usually return NULL (0) to indicate an error.
.LP
Of course, one frequently needs to know more than just whether the subroutine
failed.
When VxWorks subroutines encounter errors, they set an error status
that elaborates the nature of the error.
This is analogous to the UNIX error status mechanism in which
the status values are set in the global variable ``errno''.
However, in VxWorks there are many contexts,
both task and interrupt, which share the common memory space
and hence would conflict in their use of a global variable.
VxWorks instead supplies routines to set and get the current error status
value, and these routines maintain the value for each context separately.
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Error Status Routines
.sp .25
_
Call	Description
_
.sp .25
errnoSet	Set error status of current task or interrupt.
errnoGet	Get error status of current task or interrupt.
.sp .25
.TE
See the manual entry for
.Mo errnoLib(1)
for details on the composition
of status values.
.LP
The status value is
.UL never
cleared by VxWorks routines.
Thus, the value always indicates the last error status set.
When a VxWorks subroutine gets an error indication from a
call to another routine, it usually just returns its own error indication
without modifying the task's status value.
Thus, the status value that was set in the lower-level routine remains available
as the indication of error type.
.LP
For example, the VxWorks routine
.Sy intConnect ,
which connects a user routine to a hardware interrupt,
allocates memory by calling
.Sy malloc
.Sy \f1(\fPintConnect
builds the interrupt driver in this allocated memory).
If
.Sy malloc
fails because insufficient memory remains in the pool, it sets
the task's status value to a code indicating an insufficient memory error
was encountered in the memory allocation library,
.Mo memLib .
The
.Sy malloc
routine then returns NULL to indicate the failure.
The
.Sy intConnect
routine, receiving the NULL from
.Sy malloc ,
then returns its own error indication of ERROR.
However, it does not reset the task's status value, leaving it at the
``insufficient memory'' code set by
.Sy malloc .
.LP
Authors of application modules are encouraged to use this mechanism
in their own subroutines, calling
.Sy errnoSet
and
.Sy errnoGet ,
to set and examine the task status value.
See the manual entry
.Mo errnoLib(1)
for the error values available to applications.

.N 2 "Scheduler Control"
.LP
The VxWorks scheduler can be explicitly disabled and enabled.  When the
scheduler is disabled, priority-based preemption will not occur.
The currently running task will continue to run until the scheduler
is re-enabled.  Note that this locks out task switching but does not
lock out interrupts.
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Scheduler Enable/Disable Routines
.sp .25
_
Call	Description
_
.sp .25
taskLock	Disable task rescheduling.
taskUnlock	Enable task rescheduling.
.sp .25
.TE

.N 2 "Task Create, Switch, and Delete ``Hooks''"
.LP
To allow additional task related facilities to be added to system
without modifying the kernel,
VxWorks provides task create, switch, and delete ``hooks'' which
allow additional routines to be invoked whenever
a task is created, a task context switch occurs, or a task is deleted:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Task Create, Switch, and Delete ``Hooks''
.sp .25
_
Call	Description
_
.sp .25
taskCreateHookAdd	Add routine to be called at every task create.
taskCreateHookDelete	Delete previously added task create routine.
taskSwitchHookAdd	Add routine to be called at every task switch.
taskSwitchHookDelete	Delete previously added task switch routine.
taskDeleteHookAdd	Add routine to be called at every task delete.
taskDeleteHookDelete	Delete previously added task delete routine.
.sp .25
.TE
.LP
See the manual entry for
.Mo taskHookLib(1)
for more details.

.N 2 "Shared Code and Re-Entrancy"
.LP
In VxWorks, it is very common for a single copy of a subroutine
or subroutine library to be invoked by many different tasks.
For example, many tasks may call
.Sy printf ,
but there is only a single copy of the subroutine in the system.
This is called shared code.
VxWorks' dynamic linking facilities make this particularly easy.
Shared code makes the system more efficient and easier to maintain.
.LP
However, shared code must be
.I re-entrant .
A subroutine is re-entrant
if a single copy of the routine can be called from several
task contexts simultaneously without conflict.
Such conflict would typically occur when a subroutine modifies global or static
variables, since there is only a single copy of the data as well as a
single copy of the code.
A routine's references to such variables may overlap and interfere
in invocations from different task contexts.
.LP
All routines in VxWorks are made re-entrant with the following
techniques:
.RS
.IP \\(bu .15i
use of dynamic stack variables
.IP \\(bu
guarding global and static variables with semaphores
.IP \\(bu
use of task variables
.RE
.LP
These techniques should be used when writing application code that may be
called from several task contexts simultaneously.

.N 3 "Dynamic Stack Variables"
.LP
Many subroutines are
.UL pure
code, having no data of their own except dynamic stack variables.
They work exclusively on data provided by the caller
as parameters to subroutines.
The linked-list library is a good example of this.
Its routines operate on lists and nodes provided by the caller
in each subroutine call.
.LP
Subroutines of this kind are appealing because they are inherently re-entrant.
Multiple tasks can use such routines simultaneously without interfering with
each other, since each task does indeed have its own stack.

.N 3 "Guarded Global and Static Variables"
.LP
Some libraries are explicitly intended to encapsulate access to common data.
An obvious example is the memory allocation library,
.Mo memLib ,
which manages a single pool of memory to be used by many tasks.
This library declares and uses its own static data variables to keep track of
pool allocation.
.LP
While this kind of library is frequently desirable, it does require
some caution since the routines are not inherently re-entrant:
multiple tasks simultaneously invoking the routines in the library could
interfere with each other's access to the common variables.
Such libraries must be made explicitly re-entrant by providing a
``mutual-exclusion'' mechanism to prohibit tasks from simultaneously
executing critical sections of code.
The usual mutual-exclusion mechanism
is the semaphore facility provided by
.Mo semLib
(described below).

.N 3 "Task Variables"
.LP
Some routines that may be called by multiple tasks simultaneously
may require global or static variables that should have a distinct
value for each calling task.
An example is the buffered I/O library
.Mo stdioLib ,
which performs I/O to standard input, output, and error buffers
which are different for each task but referenced using the
same global variables,
.Sy stdin ,
.Sy stdout ,
and
.Sy stderr ,
by all tasks.
.LP
To accommodate this, VxWorks provides a facility called ``task variables''
which allows 4-byte variables to be added to a task's context,
so that the value of such a variable is switched every time a
task switch occurs to or from its owner task.
Typically, several tasks declare the same variable
(4-byte memory location) as a task variable.
Each of those tasks can then treat that single memory location as its
own private variable.
This facility is provided by the routines
.Sy taskVarAdd ,
.Sy taskVarDelete ,
.Sy taskVarSet ,
and
.Sy taskVarGet ,
which are described in the manual entry for
.Mo taskVarLib(1) .
.LP
Note that this mechanism should be used sparingly \(em
each task variable adds a few microseconds
to the context switching time for its task,
since the value of the variable must be saved and restored
as part of the task's context.
It may be prudent to collect all of a module's task variables
into a single dynamically allocated structure, and then make all accesses
to that structure be indirect through a single pointer which can then
be made a task variable for all tasks using that module.

.N 3 "Multiple Tasks with the Same Main Routine"
.LP
With VxWorks, it is possible to spawn several tasks with the same main routine.
Each spawn will create a new task with its own stack and its own
context, and can pass the main routine different parameters.
This is useful when the same function needs to be performed
concurrently with several sets of differing parameters.
For example, a routine that monitors a particular kind of equipment may be
spawned several times to monitor several different pieces of that equipment.
The arguments to the main routine could indicate which particular
piece of equipment the task is to monitor.
.LP
In this case, the same rules of re-entrancy described above apply to the
entire task.

.N 2 "VxWorks System Tasks"
.LP
VxWorks provides several system tasks which are described in the
following sections.
.N 3 "The Root Task (usrRoot)"
.LP
The root task
.Sy usrRoot
is the first task executed by the kernel.
In VxWorks, the root task is in the module
.Mo usrConfig
and is used to initialize the rest of VxWorks' facilities.
It spawns such tasks as the shell,
the logging task, the exception task, the network task, and the
.Sy rlogin
daemon.
Normally, the root task terminates and is deleted when all initialization has
been performed.
You are free to add any necessary initialization of your own to the root task.
See the chapter
.Ch CROSS-DEVELOPMENT
for details.

.N 3 "The Shell"
.LP
The VxWorks shell is also spawned as a task.  The shell allows
application developers to interact with VxWorks facilities and with their
own application modules, by interactively invoking any subroutine that
has been entered in the system symbol table.
Routines that are directly called from the shell, rather than spawned, run
in the context of the shell task.

.N 3 "The Logging Task (logTask)"
.LP
The log task is used by VxWorks modules to log system messages
without having to do I/O in the current task context.
See the section
.Ch Message\ Logging
in the chapter
.Ch I/O\ SYSTEM
and the manual entry for
.Mo logLib(1)
for details.

.N 3 "The Exception Task (excTask)"
.LP
The exception task
.Sy excTask
supports  the  VxWorks exception handling package.
Its purpose is to perform functions that can
not be done at interrupt level.
It
.UL must
have the highest priority in the system.
Do not suspend, delete, or change the priority of this task.
See the manual entry for
.Mo excLib(1)
for details.

.N 3 "The Network Task (netTask)"
.LP
The
.Sy netTask
daemon handles the task-level functions required by the VxWorks network.

.N 3 "The Remote Login Daemon (rlogind)"
.LP
The
.Sy rlogin
daemon
allows remote users to log in to VxWorks.  It accepts remote login requests
from other VxWorks or host systems, and causes the shell's input and output
to be redirected to the remote user.  A tty-like interface is provided to
the remote user through the use of the VxWorks pseudo terminal driver,
.Sy ptyDrv .
See the section
.Ch Serial\ I/O\ (TY\ and\ PTY)\ Devices
in the chapter
.Ch I/O\ SYSTEM
for further explanation.

.N 3 "The Telnet Daemon (telnetd)"
.LP
The
.Sy telnet
daemon
allows remote users to log into VxWorks via
.Sy telnet .
It accepts remote connection requests from any other system, and causes
the shell's input and output to be redirected to the remote user.
A tty-like interface is provided to the remote user through the use of
the VxWorks pseudo terminal driver,
.Sy ptyDrv .
See the section
.Ch Serial\ I/O\ (TY\ and\ PTY)\ Devices
in the chapter
.Ch I/O\ SYSTEM
for further explanation.

.N 3 "The Portmap Daemon (portmapd)"
.LP
The
.Sy portmap
daemon is an RPC server that acts as a central registrar for
RPC servers running on the same machine.  RPC clients query the
.Sy portmap
daemon to find out how to contact the various servers.

.N 3 "The DBX Server (dbxTask)"
.LP
The
.Sy dbxTask
services RPC requests made by remote source level debuggers.

.SP
.N 1 "INTER-TASK COMMUNICATIONS"
.LP
The complement to the multi-tasking functions described
previously is the inter-task communication facilities.
It is the communication facilities that allow independent tasks
to coordinate their actions.
.LP
VxWorks supplies a rich set of inter-task communication mechanisms,
including:
.RS
.IP \\(bu .15i
semaphores
.IP \\(bu
shared memory
.IP \\(bu
ring buffers and linked lists
.IP \\(bu
pipes
.IP \\(bu
sockets
.IP \\(bu
remote procedure calls
.IP \\(bu
signals
.RE

.N 2 "Semaphores"
.LP
Semaphores are the foundation of all inter-task communications in VxWorks.
All other communications facilities are built using semaphores as the
synchronization primitive.
Therefore, VxWorks semaphores are designed to be extremely fast.
.LP
The following semaphore functions are provided:
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Semaphore Functions
.sp .25
_
Call	Description
_
.sp .25
semCreate	Create a semaphore.
semDelete	Delete a semaphore.
semTake	Take a semaphore.
semGive	Give a semaphore.
semClear	Take a semaphore, don't wait.
.sp .25
.TE
.LP
A semaphore is a binary flag that can be set or reset.
The basic semaphore functions are
.Sy semCreate
which creates the semaphore and returns the semaphore ID (
.Sy SEM_ID ),
.Sy semGive
which sets the flag, and
.Sy semTake
which resets the flag when it is set.
.LP
When a task takes a semaphore with
.Sy semTake ,
one of two things happens depending on whether the semaphore was set or
reset at the time of the call.
If the semaphore was set, then the semaphore is reset and the task continues
execution immediately.
If the semaphore was reset, then the task is blocked and enters a state of
waiting for that semaphore.
.LP
When a task gives a semaphore with
.Sy semGive ,
one of several things happens.
If the semaphore was already set at the time of the call,
then giving the semaphore has no effect at all.
If the semaphore was reset and no task was waiting to take it, then the
semaphore is simply set.
If the semaphore was reset and one or more tasks were trying to take it,
then the higher priority task is unblocked and the semaphore
is left reset.
.LP
There are really two distinct uses of semaphores:\ \ mutual exclusion and
synchronization.

.N 3 "Mutual Exclusion"
.LP
Semaphores are very often used to interlock access to some shared resource.
In this technique, a semaphore is created to
.I guard
the resource.
The semaphore is initially set.
.DS
SEM_ID sem;

sem = semCreate();	/* create semaphore */
semGive (sem);		/* set semaphore initially */
.DE
When a task wants to access the resource, it must first take that semaphore.
So long as the task keeps the semaphore, all other tasks seeking access
to the resource will be blocked from taking the semaphore.
When the task is finished with the resource, it gives back the semaphore,
which allows another task waiting on that semaphore to gain access to
the resource.
.LP
Thus all accesses to the resource are bracketed with
.Sy semTake
and
.Sy semGive
pairs:
.DS
semTake (sem);

\&... exclusive access to resource

semGive (sem);
.DE

.N 3 "Synchronization"
.LP
The other common use of semaphores is as a task synchronization mechanism.
In this case, a semaphore may represent a condition or event that tasks may
wait for.
Initially the semaphore is reset.
A task or interrupt service routine signals the occurrence of
the event by giving the semaphore.
Some other task waits for the semaphore by calling
.Sy semTake .
This task will be blocked at that point until the event occurs and the
semaphore is given,
if this has not already happened.
.LP
Note the difference in sequence when semaphores are used for
mutual exclusion and when they are used for synchronization.
When used for mutual exclusion,
the semaphore is initially set, and
each task first takes and then gives back the semaphore.
When used for synchronization,
the semaphore is initially reset, and
one task waits to take the semaphore which will be given by another task.
.LP
The following code fragment is an example of task synchronization
with semaphores.

.KS
.DS
SEM_ID sem;		/* ID of synchronization semaphore */

init ()
    {
    sem = semCreate ();
    taskSpawn (..., task1);
    taskSpawn (..., task2);
    }

task1 ()
    {
    ...
    semTake (sem);	/* wait for synchronization from task2 */
    ...
    }

task2 ()
    {
    ...
    semGive (sem);	/* let task 1 proceed */
    ...
    }
.DE
.KE
When the
.Sy init
routine is called, the semaphore is created and two tasks are spawned.
.Sy task1
will run until it calls
.Sy semTake .
At that point, if
.Sy task2
has not yet called
.Sy semGive ,
.Sy task1
will block until it does.

.N 2 "Shared-Memory"
.LP
While semaphores are the basic task coordination primitive in VxWorks,
there is no data associated with them.
If we regard inter-task communications as consisting of task
.I synchronization
plus transmission of
.I data ,
semaphores provide the synchronization but not the data.
However, because all tasks in VxWorks run in a single common address space,
use of shared variables or buffers is a very simple way to transmit data.
.LP
For example, a simple inter-task ``mailbox'' is implemented
by associating a semaphore with a global variable or buffer
to indicate presence of data in the buffer.
The semaphore is initially reset.
When a task or interrupt service routine enters data in the buffer,
it signals that condition by giving the semaphore.
When a task wants to wait for data to be present in the buffer,
it takes the semaphore, which will block the task until data is present.

.N 2 "Ring Buffers"
.LP
VxWorks provides a facility for creating and manipulating
.I "ring buffers" ,
which are first-in-first-out circular buffers.
Ring buffers themselves do not include any task control facilities:
tasks cannot block waiting for data on a ring buffer.
However, as a shared memory data structure, they are a convenient building block
for a variety of communications mechanisms.
In the example of the previous section, if we replace the message buffer
with a ring buffer, the ``mailbox'' becomes a ``message queue''.
In fact, this technique is used to build VxWorks
.Sy pipes ,
described in a section below.
.LP
The following ring buffer functions are provided by the library
.Mo rngLib(1) :
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Ring Buffer Functions
.sp .25
_
Call	Description
_
.sp .25
rngCreate	Create an empty ring buffer.
rngBufPut	Put bytes to ring buffer.
rngBufGet	Get characters from ring buffer.
rngFlush	Make a ring buffer empty.
rngIsEmpty	Test for ring buffer empty.
rngIsFull	Test for ring buffer full (no more room).
rngNBytes	Determine number of bytes in ring buffer.
rngFreeBytes	Determine number of free bytes in ring buffer.
rngPutAhead	T{
Put a byte ahead in ring buffer without moving ring pointers.
T}
rngMoveAhead	Advance ring ``to'' pointer `n' bytes.
.sp .25
.TE
.LP
The ring buffer routines have been carefully built such that a ring buffer
reader only affects ``read'' pointers in the ring buffer structure,
and a writer only affects ``write'' pointers.
This means that a reader and a writer do not interfere with each other
and do not need mutually exclusive access to the ring buffer.
However, multiple readers must have mutually exclusive access to a ring,
as do multiple writers.

.N 2 "Linked Lists"
.LP
VxWorks provides a facility for creating and manipulating
.I "linked lists" .
The lists are ``doubly-linked'', each node having a forward pointer to
the next node, and a backward pointer to the previous node in the list.
Like ring buffers, linked lists themselves do not include any task control
or mutual exclusion facilities, but when interlocked with semaphores,
are a convenient building block for communications mechanisms.
.LP
The following linked-list functions are provided by the library
.Mo lstLib(1) :
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Linked List Functions
.sp .25
_
Call	Description
_
.sp .25
lstInit	Initialize list descriptor.
lstAdd	Add node to end of list.
lstConcat	Concatenate two lists.
lstCount	Report number of nodes in list.
lstDelete	Delete specified node from list.
lstExtract	Extract a sublist from a list.
lstFirst	Find first node in list.
lstGet	Get (delete and return) first node from list.
lstInsert	Insert node in list after specified node.
lstLast	Find last node in list.
lstNext	Find next node in list.
lstNth	Find Nth node in list.
lstPrevious	Find previous node in list.
lstNStep	Find the next Nth node.
lstFind	Find a node in a list.
lstFree	Free up the list.
.sp .25
.TE

.N 2 "Pipes"
.LP
Pipes are the primary VxWorks inter-task communication mechanism within a
single CPU.
They are virtual I/O devices managed by the
.Sy pipeDrv
driver.
VxWorks pipes are similar to the ``named pipe'' facility of
many UNIX systems.
A pipe consists of a single first-in-first-out data buffer.
Any task or interrupt service routines can write data to a pipe.
Any task can read data previously written.
Multiple tasks can read and write the same pipe.
Full-duplex communication between two tasks generally requires
two pipes, one for each direction.

.N 3 "Creating and Using Pipes"
.LP
Pipes are created by calling the
.Sy pipeDevCreate
routine, which specifies the name of the created pipe, the maximum number
of messages that may be queued to the pipe, and the  maximum length of each
message:
.DS
status = pipeDevCreate ("/pipe/name", maxMsgs, maxLength);
.DE
The created pipe is a normal I/O system device and is accessed with standard
I/O routines.
Tasks can
.Sy open ,
.Sy read ,
and
.Sy write
pipes, and invoke some
.Sy ioctl
functions.
Like other I/O devices, tasks block when they read from an empty pipe until
data is available, and block when they write to a full pipe until there
is space in the pipe.

.N 3 "Message Passing"
.LP
Unlike UNIX pipes,
VxWorks pipes are not necessarily simple byte streams.
Most inter-task communication in real-time systems involves
passing discrete messages between tasks, as opposed to continuous byte streams.
To support this, pipe I/O is message oriented.
.LP
Each individual
.Sy write
to a pipe is considered a single indivisible message.
Each individual
.Sy read
from a pipe de-queues the data of just a single message, even if more
data from other messages is in the pipe and more space is available in
the reader's buffer.
Moreover, if the reader does not specify a buffer large enough to contain
the entire next message as sent in a single
.Sy write ,
the reader's buffer is filled and the remainder of the message is discarded.

.N 3 "Servers and Clients with Pipes"
.LP
Real-time systems are often structured using a ``client-server''
model of tasks.
In the client-server model, ``server'' tasks accept requests from ``client''
tasks to perform some service, and usually return some reply.
The requests and replies are usually made in the form of inter-task messages.
In VxWorks, pipes are a natural way to implement this.
.LP
For example, client-server communications could be implemented as follows.
Each server task creates a pipe on which it will receive request messages from
clients.
Each client task creates a pipe on which it will receive reply messages
from servers.
Each request message includes a field containing the
.Sy fd
of the client's reply pipe.
A server task's ``main loop'' consists of reading request messages
from its request pipe, performing the request, and sending a reply message
to the client's reply pipe.
.LP
Of course, there can be many variations of this architecture,
tailored to the needs of the particular application.

.N 2 "Sockets"
.LP
In VxWorks, the basis of network communications is ``sockets''.
A socket is an endpoint for communications between tasks;
data is sent from one socket to another.
When you create a socket, you specify the communications ``protocol'' that
will be used to transmit the data.
VxWorks supports the
.I Internet
family of protocols, known as TCP, UDP, and IP.
VxWorks socket facilities are source compatible with BSD 4.3 UNIX.
.LP
One of the biggest advantages of socket communications is that it is
a very ``homogeneous'' mechanism.
Socket communications among processes are exactly the same
regardless of the location of the processes in the network,
or the operating system under which they are running.
Processes can communicate within a single CPU, across a backplane,
across an Ethernet, or across any connected combination of networks.
Socket communications can occur between VxWorks tasks and UNIX processes
in any combination.
In all cases, the communications look identical to the application,
except, of course, for the speed of the communications.
.LP
The following basic socket functions are provided by the library
.Mo sysLib(1).
Also some I/O functions can be invoked on sockets.
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Socket Functions
.sp .25
_
Call	Description
_
.sp .25
socket	Create a socket.
bind	Bind a name to a socket.
listen	Listen for connections on a socket.
accept	Accept a connection on a socket.
connect	Initiate a connection on a socket.
shutdown	Shutdown a socket connection.
send	Send data on a socket.
sendto	Send a message to a socket.
sendmsg	Send a message on a socket.
recv	Receive on a socket.
recvfrom	Receive a datagram.
recvmsg	Receive a message.
setsockopt	Set socket options.
getsockname	Get socket name.
getpeername	Get name of connected peer socket.
.sp .25
_
.sp .25
read	Read from a socket.
write	Write to a socket.
ioctl	Perform control functions on a socket.
close	Close a socket.
.sp .25
.TE

.N 3 "Transmission Control Protocol (TCP)"
.LP
The Transmission Control Protocol (TCP) provides reliable, guaranteed,
two-way transmission of data.
In a TCP communication, two sockets are ``connected'', allowing a reliable
byte-stream to flow between them in each direction.
TCP is referred to as a ``virtual circuit'' protocol, because it is as though
a circuit is created between the two sockets.
.LP
A good analogy for TCP communications is a telephone system.
Connecting two sockets is like calling from one phone to another.
After the connection is established, you simply talk and listen (write
and read data).
.LP
The following table shows the steps
in establishing socket communications with TCP,
and the analogy of each step with telephone communications.
.sp .5
.na
.TS
center,box;
cp11fB s s s
cfB | cfB | cfB | cfB
afI | afI | lw(1.8i) | lw(1.8i).
.sp .25
TCP Analogy to Telephone Communication
.sp .25
_
Task 1 Calls	Task 2 Calls	Function	Analogy
_
.sp
socket	socket	Create sockets.	Hook up telephones.
.sp
bind		Assign address to socket.	Assign telephone numbers.
.sp
listen		T{
Allow others to connect to socket.
T}	Allow others to call.
.sp
	connect	T{
Request connection to another socket.
T}	Dial another phone's number.
.sp
accept		T{
Complete connection between sockets.
T}	T{
Answer phone and establish connection.
T}
.sp
write	write	Send data to other socket.	Talk.
.sp
read	read	Receive data from other socket.	Listen.
.sp
.TE
.ad

.N 3 "User Datagram Protocol"
.LP
The User Datagram Protocol (UDP) provides a simpler but less robust way
of communicating.
In a UDP communication, data is sent between sockets in separate,
unconnected, individually addressed packets called
.I datagrams .
There is no notion of a UDP ``connection''; any UDP socket can send
to any other UDP socket at any time.
.LP
As TCP is analogous to telephone communications,
UDP is analogous to sending mail.
Each UDP packet is like a letter.
Each packet carries the address of both the destination and the sender.
Like the mail, UDP is unreliable in that
packets which are lost or out-of-sequence may not be reported.

.N 2 "Remote Procedure Calls"
.LP
Remote Procedure Call (RPC) is a facility which allows a process on
one machine to call a procedure which is executed by another process
on either the same machine or a remote machine.
Internally, RPC uses sockets as the underlying communication mechanism.
Thus with RPC, VxWorks tasks and UNIX processes can invoke routines that
are executed on other VxWorks or UNIX machines, in any combination.
.LP
As discussed in the section above on pipe communications,
many real-time systems are structured with a client-server model of tasks.
In this model, client tasks request services of server tasks, and then
wait for their reply.
RPC formalizes this model and provides a standard protocol for passing
requests and returning replies.
Also, RPC includes tools to help generate the client interface routines and
the server skeleton.
.LP
RPC is used in the implementation of several higher-level facilities,
including the Network File System (NFS) and remote source-level debugging.
.LP
RPC was originally designed by SUN Microsystems and is now in the public domain.
See the public domain RPC documentation
(supplied in source form in the directories
.Mo vw/pub/rpc3.9/doc
and
.Mo vw/pub/rpc3.9/man )
and the manual entry for
.Mo rpcLib(1)
for more information.
.LP
See the ``sprites'' demo in
.Mo vw/demo/sprites
as an example of RPC usage.

.N 2 "Signals"
.LP
VxWorks supports UNIX BSD-style
.I signals .
Signals are used to asynchronously alter the control flow of a task.
Any task or interrupt service routine can
.I raise
a signal for a particular task.
The task being signaled will immediately suspend its
current thread of execution and begin execution of a task-specified
signal handler routine, the next time the task is scheduled to run.
Signals are most appropriate for error and exception handling rather than
as a general purpose inter-task communication mechanism.
.LP
The following routines are the primary signal functions.
They are source compatible with UNIX BSD 4.3 signal functions,
hence the rather odd name of ``kill'' for the ``raise signal'' function.
For more information on these and other signal functions, see the manual
entry for
.Mo sigLib(1) .
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Signal Functions
.sp .25
_
Call	Description
_
.sp .25
sigvec	Set signal handler routine for a signal.
kill	Raise a signal.
sigsetmask	Set mask of blocked signals.
sigblock	Block a single signal.
.sp .25
.TE
In many ways, signals are analogous to hardware interrupts.
The signal facility provides a set of 31 distinct signals.
A ``signal handler'' is bound to a particular signal with
.Sy sigvec ,
in much the same way that an interrupt
service routine is connected to an interrupt vector with
.Sy intConnect .
A signal may be asserted by calling
.Sy kill .
This is analogous to the occurrence of an interrupt.
The routines
.Sy sigsetmask
and
.Sy sigblock
let signals be selectively inhibited.
.LP
Certain signals are associated with hardware exceptions.
For example, bus errors, illegal instructions, and floating point exceptions,
automatically raise specific signals.

.SP
.N 1 "INTERRUPT SERVICE CODE"
.LP
Another key facility in real-time systems is hardware interrupt handling,
since it is usually through interrupts that the system is informed of
external events.
In order to get the fastest possible response to interrupts,
interrupt handling code in VxWorks runs in a special context of its own,
outside of the context of any task.
Thus, handling an interrupt does not involve a task context switch.

.N 2 "Connecting Application Code to Interrupts"
.LP
All system hardware interrupts other than the ones used by VxWorks
are available for use by application developers.
VxWorks supplies a routine,
.Sy intConnect ,
that allows C functions to be connected to any interrupt.
The arguments to
.Sy intConnect
are the byte offset of the interrupt vector to connect to,
the address of the C function to be connected,
and an argument to be passed to the C function.
When an interrupt occurs whose vector has been established in this way,
the connected C function is called at interrupt level
with the specified argument.
To return from interrupt, the connected function simply returns.
.LP
Note that the interrupts cannot actually vector directly to C functions.
Instead, the
.Sy intConnect
routine builds a small amount of code which saves the necessary registers,
sets up the stack with the argument to be passed, calls the interrupt entry
routine
.Sy intEnt
and calls the connected function.
Upon return from the function it restores the registers and stack,
and exits by calling the interrupt exit routine
.Sy intExit .
.LP
The following interrupt functions are provided by the library
.Mo intLib(1):
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Interrupt Functions
.sp .25
_
Call	Description
_
.sp .25
intConnect	connect C routine to interrupt vector
intCount	get current interrupt nesting depth
intLock	disable interrupts
intUnlock	enable intLock
intVecBaseSet	set the vector base address
intVecBaseGet	get the vector base address
intVecSet	set an exception vector
intVecGet	get an exception vector
.sp .25
.TE

.N 2 "Interrupt Stack"
.LP
All interrupt service routine code uses the same ``interrupt stack''.
This stack is allocated and initialized by the system at start-up according
to specified configuration parameters.
It must be large enough to handle the worst possible combination of nested
interrupts.
See the chapter
.Ch CROSS-DEVELOPMENT
for details of setting the interrupt stack size.

.N 2 "Special Limitations of Interrupt Code"
.LP
Many VxWorks facilities are available to interrupt service code,
but there are some important limitations.
These limitations stem from the fact that interrupt service code does
not run in a regular task context:\ \ it has no task control block, for
example, and all interrupt service routines share a single stack.
.LP
For this reason, the basic restriction on interrupt service code is that
it must not invoke any function that might cause ``blocking'' of the
caller execution.
For example, interrupt service code must not try to take a semaphore, since if
the semaphore is not available, the kernel will try to ``block'' the caller.
However, interrupt service code may give semaphores that tasks may be waiting
on.
.LP
Similarly, in general, interrupt service code must not do I/O through
VxWorks drivers.
There is nothing in the VxWorks I/O system itself that precludes this,
but most device drivers require a task context, since they might block
the caller to wait for the device.
An important exception to this is the VxWorks pipe driver
which has been specifically designed to be writable by interrupt service code.
.LP
VxWorks supplies a logging facility (see
.Mo logLib(1) )
that allows text messages to be logged to the system console by via
a logging task.
This mechanism has been specifically designed to be callable by interrupt
service code.
This is the most common way to print out messages from interrupt service code.
.LP
All of VxWorks utility libraries, such as the linked-list and ring buffer
libraries, are usable in interrupt service code.

.N 2 "Interrupt-to-Task Communication"
.LP
While it is important that VxWorks support direct connection of interrupt
service routines that run at interrupt level,
interrupt events usually get propagated to task-level code.
Many VxWorks facilities are not available to interrupt level code,
including I/O to devices other than pipes.
The following techniques can be used to communicate from interrupt
service code to task-level code.
.sp .5
.IP "\\(bu \fBShared Memory and Ring Buffers\fP"
.br
Interrupt service code can share variables, buffers, and ring buffers
with task-level code.
.sp .5
.IP "\\(bu \fBSemaphores\fP"
.br
Interrupt service code can give semaphores that tasks can take and wait for.
.sp .5
.IP "\\(bu \fBPipes\fP"
.br
Interrupt service code can write messages to pipes that tasks can read.
Tasks and interrupt service code can write to the same pipes.
However, if the pipe is full, the message written is discarded since the
interrupt service code cannot block.
Interrupt service code must not invoke any I/O function on pipes other than
.Sy write .
.sp .5
.IP "\\(bu \fBSignals\fP"
.br
Interrupt service code can ``signal'' tasks, causing asynchronous
scheduling of their signal handlers.

.N 1 "WATCHDOG TIMERS"
.LP
VxWorks includes a watchdog timer mechanism that allows arbitrary C functions
to be connected to a specified time delay.
Watchdog timers are maintained as part of the system clock interrupt
service routine.
Thus, functions invoked by watchdog timers execute
as interrupt service code at the interrupt level of the system clock.
The restrictions on interrupt service code apply to routines connected
to watchdog timers.
.LP
The following watchdog timer functions are provided by the library
.Mo wdLib(1) :
.sp .5
.TS
center,box;
cp11fB     s
cfB        cfB
a1w(1.4i)fI aw(3i).
.sp .25
Watchdog Timer Functions
.sp .25
_
Call	Description
_
.sp .25
wdCreate	Create a watchdog timer.
wdStart	Start a watchdog timer.
wdCancel	Cancel a currently counting watchdog.
.sp .25
.TE
.LP
A watchdog timer is first created by calling the VxWorks routine
.Sy wdCreate .
Then the timer can be started by calling
.Sy wdStart ,
which takes as arguments the number of ticks to delay, the C function
to call, and an argument to be passed to that function.
After the specified number of ticks have elapsed, the C function is called
with the specified argument.
Watchdog timers can be canceled any time before the specified delay has elapsed
by calling
.Sy wdCancel .
.TO
