/* z8036.h - zilog CIO (counter,timer,parallel i/o chip) */

/*
modification history
--------------------
02a,14apr88,ak   prettied up as part of mv135 port
01a,10sep87,jcf  written
*/

#ifndef INCz8036h
#define INCz8036h


/* registers */

#define Z8036_INT(base)			((char *) (base) + 0)
#define Z8036_CONF(base)		((char *) (base) + 1)
#define Z8036_VEC_A(base)		((char *) (base) + 2)
#define Z8036_VEC_B(base)		((char *) (base) + 3)
#define Z8036_VEC_TIM(base)		((char *) (base) + 4)
#define Z8036_C_PATH(base)		((char *) (base) + 5)
#define Z8036_C_DIR(base)		((char *) (base) + 6)
#define Z8036_C_SPC(base)		((char *) (base) + 7)
#define Z8036_A_CONT(base)		((char *) (base) + 8)
#define Z8036_B_CONT(base)		((char *) (base) + 9)
#define Z8036_TIM1_CONT(base)		((char *) (base) + 10)
#define Z8036_TIM2_CONT(base)		((char *) (base) + 11)
#define Z8036_TIM3_CONT(base)		((char *) (base) + 12)
#define Z8036_A_DATA(base)		((char *) (base) + 13)
#define Z8036_B_DATA(base)		((char *) (base) + 14)
#define Z8036_C_DATA(base)		((char *) (base) + 15)
#define Z8036_TIM1_CUR_MSB(base)	((char *) (base) + 16)
#define Z8036_TIM1_CUR_LSB(base)	((char *) (base) + 17)
#define Z8036_TIM2_CUR_MSB(base)	((char *) (base) + 18)
#define Z8036_TIM2_CUR_LSB(base)	((char *) (base) + 19)
#define Z8036_TIM3_CUR_MSB(base)	((char *) (base) + 20)
#define Z8036_TIM3_CUR_LSB(base)	((char *) (base) + 21)
#define Z8036_TIM1_TC_MSB(base)		((char *) (base) + 22)
#define Z8036_TIM1_TC_LSB(base)		((char *) (base) + 23)
#define Z8036_TIM2_TC_MSB(base)		((char *) (base) + 24)
#define Z8036_TIM2_TC_LSB(base)		((char *) (base) + 25)
#define Z8036_TIM3_TC_MSB(base)		((char *) (base) + 26)
#define Z8036_TIM3_TC_LSB(base)		((char *) (base) + 27)
#define Z8036_TIM1_MODE(base)		((char *) (base) + 28)
#define Z8036_TIM2_MODE(base)		((char *) (base) + 29)
#define Z8036_TIM3_MODE(base)		((char *) (base) + 30)
#define Z8036_CUR_VEC(base)		((char *) (base) + 31)
#define Z8036_A_MODE(base)		((char *) (base) + 32)
#define Z8036_A_SHAKE(base)		((char *) (base) + 33)
#define Z8036_A_PATH(base)		((char *) (base) + 34)
#define Z8036_A_DIR(base)		((char *) (base) + 35)
#define Z8036_A_SPC(base)		((char *) (base) + 36)
#define Z8036_A_PAT_POL(base)		((char *) (base) + 37)
#define Z8036_A_PAT_TRAN(base)		((char *) (base) + 38)
#define Z8036_A_PAT_MASK(base)		((char *) (base) + 39)
#define Z8036_B_MODE(base)		((char *) (base) + 40)
#define Z8036_B_SHAKE(base)		((char *) (base) + 41)
#define Z8036_B_PATH(base)		((char *) (base) + 42)
#define Z8036_B_DIR(base)		((char *) (base) + 43)
#define Z8036_B_SPC(base)		((char *) (base) + 44)
#define Z8036_B_PAT_POL(base)		((char *) (base) + 45)
#define Z8036_B_PAT_TRAN(base)		((char *) (base) + 46)
#define Z8036_B_PAT_MASK(base)		((char *) (base) + 47)

/* Master Control register masks */

/* master interupt control register */
#define Z8036_INT_RES		0x1
#define Z8036_INT_RIGHT_JUST	0x2
#define Z8036_INT_TIM_INC_STAT	0x4
#define Z8036_INT_B_INC_STAT	0x8
#define Z8036_INT_A_INC_STAT	0x10
#define Z8036_INT_NV		0x20
#define Z8036_INT_DLC		0x40
#define Z8036_INT_MIE		0x80

/* master configuration register */
#define Z8036_CONF_IND		0x0
#define Z8036_CONF_GATES_2	0x1
#define Z8036_CONF_TRIGS_2	0x2
#define Z8036_CONF_IS_2		0x3
#define Z8036_CONF_A_ENA	0x4
#define Z8036_CONF_PLC		0x8
#define Z8036_CONF_3_ENA	0x10
#define Z8036_CONF_2_ENA	0x20
#define Z8036_CONF_1_ENA	0x40
#define Z8036_CONF_B_ENA	0x80

/* Port Specification registers */

/* Counter/Timer registers */
/* mode register */
#define Z8036_TIM_MODE_PULSE		0x0
#define Z8036_TIM_MODE_1SHOT		0x1
#define Z8036_TIM_MODE_SQUARE		0x2
#define Z8036_TIM_MODE_NOSPEC		0x3
#define Z8036_TIM_MODE_RETRIG		0x4
#define Z8036_TIM_MODE_EXT_GATE_ENA	0x8
#define Z8036_TIM_MODE_EXT_TRIG_ENA	0x10
#define Z8036_TIM_MODE_EXT_COUNT_ENA	0x20
#define Z8036_TIM_MODE_EXT_OUTPUT_ENA	0x40
#define Z8036_TIM_MODE_CONT		0x80

/* command register */
#define Z8036_TIM_CONT_CIP	0x0	/* read only */
#define Z8036_TIM_CONT_TRIG	0x2
#define Z8036_TIM_CONT_GATE	0x4
#define Z8036_TIM_CONT_RCC	0x8	/* read only */
#define Z8036_TIM_CONT_INT_ERR	0x10	/* read only */
#define Z8036_TIM_CONT_IP	0x20	/* read only */
#define Z8036_TIM_CONT_IE	0x40	/* read only */
#define Z8036_TIM_CONT_IUS	0x80	/* read only */

/* command bits */
#define Z8036_CONT_INT_DIS	0xe0	/* clear interupt enable */
#define Z8036_CONT_CLR_IP_IUS	0x20	/* clear interupt under service 
					 * and interupt pending */
#define Z8036_CONT_INT_EN	0xc0	/* set interupt enable */

#endif
